/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.panel;

import javaforce.webui.Button;
import javaforce.webui.Color;
import javaforce.webui.Component;
import javaforce.webui.GridLayout;
import javaforce.webui.InnerPanel;
import javaforce.webui.Label;
import javaforce.webui.Panel;
import javaforce.webui.TextField;
import javaforce.webui.WebUIClient;

public class LoginPanel
extends Panel {
    public LoginPanel(String appName, boolean show_username, Login login, WebUIClient client) {
        this.init(appName, show_username, login, client);
    }

    public LoginPanel(String appName, WebUIClient client) {
        this.init(appName, true, null, client);
    }

    private void init(String appName, boolean show_username, Login login, WebUIClient client) {
        this.removeClass("column");
        InnerPanel inner = new InnerPanel(appName + " Login");
        inner.setMaxWidth();
        inner.setMaxHeight();
        this.setAlign(2);
        Label msg = new Label("");
        msg.setColor(Color.red);
        inner.add(msg);
        GridLayout grid = new GridLayout(2, 0, new int[]{3, 1});
        grid.setAlign(2);
        inner.add(grid);
        TextField username = new TextField("");
        if (show_username) {
            grid.addRow(new Component[]{new Label("Username"), username});
        }
        TextField password = new TextField("");
        password.setPassword(true);
        grid.addRow(new Component[]{new Label("Password"), password});
        Button button_login = new Button("Login");
        inner.add(button_login);
        username.addKeyDownListener((ke, cmp) -> {
            if (ke.keyCode == 10) {
                password.setFocus();
            }
        });
        password.addKeyDownListener((ke, cmp) -> {
            if (ke.keyCode == 10) {
                button_login.click();
            }
        });
        button_login.addClickListener((m, c) -> {
            msg.setText("");
            String user = username.getText();
            String pass = password.getText();
            boolean success = false;
            success = login == null ? client.getAccessControl().login(user, pass) : login.login(user, pass);
            if (success) {
                client.setProperty("user", user);
                client.setProperty("groups", client.getAccessControl().getGroups(user));
                client.refresh();
            } else {
                msg.setText("Wrong password");
            }
        });
        this.add(inner);
    }

    public static interface Login {
        public boolean login(String var1, String var2);
    }
}

