/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.tasks;

import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.webui.Panel;
import javaforce.webui.tasks.Task;
import javaforce.webui.tasks.TaskEvent;
import javaforce.webui.tasks.TaskLog;
import javaforce.webui.tasks.TaskUI;

public class Tasks
extends Thread {
    private Object lock = new Object();
    private ArrayList<Task> taskList = new ArrayList();
    private ArrayList<Task> waiting = new ArrayList();
    private boolean active = true;
    private boolean sequential = false;
    private TaskLog log;
    public static Tasks tasks;
    public static final int TASK_RUNNING = 0;
    public static final int TASK_SUCCESSFUL = 1;
    public static final int TASK_FAILED = 2;
    public static final int TASK_NOT_FOUND = 3;
    private static final long time_cut_time = 300000L;

    public static void init() {
        if (tasks != null) {
            return;
        }
        tasks = new Tasks();
        tasks.start();
    }

    public static void init(String tasks_log_folder) {
        if (tasks != null) {
            return;
        }
        tasks = new Tasks();
        Tasks.tasks.log = new TaskLog(tasks_log_folder);
        tasks.start();
    }

    public void cancel() {
        this.active = false;
    }

    public static Tasks getTasks() {
        return tasks;
    }

    public TaskLog getTaskLog() {
        return this.log;
    }

    public void setSequential(boolean state) {
        this.sequential = state;
    }

    private void addUI(Task task) {
        task.taskui = new TaskUI(task.event);
        if (task.tasks != null) {
            task.tasks.add(0, task.taskui);
        }
    }

    private boolean busy() {
        if (this.waiting.size() > 0) {
            return true;
        }
        for (Task task : this.taskList) {
            if (!task.running) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Panel ui_tasks, Task task) {
        task.tasks = ui_tasks;
        task.event.time_start = System.currentTimeMillis();
        task.event.result = "";
        this.addUI(task);
        if (this.log != null) {
            this.log.add(task.event);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.sequential) {
                if (this.busy()) {
                    this.waiting.add(task);
                } else {
                    task.running = true;
                    this.taskList.add(task);
                    task.start();
                }
            } else {
                task.running = true;
                this.taskList.add(task);
                task.start();
            }
        }
    }

    private void updateUI(Task task) {
        task.taskui.update(task.event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(Task task) {
        task.event.time_complete = System.currentTimeMillis();
        task.event.time_duration = task.event.time_complete - task.event.time_start;
        Object object = this.lock;
        synchronized (object) {
            task.running = false;
            if (this.sequential && this.waiting.size() > 0) {
                Task next = this.waiting.remove(0);
                next.running = true;
                this.taskList.add(next);
                next.start();
            }
        }
        if (this.log != null) {
            this.log.complete(task.event);
        }
        this.updateUI(task);
        JFLog.log("Task completed:" + task.event.action + ":result=" + (task.event.successful ? "success" : "fail") + ":" + task.event.result);
    }

    public void wait(Task task) {
        while (task.event.time_complete == 0L) {
            JF.sleep(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Task task) {
        Object object = this.lock;
        synchronized (object) {
            this.taskList.remove(task);
        }
        if (task.tasks != null) {
            task.tasks.remove(task.taskui);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getTaskComplete(long task_id) {
        Object object = this.lock;
        synchronized (object) {
            for (Task task : this.taskList) {
                if (task.event.task_id != task_id) continue;
                return task.event.time_complete != 0L;
            }
        }
        if (this.log == null) {
            return false;
        }
        return this.log.getTaskCompleted(task_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskEvent getTaskEvent(long task_id) {
        Object object = this.lock;
        synchronized (object) {
            for (Task task : this.taskList) {
                if (task.event.task_id != task_id) continue;
                return task.event;
            }
        }
        if (this.log == null) {
            return null;
        }
        return this.log.getTaskEvent(task_id);
    }

    public int getTaskStatus(long task_id) {
        TaskEvent event = this.getTaskEvent(task_id);
        if (event == null) {
            return 3;
        }
        if (event.time_complete == 0L) {
            return 0;
        }
        if (event.successful) {
            return 1;
        }
        return 2;
    }

    public String getTaskResult(long task_id) {
        TaskEvent event = this.getTaskEvent(task_id);
        if (event == null) {
            return null;
        }
        return event.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.active) {
            JF.sleep(1000);
            long time_now = System.currentTimeMillis();
            long time_cut = time_now - 300000L;
            ArrayList<Task> remove = new ArrayList<Task>();
            Object object = this.lock;
            synchronized (object) {
                for (Task task : this.taskList) {
                    if (task.event.time_complete == 0L || task.event.time_complete >= time_cut) continue;
                    remove.add(task);
                }
                for (Task task : remove) {
                    this.removeTask(task);
                }
            }
            if (this.log == null) continue;
            this.log.purge();
        }
    }
}

