package javaforce.awt;

/** VNC server config App
 *
 * @author pquiring
 *
 * Created : Nov 16, 2013
 */

import java.io.*;
import java.util.*;

import javaforce.*;
import javaforce.awt.*;
import javaforce.jbus.*;

public class VNCApp extends javax.swing.JFrame {

  private static boolean debug = false;

  /**
   * Creates new form VNCApp
   */
  public VNCApp() {
    initComponents();
    //create tray icon to open app
    JFImage img = new JFImage();
    img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/vnc.png"));
    new Thread() {
      public void run() {
        Random r = new Random();
        busClient = new JBusClient(VNCServer.busPack + ".client" + r.nextInt(), new JBusMethods());
        busClient.setPort(VNCServer.getBusPort());
        busClient.start();
        busClient.call(VNCServer.busPack, "getConfig", JBusClient.quote(busClient.pack));
      }
    }.start();
    JFAWT.centerWindow(this);
  }

  public void writeConfig() {
    busClient.call(VNCServer.busPack, "setConfig", busClient.quote(busClient.encodeString(config.getText())));
  }

  public void restart() {
    busClient.call(VNCServer.busPack, "restart", "");
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    save = new javax.swing.JButton();
    jScrollPane1 = new javax.swing.JScrollPane();
    config = new javax.swing.JTextArea();
    jLabel1 = new javax.swing.JLabel();
    bViewLog = new javax.swing.JButton();
    bStatus = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
    setTitle("VNC Server");

    save.setText("Save");
    save.setEnabled(false);
    save.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        saveActionPerformed(evt);
      }
    });

    config.setColumns(20);
    config.setRows(5);
    config.setText(" [ loading ... ]");
    config.setEnabled(false);
    jScrollPane1.setViewportView(config);

    jLabel1.setText("VNC Configuration:");

    bViewLog.setText("View Log");
    bViewLog.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        bViewLogActionPerformed(evt);
      }
    });

    bStatus.setText("Status");
    bStatus.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        bStatusActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 583, Short.MAX_VALUE)
          .addGroup(layout.createSequentialGroup()
            .addComponent(bViewLog)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(bStatus)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(save))
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel1)
            .addGap(0, 0, Short.MAX_VALUE)))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(jLabel1)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 424, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(save)
          .addComponent(bViewLog)
          .addComponent(bStatus))
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void saveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveActionPerformed
    writeConfig();
    restart();
    JFAWT.showMessage("Notice", "Settings saved!");
  }//GEN-LAST:event_saveActionPerformed

  private void bViewLogActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bViewLogActionPerformed
    showViewLog();
  }//GEN-LAST:event_bViewLogActionPerformed

  private void bStatusActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bStatusActionPerformed
    showViewStatus();
  }//GEN-LAST:event_bStatusActionPerformed

  /**
   * @param args the command line arguments
   */
  public static void main(String[] args) {
    /* Create and display the form */
    java.awt.EventQueue.invokeLater(new Runnable() {
      public void run() {
        new VNCApp().setVisible(true);
      }
    });
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton bStatus;
  private javax.swing.JButton bViewLog;
  private javax.swing.JTextArea config;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JButton save;
  // End of variables declaration//GEN-END:variables

  public ViewLog viewLog;
  public ViewLog viewStatus;

  public void showViewLog() {
    if (viewLog == null || viewLog.isClosed) {
      viewLog = new ViewLog(new File(VNCServer.getLogFile()));
      viewLog.setTitle("VNC Log");
    }
    viewLog.setVisible(true);
  }

  public void showViewStatus() {
    if (viewStatus == null || viewStatus.isClosed()) {
      viewStatus = new ViewLog("loading");
      viewStatus.setTitle("VNC Status");
      viewStatus.setRefresh(new Runnable() {
        public void run() {
          requestStatus();
        }
      });
      requestStatus();
      viewStatus.setVisible(true);
    }
  }

  public void requestStatus() {
    busClient.call(VNCServer.busPack, "getStatus", JBusClient.quote(busClient.pack));
  }

  public JBusClient busClient;

  public class JBusMethods {
    public void getConfig(String cfg) {
      final String _cfg = cfg;
      java.awt.EventQueue.invokeLater(new Runnable() {
        public void run() {
          config.setText(JBusClient.decodeString(_cfg));
          config.setEnabled(true);
          save.setEnabled(true);
        }
      });
    }
    public void getStatus(String status) {
      if (debug) JFLog.log("gotStatus=" + status);
      status = JBusClient.decodeString(status);
      if (viewStatus != null) {
        viewStatus.setText(status);
      }
    }
  }
}
