/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.client;

import java.awt.Color;
import javaforce.ASCII8;
import javaforce.JFLog;
import javaforce.ansi.client.Screen;

public class ANSI {
    public static boolean debug = false;
    public static final char ESC = '\u001b';
    public static final int[][] clrs = new int[][]{{0, 0x880000, 34816, 0x888800, 136, 0x880088, 34952, 0x888888}, {0x444444, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF}};
    public boolean altfnt = false;
    public boolean keypadMode = false;
    public char altcode = (char)91;
    public int high = 0;
    private int savedx = -1;
    private int savedy = -1;
    private Color orgForeColor;
    private Color orgBackColor;
    private boolean telnet;
    public int numc;
    public int[] nums = new int[16];
    private static char[] altfntchars = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00b1', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00d9', '\u00bf', '\u00da', '\u00c0', '\u0000', '\u0000', '\u0000', '\u00c4', '\u0000', '\u0000', '\u00c3', '\u00b4', '\u00c1', '\u00c2', '\u00b3', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};

    public ANSI(Screen screen, boolean telnet) {
        this.orgForeColor = new Color(screen.getForeColor());
        this.orgBackColor = new Color(screen.getBackColor());
    }

    public char encodeChar(char ch) {
        if (!this.altfnt) {
            if (ch > '\u007f' && ch < '\u0100') {
                ch = ASCII8.convert(ch);
            }
            return ch;
        }
        char ret = altfntchars[ch];
        if (ret == '\u0000') {
            ret = ch;
        }
        if (ret > '\u007f' && ret < '\u0100') {
            ret = ASCII8.convert(ret);
        }
        return ret;
    }

    public char[] encodeString(char[] buf, int buflen) {
        char[] ret = new char[buflen];
        for (int a = 0; a < buflen; ++a) {
            ret[a] = this.encodeChar(buf[a]);
        }
        return ret;
    }

    public void keyPressed(int keyCode, int keyMods, Screen screen) {
        Object str = null;
        if (debug) {
            JFLog.log("ANSI.keyPressed:keyCode=" + keyCode + ",mods=" + keyMods);
        }
        if (keyMods == 128) {
            if (keyCode >= 65 && keyCode <= 90) {
                str = "" + (char)(keyCode - 65 + 1);
            }
            switch (keyCode) {
                case 38: {
                    str = "\u001b" + this.altcode + "1;5A";
                    break;
                }
                case 40: {
                    str = "\u001b" + this.altcode + "1;5B";
                    break;
                }
                case 39: {
                    str = "\u001b" + this.altcode + "1;5C";
                    break;
                }
                case 37: {
                    str = "\u001b" + this.altcode + "1;5D";
                }
            }
        }
        if (keyMods == 512) {
            switch (keyCode) {
                case 38: {
                    str = "\u001b" + this.altcode + "1;3A";
                    break;
                }
                case 40: {
                    str = "\u001b" + this.altcode + "1;3B";
                    break;
                }
                case 39: {
                    str = "\u001b" + this.altcode + "1;3C";
                    break;
                }
                case 37: {
                    str = "\u001b" + this.altcode + "1;3D";
                }
            }
        }
        if (keyMods == 64) {
            switch (keyCode) {
                case 38: {
                    str = "\u001b" + this.altcode + "1;2A";
                    break;
                }
                case 40: {
                    str = "\u001b" + this.altcode + "1;2B";
                    break;
                }
                case 39: {
                    str = "\u001b" + this.altcode + "1;2C";
                    break;
                }
                case 37: {
                    str = "\u001b" + this.altcode + "1;2D";
                    break;
                }
                case 112: {
                    str = "\u001b[25~";
                    break;
                }
                case 113: {
                    str = "\u001b[26~";
                    break;
                }
                case 114: {
                    str = "\u001b[28~";
                    break;
                }
                case 115: {
                    str = "\u001b[29~";
                    break;
                }
                case 116: {
                    str = "\u001b[31~";
                    break;
                }
                case 117: {
                    str = "\u001b[32~";
                    break;
                }
                case 118: {
                    str = "\u001b[33~";
                    break;
                }
                case 119: {
                    str = "\u001b[34~";
                }
            }
        }
        if (str != null) {
            if (debug) {
                JFLog.log("ANSI:" + (String)str);
            }
            screen.output(((String)str).toCharArray());
        }
        if (keyMods != 0) {
            return;
        }
        switch (keyCode) {
            case 38: {
                str = "\u001b" + this.altcode + "A";
                break;
            }
            case 40: {
                str = "\u001b" + this.altcode + "B";
                break;
            }
            case 39: {
                str = "\u001b" + this.altcode + "C";
                break;
            }
            case 37: {
                str = "\u001b" + this.altcode + "D";
                break;
            }
            case 36: {
                str = "\u001b[H";
                break;
            }
            case 35: {
                str = "\u001b[F";
                break;
            }
            case 112: {
                str = "\u001b" + this.altcode + "P";
                break;
            }
            case 113: {
                str = "\u001b" + this.altcode + "Q";
                break;
            }
            case 114: {
                str = "\u001b" + this.altcode + "R";
                break;
            }
            case 115: {
                str = "\u001b" + this.altcode + "S";
                break;
            }
            case 116: {
                if (this.telnet) {
                    str = "\u00ff\u00f3";
                    break;
                }
                str = "\u001b[15~";
                break;
            }
            case 117: {
                str = "\u001b[17~";
                break;
            }
            case 118: {
                str = "\u001b[18~";
                break;
            }
            case 119: {
                str = "\u001b[19~";
                break;
            }
            case 120: {
                str = "\u001b[20~";
                break;
            }
            case 121: {
                str = "\u001b[21~";
                break;
            }
            case 122: {
                str = "\u001b[23~";
                break;
            }
            case 123: {
                str = "\u001b[24~";
                break;
            }
            case 127: {
                str = "\u001b[3~";
                break;
            }
            case 33: {
                str = "\u001b[5~";
                break;
            }
            case 34: {
                str = "\u001b[6~";
                break;
            }
            case 19: {
                str = "\u00ff\u00f3";
            }
        }
        if (str != null) {
            if (debug) {
                JFLog.log("ANSI:" + (String)str);
            }
            screen.output(((String)str).toCharArray());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean decode(char[] code, int codelen, Screen screen) {
        if (debug) {
            JFLog.log("ANSI.decode:" + codelen);
        }
        int x = screen.getx();
        int y = screen.gety();
        if (codelen < 2) {
            return false;
        }
        switch (code[1]) {
            case 'H': {
                JFLog.log("ANSI:Not implemented:" + code[1]);
                return true;
            }
            case 'M': {
                if (y <= screen.gety1()) {
                    screen.scrollDown(1);
                    return true;
                }
                screen.gotoPos(x, y - 1);
                return true;
            }
            case 'D': {
                if (y >= screen.gety2()) {
                    screen.scrollUp(1);
                    return true;
                }
                screen.gotoPos(x, y + 1);
                return true;
            }
            case '7': {
                this.savedx = x;
                this.savedy = y;
                return true;
            }
            case '8': {
                if (this.savedx == -1) {
                    return true;
                }
                screen.gotoPos(this.savedx, this.savedy);
                return true;
            }
            case '=': {
                this.keypadMode = true;
                return true;
            }
            case '>': {
                this.keypadMode = false;
                return true;
            }
            case '#': 
            case '(': 
            case '[': 
            case ']': 
            case 'c': {
                break;
            }
            default: {
                JFLog.log("ANSI:Unknown code:" + code[1]);
                return true;
            }
        }
        if (codelen < 3) {
            return false;
        }
        switch (code[1]) {
            case '#': {
                return true;
            }
            case '(': {
                switch (code[2]) {
                    case 'A': {
                        this.altfnt = false;
                        return true;
                    }
                    case 'B': {
                        this.altfnt = false;
                        return true;
                    }
                    case '0': {
                        this.altfnt = true;
                        return true;
                    }
                    case '1': {
                        this.altfnt = false;
                        return true;
                    }
                    case '2': {
                        this.altfnt = false;
                        return true;
                    }
                }
                return true;
            }
            case ']': {
                if (code[codelen - 1] == '\u0007') {
                    return true;
                }
                if (code[codelen - 2] != '\u001b') return false;
                if (code[codelen - 1] != '\\') return false;
                return true;
            }
            case '[': {
                char cmd = code[codelen - 1];
                if (!(cmd >= 'A' && cmd <= 'Z' || cmd >= 'a' && cmd <= 'z' || cmd == '~' || cmd == '@')) {
                    return false;
                }
                if (code[2] == '?') {
                    this.decodeNums(code, codelen, 3);
                    switch (cmd) {
                        case 'h': {
                            int a = 0;
                            while (a < this.numc) {
                                switch (this.nums[a]) {
                                    case 1: {
                                        this.altcode = (char)79;
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    case 4: {
                                        break;
                                    }
                                    case 7: {
                                        screen.setAutoWrap(false);
                                        break;
                                    }
                                    case 12: {
                                        break;
                                    }
                                    case 25: {
                                        break;
                                    }
                                    case 69: {
                                        break;
                                    }
                                    case 1002: {
                                        break;
                                    }
                                    case 1006: {
                                        break;
                                    }
                                    case 1049: {
                                        break;
                                    }
                                    case 2004: {
                                        break;
                                    }
                                    default: {
                                        JFLog.log("ANSI:Unknown [ ? h:" + this.nums[a]);
                                    }
                                }
                                ++a;
                            }
                            return true;
                        }
                        case 'l': {
                            int a = 0;
                            while (a < this.numc) {
                                switch (this.nums[a]) {
                                    case 1: {
                                        this.altcode = (char)91;
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    case 4: {
                                        break;
                                    }
                                    case 7: {
                                        screen.setAutoWrap(true);
                                        break;
                                    }
                                    case 12: {
                                        break;
                                    }
                                    case 25: {
                                        break;
                                    }
                                    case 69: {
                                        break;
                                    }
                                    case 1002: {
                                        break;
                                    }
                                    case 1006: {
                                        break;
                                    }
                                    case 1049: {
                                        break;
                                    }
                                    case 2004: {
                                        break;
                                    }
                                    default: {
                                        JFLog.log("ANSI:Unknown [ ? l:" + this.nums[a]);
                                    }
                                }
                                ++a;
                            }
                            return true;
                        }
                        case 's': {
                            break;
                        }
                        case 'r': {
                            break;
                        }
                        default: {
                            JFLog.log("ANSI:Unknown [ ? code:" + code[codelen - 1]);
                            return true;
                        }
                    }
                }
                this.decodeNums(code, codelen, 2);
                block55 : switch (cmd) {
                    case 'J': {
                        if (this.numc == 0) {
                            this.nums[0] = 0;
                        }
                        switch (this.nums[0]) {
                            case 0: {
                                for (int a = x; a <= screen.getsx(); ++a) {
                                    screen.setChar(a, y, ' ');
                                }
                                int b = y + 1;
                                while (b <= screen.getsy()) {
                                    for (int a = 1; a <= screen.getsx(); ++a) {
                                        screen.setChar(a, b, ' ');
                                    }
                                    ++b;
                                }
                                return true;
                            }
                            case 1: {
                                for (int a = 1; a < x; ++a) {
                                    screen.setChar(a, y, ' ');
                                }
                                int b = 1;
                                while (b < y) {
                                    for (int a = 1; a <= screen.getsx(); ++a) {
                                        screen.setChar(a, b, ' ');
                                    }
                                    ++b;
                                }
                                return true;
                            }
                            case 2: {
                                screen.clrscr();
                            }
                        }
                        return true;
                    }
                    case 'K': {
                        if (this.numc == 0) {
                            this.nums[0] = 0;
                        }
                        switch (this.nums[0]) {
                            case 0: {
                                int a = x;
                                while (a <= screen.getsx()) {
                                    screen.setChar(a, y, ' ');
                                    ++a;
                                }
                                return true;
                            }
                            case 1: {
                                int a = 1;
                                while (a < x) {
                                    screen.setChar(a, y, ' ');
                                    ++a;
                                }
                                return true;
                            }
                            case 2: {
                                int a = 1;
                                while (a <= screen.getsx()) {
                                    screen.setChar(a, y, ' ');
                                    ++a;
                                }
                                return true;
                            }
                        }
                        return true;
                    }
                    case 'H': 
                    case 'f': {
                        if (this.numc == 2 && this.nums[1] == 0) {
                            this.numc = 1;
                        }
                        if (this.numc == 1 && this.nums[0] == 0) {
                            this.numc = 0;
                        }
                        switch (this.numc) {
                            case 2: {
                                screen.gotoPos(this.min(screen.getsx(), this.nums[1]), this.min(screen.getsy(), this.nums[0]));
                                break block55;
                            }
                            case 1: {
                                screen.gotoPos(1, this.min(screen.getsy(), this.nums[0]));
                                break block55;
                            }
                            case 0: {
                                screen.gotoPos(1, 1);
                                return true;
                            }
                        }
                        break;
                    }
                    case 'A': {
                        if (this.numc == 0) {
                            this.nums[0] = 1;
                        }
                        if (y - this.nums[0] > 1) {
                            screen.gotoPos(x, y - this.nums[0]);
                        } else {
                            screen.gotoPos(x, 1);
                        }
                        break;
                    }
                    case 'B': {
                        if (this.numc == 0) {
                            this.nums[0] = 1;
                        }
                        if (y + this.nums[0] < screen.getsy()) {
                            screen.gotoPos(x, y + this.nums[0]);
                        } else {
                            screen.gotoPos(x, screen.getsy());
                        }
                        break;
                    }
                    case 'C': {
                        if (this.numc == 0) {
                            this.nums[0] = 1;
                        }
                        if (x + this.nums[0] < screen.getsx()) {
                            screen.gotoPos(x + this.nums[0], y);
                        } else {
                            screen.gotoPos(screen.getsx(), y);
                        }
                        break;
                    }
                    case 'D': {
                        if (this.numc == 0) {
                            this.nums[0] = 1;
                        }
                        if (x - this.nums[0] > 1) {
                            screen.gotoPos(x - this.nums[0], y);
                        } else {
                            screen.gotoPos(1, y);
                        }
                        break;
                    }
                    case 'L': {
                        if (y < screen.gety1()) return true;
                        if (y > screen.gety2()) return true;
                        if (this.numc == 0) {
                            this.nums[0] = 1;
                        }
                        int oy1 = screen.gety1();
                        screen.sety1(y);
                        screen.scrollDown(this.nums[0]);
                        screen.sety1(oy1);
                        break;
                    }
                    case 'r': {
                        if (this.numc != 2) return true;
                        screen.sety1(this.nums[0]);
                        screen.sety2(this.nums[1]);
                        break;
                    }
                    case 'm': {
                        int a;
                        if (this.numc == 0) {
                            this.numc = 1;
                            this.nums[0] = 0;
                        }
                        for (a = 0; a < this.numc; ++a) {
                            if (this.nums[a] == 1) {
                                this.high = 1;
                                continue;
                            }
                            if (this.nums[a] != 2) continue;
                            this.high = 0;
                        }
                        a = 0;
                        while (a < this.numc) {
                            if (this.nums[a] == 0) {
                                this.high = 0;
                                screen.setBlinker(false);
                                screen.setReverse(false);
                                screen.setForeColor(this.orgForeColor.getRGB());
                                screen.setBackColor(this.orgBackColor.getRGB());
                            } else if (this.nums[a] == 5) {
                                screen.setBlinker(true);
                            } else if (this.nums[a] == 7) {
                                screen.setReverse(true);
                            } else if (this.nums[a] == 25) {
                                screen.setBlinker(false);
                            } else if (this.nums[a] == 27) {
                                screen.setReverse(false);
                            } else if (this.nums[a] >= 30 && this.nums[a] <= 37) {
                                screen.setForeColor(clrs[this.high][this.nums[a] - 30]);
                            } else {
                                if (this.nums[a] == 38) {
                                    if (this.numc <= 3) return true;
                                    int r = this.nums[this.numc - 3];
                                    int g = this.nums[this.numc - 2];
                                    int b = this.nums[this.numc - 1];
                                    screen.setForeColor(r << 16 | g << 8 | b);
                                    break block55;
                                }
                                if (this.nums[a] == 39) {
                                    screen.setForeColor(this.orgForeColor.getRGB());
                                } else if (this.nums[a] >= 40 && this.nums[a] <= 47) {
                                    screen.setBackColor(clrs[0][this.nums[a] - 40]);
                                } else {
                                    if (this.nums[a] == 48) {
                                        if (this.numc <= 3) return true;
                                        int r = this.nums[this.numc - 3];
                                        int g = this.nums[this.numc - 2];
                                        int b = this.nums[this.numc - 1];
                                        screen.setBackColor(r << 16 | g << 8 | b);
                                        break block55;
                                    }
                                    if (this.nums[a] == 49) {
                                        screen.setBackColor(this.orgBackColor.getRGB());
                                    }
                                }
                            }
                            ++a;
                        }
                        return true;
                    }
                    case 'n': {
                        if (this.numc != 1) return true;
                        if (this.nums[0] != 6) return true;
                        String str = "\u001b[" + screen.gety() + ";" + screen.getx() + "R";
                        screen.output(str.toCharArray());
                        break;
                    }
                    case 'P': {
                        if (this.numc == 0) {
                            this.numc = 1;
                            this.nums[0] = 1;
                        }
                        int cnt = 0;
                        while (cnt < this.nums[0]) {
                            screen.delete();
                            ++cnt;
                        }
                        return true;
                    }
                    case '@': {
                        if (this.numc == 0) {
                            this.numc = 1;
                            this.nums[0] = 1;
                        }
                        int cnt = 0;
                        while (cnt < this.nums[0]) {
                            screen.insert();
                            ++cnt;
                        }
                        return true;
                    }
                    case 's': {
                        this.savedx = screen.getx();
                        this.savedy = screen.gety();
                        break;
                    }
                    case 'u': {
                        if (this.savedx == -1) {
                            return true;
                        }
                        screen.gotoPos(this.savedx, this.savedy);
                        break;
                    }
                    case 'g': {
                        break;
                    }
                    case 'd': {
                        if (this.numc == 0) {
                            this.nums[0] = 1;
                        }
                        screen.gotoPos(x, this.nums[0]);
                        break;
                    }
                    case 'e': {
                        if (this.numc == 0) {
                            this.nums[0] = 1;
                        }
                        screen.gotoPos(x, y + this.nums[0]);
                        break;
                    }
                    case 'G': {
                        if (this.numc == 0) {
                            this.nums[0] = 1;
                        }
                        screen.gotoPos(this.nums[0], y);
                        break;
                    }
                    case 'X': {
                        if (this.numc == 0) {
                            this.nums[0] = 1;
                        }
                        int cnt = this.nums[0];
                        while (cnt > 0) {
                            screen.setChar(x, y, ' ');
                            if (++x == screen.getsx() + 1) {
                                x = 1;
                                if (++y == screen.getsy() + 1) return true;
                            }
                            --cnt;
                        }
                        return true;
                    }
                }
                return true;
            }
        }
        return true;
    }

    private void decodeNums(char[] code, int codelen, int start) {
        int c = start;
        this.numc = 0;
        code[codelen] = 120;
        while (c < codelen) {
            while (code[c] == ';' || code[c] == ',') {
                this.nums[this.numc++] = 0;
                ++c;
            }
            if (code[c] < '0' || code[c] > '9') break;
            int s = c;
            while (code[c] >= '0' && code[c] <= '9') {
                ++c;
            }
            int e = c;
            int t = 0;
            int m = 1;
            while (c != s) {
                t += (code[--c] - 48) * m;
                m *= 10;
            }
            this.nums[this.numc++] = t;
            c = e;
            if (code[c] != ';' && code[c] != ',') continue;
            ++c;
        }
    }

    private int min(int v1, int v2) {
        if (v1 < v2) {
            return v1;
        }
        return v2;
    }

    private int max(int v1, int v2) {
        if (v1 > v2) {
            return v1;
        }
        return v2;
    }
}

