/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.client;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ansi.client.ANSI;
import javaforce.ansi.client.Line;
import javaforce.ansi.client.Profile;
import javaforce.ansi.client.Screen;
import javaforce.ansi.client.Script;
import javaforce.ansi.client.TelnetDecoder;
import javaforce.ansi.client.UTF8;
import javaforce.awt.GetPassword;
import javaforce.io.ComPort;
import javaforce.jni.lnx.LnxPty;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JComponent;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;

public class Buffer
implements Screen {
    public Profile profile;
    public UI ui;
    public int sx;
    public int sy;
    private int y1;
    private int y2;
    public Script script = null;
    private volatile boolean ready = false;
    private Object lock;
    private final int RenderPriority = 9;
    private Reader reader;
    private final int ReaderPriority = 9;
    private InputStream in;
    private OutputStream out;
    private Socket s;
    private SshClient client;
    private ClientSession session;
    private ClientChannel channel;
    private SSLSocket ssl;
    public int scrollBack;
    private TelnetDecoder telnet;
    public ANSI ansi;
    private UTF8 utf8;
    private char[] code = new char[64];
    private int codelen = 0;
    private final char IAC = (char)255;
    private final char ESC = (char)27;
    public Line[] lines = null;
    public int cx;
    public int cy;
    private Timer timer;
    private int foreColor;
    private int backColor;
    public boolean cursorShown = false;
    public int selectStartY = -1;
    public int selectEndY = -1;
    public int selectStartX = -1;
    public int selectEndX = -1;
    public FileOutputStream fos;
    private boolean blinker = false;
    private boolean reverse = false;
    public boolean blinkerShown = false;
    public boolean connected = false;
    public boolean failed = false;
    private Frame parent;
    private boolean eol = false;
    public boolean closed = false;
    private boolean init = false;
    private LnxPty pty;
    private boolean autowrap = true;
    private ComPort com;

    public Buffer(Profile profile, UI ui) {
        this.profile = profile;
        this.ui = ui;
    }

    public void init() {
        JFLog.log("Buffer.init start");
        try {
            this.lock = new Object();
            this.scrollBack = this.profile.scrollBack;
            this.foreColor = this.profile.foreColor;
            this.backColor = this.profile.backColor;
            this.ansi = new ANSI(this, this.profile.protocol.equals("telnet"));
            this.telnet = new TelnetDecoder();
            this.utf8 = new UTF8();
            this.sx = this.profile.sx;
            this.sy = this.profile.sy;
            if (this.sx < 80) {
                this.sx = 80;
            }
            if (this.sy < 25) {
                this.sy = 25;
            }
            JFLog.log("Screen Size:" + this.sx + "," + this.sy);
            this.y1 = 0;
            this.y2 = this.sy - 1;
            int ty = this.sy + this.scrollBack;
            this.lines = new Line[ty];
            for (int y = 0; y < ty; ++y) {
                this.lines[y] = new Line(this.sx, this.profile.foreColor, this.profile.backColor);
            }
            this.gotoPos(1, 1);
            this.init = true;
            this.ready = true;
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Buffer.this.timer();
                }
            }, 500L, 500L);
            this.reader = new Reader();
            this.reader.setPriority(9);
            this.reader.start();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        JFLog.log("Buffer.init done");
    }

    public byte[] char2byte(char[] buf, int buflen) {
        byte[] tmp = new byte[buflen];
        for (int a = 0; a < buflen; ++a) {
            tmp[a] = (byte)buf[a];
        }
        return tmp;
    }

    public char[] byte2char(byte[] buf, int buflen) {
        char[] tmp = new char[buflen];
        int a = 0;
        while (a < buflen) {
            tmp[a] = (char)buf[a];
            int n = a++;
            tmp[n] = (char)(tmp[n] & 0xFF);
        }
        return tmp;
    }

    @Override
    public void output(char[] buf) {
        block3: {
            if (this.profile.localEcho) {
                this.input(buf, buf.length);
            }
            byte[] tmp = this.char2byte(buf, buf.length);
            try {
                this.out.write(tmp);
                this.out.flush();
            }
            catch (Exception e) {
                JFLog.log(e);
                if (this.closed) break block3;
                this.ui.close();
            }
        }
    }

    public void output(char ch) {
        block3: {
            if (this.profile.localEcho) {
                this.input(ch);
            }
            try {
                this.out.write(new byte[]{(byte)ch});
                this.out.flush();
            }
            catch (Exception e) {
                JFLog.log(e);
                if (this.closed) break block3;
                this.ui.close();
            }
        }
    }

    private void input(String str) {
        this.input(str.toCharArray(), str.length());
    }

    private void input(char ch) {
        char[] tmp = new char[]{ch};
        this.input(tmp, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void input(char[] buf, int buflen) {
        if (this.fos != null) {
            byte[] tmp = this.char2byte(buf, buflen);
            JF.write(this.fos, tmp, 0, tmp.length);
        }
        Object object = this.lock;
        synchronized (object) {
            this.inputLocked(buf, buflen);
        }
    }

    private void inputLocked(char[] buf, int buflen) {
        char[] newbuf = new char[buflen];
        int newbuflen = 0;
        for (int a = 0; a < buflen; ++a) {
            if (this.codelen == 0) {
                if (buf[a] == '\u00ff' || buf[a] == '\u001b' || this.profile.utf8 && this.utf8.isUTF8(buf[a])) {
                    if (newbuflen > 0) {
                        this.print(newbuf, newbuflen);
                        newbuflen = 0;
                    }
                    this.codelen = 1;
                    this.code[0] = buf[a];
                    continue;
                }
                newbuf[newbuflen++] = this.ansi.encodeChar(buf[a]);
                continue;
            }
            this.code[this.codelen++] = buf[a];
            if (this.codelen == 2 && this.code[0] == '\u001b' && this.code[1] == '\u001b') {
                this.codelen = 1;
            }
            if (this.code[0] == '\u00ff') {
                if (!this.telnet.decode(this.code, this.codelen, this)) continue;
                this.codelen = 0;
                continue;
            }
            if (this.code[0] == '\u001b') {
                if (!this.ansi.decode(this.code, this.codelen, this)) continue;
                this.codelen = 0;
                continue;
            }
            if (!this.utf8.decode(this.code, this.codelen, this)) continue;
            this.codelen = 0;
            newbuf[newbuflen++] = this.utf8.char16;
        }
        if (newbuflen > 0) {
            this.print(newbuf, newbuflen);
        }
    }

    private void setLines() {
        int oldLen = this.lines.length;
        int ty = this.sy + this.scrollBack;
        if (oldLen > ty) {
            newLines = new Line[ty];
            for (y = 0; y < ty; ++y) {
                newLines[y] = this.lines[y];
            }
            this.lines = newLines;
        } else {
            newLines = new Line[ty];
            for (y = 0; y < oldLen; ++y) {
                newLines[y] = this.lines[y];
            }
            for (y = oldLen; y < ty; ++y) {
                newLines[y] = new Line(this.sx, this.foreColor, this.backColor);
            }
            this.lines = newLines;
        }
        for (int i = 0; i < ty; ++i) {
            Line line = this.lines[i];
            line.setlen(this.sx, this.foreColor, this.backColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeSize(Dimension extent) {
        if (!this.init) {
            return;
        }
        if (!this.profile.autoSize) {
            return;
        }
        if (extent.width < this.profile.fontWidth) {
            extent.width = this.profile.fontWidth;
        }
        if (extent.height < this.profile.fontHeight) {
            extent.height = this.profile.fontHeight;
        }
        int newsx = extent.width / this.profile.fontWidth;
        int newsy = extent.height / this.profile.fontHeight;
        Object object = this.lock;
        synchronized (object) {
            this.y1 = 0;
            this.y2 = this.sy - 1;
            this.sx = newsx;
            this.sy = newsy;
            if (this.cx >= this.sx) {
                this.cx = this.sx - 1;
            }
            if (this.cy >= this.sy) {
                this.cy = this.sy - 1;
            }
            this.setLines();
            if (this.channel != null) {
                this.ssh_setPtyType();
            }
            if (this.profile.protocol.equals("local")) {
                this.pty_setsize();
            }
            System.gc();
        }
        this.clear_selection();
        this.signalRepaint(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeScrollBack(int newSize) {
        Object object = this.lock;
        synchronized (object) {
            this.scrollBack = newSize;
            this.setLines();
        }
        this.clear_selection();
        this.signalRepaint(true, true);
    }

    @Override
    public void setForeColor(int newClr) {
        this.foreColor = newClr & 0xFFFFFF;
    }

    @Override
    public void setBackColor(int newClr) {
        this.backColor = newClr & 0xFFFFFF;
    }

    @Override
    public void setBlinker(boolean state) {
        this.blinker = state;
    }

    @Override
    public void setReverse(boolean state) {
        this.reverse = state;
    }

    @Override
    public int getForeColor() {
        return this.foreColor;
    }

    @Override
    public int getBackColor() {
        return this.backColor;
    }

    @Override
    public void clrscr() {
        int ty = this.sy + this.scrollBack;
        for (int y = 0; y < ty; ++y) {
            this.lines[y].clear(this.foreColor, this.backColor);
        }
        this.cx = 0;
        this.cy = 0;
        this.signalRepaint(true, false);
        if (this.profile.protocol.equals("local")) {
            this.pty_setsize();
        }
    }

    public void print(String txt) {
        this.print(txt.toCharArray(), txt.length());
    }

    public void print(char[] buf, int buflen) {
        block6: for (int a = 0; a < buflen; ++a) {
            if (this.script != null) {
                this.script.input(buf[a], this);
            }
            switch (buf[a]) {
                case '\b': 
                case '\u007f': {
                    this.decPosX();
                    continue block6;
                }
                case '\t': {
                    int ts = (this.getx() - 1) % this.profile.tabStops;
                    for (int t = 0; t < this.profile.tabStops - ts; ++t) {
                        if (this.eol) {
                            this.incPosX();
                        }
                        this.incPosX();
                    }
                    continue block6;
                }
                case '\n': {
                    this.incPosY();
                    continue block6;
                }
                case '\r': {
                    this.gotoPos(1, this.gety());
                    continue block6;
                }
                default: {
                    if (buf[a] < ' ') continue block6;
                    if (this.eol) {
                        this.incPosX();
                    }
                    this.setChar(this.cx + 1, this.cy + 1, buf[a]);
                    this.incPosX();
                }
            }
        }
        this.signalRepaint(true, false);
    }

    public void print(char ch) {
        char[] x = new char[]{ch};
        this.print(x, 1);
    }

    @Override
    public void setChar(int x, int y, char ch) {
        if (x < 1 || y < 1) {
            JFLog.logTrace("ERROR:invalid chords!");
            return;
        }
        Line line = this.lines[--y + this.scrollBack];
        line.chs[--x] = ch;
        if (this.reverse) {
            line.fcs[x] = this.backColor;
            line.bcs[x] = this.foreColor;
        } else {
            line.fcs[x] = this.foreColor;
            line.bcs[x] = this.backColor;
        }
        line.blinks[x] = this.blinker;
    }

    private void decPosX() {
        if (this.cx > 0) {
            this.eol = false;
            --this.cx;
        } else {
            this.cx = this.sx - 1;
            this.decPosY();
            this.eol = true;
        }
    }

    private void decPosY() {
        if (this.cy > 0) {
            --this.cy;
        }
    }

    private void incPosX() {
        if (this.eol) {
            if (!this.autowrap) {
                return;
            }
            this.cx = 0;
            this.incPosY();
            this.eol = false;
        } else if (this.cx < this.sx - 1) {
            ++this.cx;
        } else {
            this.eol = true;
        }
    }

    private void incPosY() {
        if (this.cy < this.y2) {
            ++this.cy;
        } else {
            this.scrollUp(1);
        }
    }

    @Override
    public void setAutoWrap(boolean state) {
        this.autowrap = state;
    }

    @Override
    public int getsx() {
        return this.sx;
    }

    @Override
    public int getsy() {
        return this.sy;
    }

    @Override
    public int getx() {
        return this.cx + 1;
    }

    @Override
    public int gety() {
        return this.cy + 1;
    }

    @Override
    public void gotoPos(int x, int y) {
        --y;
        this.cx = --x;
        if (this.cx < 0) {
            this.cx = 0;
        }
        if (this.cx >= this.sx) {
            this.cx = this.sx - 1;
        }
        this.cy = y;
        if (this.cy < 0) {
            this.cy = 0;
        }
        if (this.cy >= this.sy) {
            this.cy = this.sy - 1;
        }
        this.eol = false;
    }

    @Override
    public int gety1() {
        return this.y1 + 1;
    }

    @Override
    public int gety2() {
        return this.y2 + 1;
    }

    @Override
    public void sety1(int v) {
        this.y1 = v - 1;
    }

    @Override
    public void sety2(int v) {
        this.y2 = v - 1;
    }

    @Override
    public void scrollUp(int cnt) {
        for (int i = 0; i < cnt; ++i) {
            for (int y = this.y1 + this.scrollBack; y < this.y2 + this.scrollBack; ++y) {
                this.lines[y] = this.lines[y + 1];
            }
            this.lines[this.y2 + this.scrollBack] = new Line(this.sx, this.foreColor, this.backColor);
        }
        this.selectEndY = -1;
        this.selectStartY = -1;
        this.selectEndX = -1;
        this.selectStartX = -1;
    }

    @Override
    public void scrollDown(int cnt) {
        for (int i = 0; i < cnt; ++i) {
            for (int y = this.y2 + this.scrollBack; y > this.y1 + this.scrollBack; --y) {
                this.lines[y] = this.lines[y - 1];
            }
            this.lines[this.y1 + this.scrollBack] = new Line(this.sx, this.foreColor, this.backColor);
        }
        this.selectEndY = -1;
        this.selectStartY = -1;
        this.selectEndX = -1;
        this.selectStartX = -1;
    }

    @Override
    public void delete() {
        Line line = this.lines[this.cy + this.scrollBack];
        for (int x = this.cx; x < this.sx - 1; ++x) {
            line.copy(x, x + 1);
        }
        line.set(this.sx - 1, this.foreColor, this.backColor);
    }

    @Override
    public void insert() {
        Line line = this.lines[this.cy + this.scrollBack];
        for (int x = this.sx - 2; x >= this.cx; --x) {
            line.copy(x - 1, x);
        }
        line.set(this.cx, this.foreColor, this.backColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Reader reader = this.reader;
        synchronized (reader) {
            this.closed = true;
            this.connected = false;
        }
        this.signalRepaint(false, false);
        this.signalReconnect();
        try {
            if (this.pty != null) {
                this.pty.close();
                this.pty = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.com != null) {
                this.com.close();
                this.com = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public String getTermType() {
        return this.profile.termType;
    }

    public void nextTab() {
        System.out.println("nextTab");
    }

    public void prevTab() {
        System.out.println("prevTab");
    }

    public void setTab(int idx) {
        System.out.println("setTab" + idx);
    }

    public void setName(String str) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalReconnect() {
        Reader reader = this.reader;
        synchronized (reader) {
            this.reader.notify();
        }
    }

    public void signalRepaint(boolean findScreen, boolean revalidate) {
        if (this.ui != null) {
            this.ui.signalRepaint(findScreen, revalidate);
        }
    }

    public boolean have_selection() {
        return this.selectStartY != -1 && this.selectEndY != -1;
    }

    public void clear_selection() {
        this.selectStartY = -1;
        this.selectStartX = -1;
        this.selectEndY = -1;
        this.selectEndX = -1;
    }

    public void swap_selection() {
        int tmpY = this.selectStartY;
        this.selectStartY = this.selectEndY;
        this.selectEndY = tmpY;
        int tmpX = this.selectStartX;
        this.selectStartX = this.selectEndX;
        this.selectEndX = tmpX;
    }

    public void copy() {
        if (!this.have_selection()) {
            return;
        }
        try {
            StringBuilder str = new StringBuilder();
            if (this.selectStartY > this.selectEndY) {
                this.swap_selection();
            }
            for (int y = this.selectStartY; y <= this.selectEndY; ++y) {
                Line line = this.lines[y];
                if (y == this.selectStartY) {
                    x1 = 0;
                    x2 = this.sx;
                    if (y == this.selectEndY) {
                        x1 = this.selectEndX;
                    }
                    for (x = x1; x < x2; ++x) {
                        str.append(line.chs[x]);
                    }
                } else if (y == this.selectEndY) {
                    x1 = 0;
                    x2 = this.sx;
                    if (y == this.selectEndY) {
                        x2 = this.selectEndX;
                    }
                    for (x = x1; x < x2; ++x) {
                        str.append(line.chs[x]);
                    }
                } else {
                    for (int x = 0; x < this.sx; ++x) {
                        str.append(line.chs[x]);
                    }
                }
                str.append("\n");
            }
            StringSelection ss = new StringSelection(str.toString());
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (cb == null) {
                return;
            }
            cb.setContents(ss, ss);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paste() {
        if (!this.connected) {
            return;
        }
        try {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            String str = (String)cb.getContents(null).getTransferData(DataFlavor.stringFlavor);
            if (str == null) {
                return;
            }
            this.output(str.replaceAll("\r", "\n").toCharArray());
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        this.signalRepaint(true, false);
    }

    private boolean doConnect() {
        if (this.profile.protocol.equals("com")) {
            return this.connectCom();
        }
        if (this.profile.protocol.equals("local")) {
            return this.connectLocal();
        }
        if (this.profile.protocol.equals("telnet")) {
            return this.connectTelnet();
        }
        if (this.profile.protocol.equals("ssh")) {
            return this.connectSSH(this.parent);
        }
        if (this.profile.protocol.equals("ssl")) {
            return this.connectSSL();
        }
        return false;
    }

    private void sendTT() {
        this.input(new char[]{'\u00ff', '\u00fa', '\u0018', '\u00ff', '\u00f0'}, 5);
    }

    private void pty_setsize() {
        if (this.pty == null) {
            return;
        }
        this.pty.setSize(this.sx, this.sy);
    }

    private boolean connectCom() {
        try {
            this.com = ComPort.open(this.profile.com, this.profile.baud);
            this.in = new InputStream(){

                @Override
                public int read() throws IOException {
                    byte[] data = new byte[1];
                    int read = 0;
                    while ((read = Buffer.this.com.read(data)) != 1) {
                    }
                    return data[0];
                }

                @Override
                public int read(byte[] buf) throws IOException {
                    int read;
                    while ((read = Buffer.this.com.read(buf)) <= 0) {
                    }
                    return read;
                }
            };
            this.out = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    Buffer.this.com.write(new byte[]{(byte)b});
                }

                @Override
                public void write(byte[] buf) throws IOException {
                    Buffer.this.com.write(buf);
                }
            };
            return true;
        }
        catch (Throwable t) {
            if (!this.closed) {
                this.input(t.toString());
            }
            return false;
        }
    }

    private boolean connectLocal() {
        JFLog.log("connectLocal:" + this.profile.termApp);
        try {
            this.profile.termArgs[0] = this.profile.termApp;
            this.pty = LnxPty.exec(this.profile.termApp, this.profile.termArgs, LnxPty.makeEnvironment(new String[]{"TERM=" + this.profile.termType}));
            if (this.pty == null) {
                throw new Exception("pty failed");
            }
            this.in = new InputStream(){

                @Override
                public int read() {
                    return -1;
                }

                @Override
                public int read(byte[] buf) {
                    return Buffer.this.pty.read(buf);
                }
            };
            this.out = new OutputStream(){

                @Override
                public void write(int x) {
                }

                @Override
                public void write(byte[] buf) {
                    Buffer.this.pty.write(buf);
                }
            };
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            if (!this.closed) {
                this.input(e.toString());
            }
            return false;
        }
    }

    private boolean connectTelnet() {
        try {
            this.s = new Socket(this.profile.host, this.profile.port);
            this.in = this.s.getInputStream();
            this.out = this.s.getOutputStream();
            return true;
        }
        catch (Exception e) {
            if (!this.closed) {
                this.input(e.toString());
            }
            return false;
        }
    }

    private int detectX11port() {
        int port = 6000;
        return port;
    }

    private void ssh_setPtyType() {
        JFLog.log("TODO : set Pty Type");
    }

    private boolean connectSSH(Frame parent) {
        try {
            if (this.profile.sshKey.length() == 0) {
                if (this.profile.password.length() == 0) {
                    this.profile.password = GetPassword.getPassword(parent);
                }
                if (this.profile.password == null) {
                    return false;
                }
            }
            this.client = SshClient.setUpDefaultClient();
            this.client.start();
            JFLog.log("TODO : set knownhosts");
            ConnectFuture cf = this.client.connect(this.profile.username, this.profile.host, this.profile.port);
            this.session = (ClientSession)((ConnectFuture)cf.verify(new CancelOption[0])).getSession();
            if (this.profile.x11) {
                JFLog.log("TODO : set X11 host / port");
            }
            if (this.profile.sshKey.length() == 0) {
                this.session.addPasswordIdentity(this.profile.password);
            } else {
                JFLog.log("SSH:using key:" + this.profile.sshKey);
                JFLog.log("TODO : set ssh key");
            }
            this.session.auth().verify(30000L, new CancelOption[0]);
            this.channel = this.session.createChannel("shell");
            if (this.profile.x11) {
                JFLog.log("TODO : enable x11 forwarding");
            } else {
                JFLog.log("TODO : enable agent forwarding");
            }
            Object[] pipes = this.createPipes();
            if (pipes == null) {
                return false;
            }
            this.out = (OutputStream)pipes[1];
            this.channel.setIn((InputStream)pipes[0]);
            pipes = this.createPipes();
            if (pipes == null) {
                return false;
            }
            this.in = (InputStream)pipes[0];
            this.channel.setOut((OutputStream)pipes[1]);
            this.channel.open();
            return true;
        }
        catch (Exception e) {
            if (!this.closed) {
                this.input(e.toString());
            }
            return false;
        }
    }

    private Object[] createPipes() {
        Object[] ret = new Object[2];
        try {
            ret[0] = new PipedInputStream();
            ret[1] = new PipedOutputStream((PipedInputStream)ret[0]);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean connectSSL() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslsocketfactory = sc.getSocketFactory();
            this.ssl = (SSLSocket)sslsocketfactory.createSocket(this.profile.host, this.profile.port);
            this.s = this.ssl;
            this.in = this.s.getInputStream();
            this.out = this.s.getOutputStream();
            return true;
        }
        catch (Exception e) {
            if (!this.closed) {
                this.input(e.toString());
            }
            return false;
        }
    }

    public String toString() {
        return "Buffer:" + this.sx + "," + this.sy + "+" + this.scrollBack;
    }

    public void timer() {
        if (this.cursorShown) {
            this.blinkerShown = !this.blinkerShown;
            this.cursorShown = false;
        } else {
            this.cursorShown = true;
        }
        if (this.script != null && this.script.process(this)) {
            this.script = null;
        }
        this.signalRepaint(false, false);
    }

    public static interface UI {
        public void signalRepaint(boolean var1, boolean var2);

        public JComponent getComponent();

        public void close();
    }

    private class Reader
    extends Thread {
        private Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Buffer.this.closed) {
                try {
                    Buffer.this.input("Connecting...");
                    Buffer.this.signalRepaint(true, false);
                    if (!Buffer.this.doConnect()) {
                        Buffer.this.input("\r\nConnection failed! Press any key to retry...");
                        Buffer.this.signalRepaint(true, false);
                        Buffer.this.failed = true;
                        Reader reader = Buffer.this.reader;
                        synchronized (reader) {
                            if (Buffer.this.closed) {
                                break;
                            }
                            try {
                                Buffer.this.reader.wait();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        Buffer.this.input("\r\n");
                        continue;
                    }
                    Buffer.this.connected = true;
                    Buffer.this.input("\u001b[2J");
                    byte[] buf = new byte[1024];
                    while (Buffer.this.connected) {
                        int buflen = Buffer.this.in.read(buf);
                        if (buflen == -1) {
                            throw new Exception("read error");
                        }
                        if (buflen <= 0) continue;
                        Buffer.this.input(Buffer.this.byte2char(buf, buflen), buflen);
                    }
                }
                catch (SocketException e) {
                    if (Buffer.this.closed) continue;
                    Buffer.this.ui.close();
                }
                catch (Exception e) {
                    JFLog.log(e);
                    if (Buffer.this.closed) continue;
                    Buffer.this.ui.close();
                }
            }
            JFLog.log("Reader thread done");
        }
    }
}

