/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFontChooser
extends JDialog {
    public static int OK_OPTION = 0;
    public static int CANCEL_OPTION = 1;
    private JList fontList;
    private JList sizeList;
    private JCheckBox cbBold;
    private JCheckBox cbItalic;
    private JTextArea txtSample;
    private int OPTION;
    private String[] sizes = new String[]{"2", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "30", "36", "48", "72", "84", "96", "108", "144", "192", "216", "288"};

    public int showDialog(Font font) {
        this.setFont(font);
        return this.showDialog();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.OPTION;
    }

    public JFontChooser(Frame parent) {
        super(parent, true);
        this.setTitle("JFontChooser");
        this.OPTION = CANCEL_OPTION;
        JButton btnOK = new JButton("OK");
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFontChooser.this.OPTION = OK_OPTION;
                JFontChooser.this.setVisible(false);
            }
        });
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFontChooser.this.OPTION = CANCEL_OPTION;
                JFontChooser.this.setVisible(false);
            }
        });
        this.fontList = new JList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(150, 144);
            }
        };
        this.fontList.setSelectionMode(0);
        this.sizeList = new JList(this.sizes){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(25, 144);
            }
        };
        this.sizeList.setSelectionMode(0);
        this.cbBold = new JCheckBox("Bold");
        this.cbItalic = new JCheckBox("Italic");
        this.txtSample = new JTextArea(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(385, 80);
            }
        };
        this.txtSample.setText("The quick brown fox jumped over the fence");
        this.setFont(null);
        ListSelectionListener listListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JFontChooser.this.txtSample.setFont(JFontChooser.this.getCurrentFont());
            }
        };
        this.fontList.addListSelectionListener(listListener);
        this.sizeList.addListSelectionListener(listListener);
        ActionListener cbListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFontChooser.this.txtSample.setFont(JFontChooser.this.getCurrentFont());
            }
        };
        this.cbBold.addActionListener(cbListener);
        this.cbItalic.addActionListener(cbListener);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)new JScrollPane(this.fontList), "Center");
        leftPanel.add((Component)new JScrollPane(this.sizeList), "East");
        this.getContentPane().add((Component)leftPanel, "Center");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        JPanel rightPanelSub1 = new JPanel();
        rightPanelSub1.setLayout(new FlowLayout());
        rightPanelSub1.add(this.cbBold);
        rightPanelSub1.add(this.cbItalic);
        rightPanel.add((Component)rightPanelSub1, "North");
        JPanel rightPanelSub2 = new JPanel();
        rightPanelSub2.setLayout(new GridLayout(2, 1));
        rightPanelSub2.add(btnOK);
        rightPanelSub2.add(btnCancel);
        rightPanel.add((Component)rightPanelSub2, "South");
        this.getContentPane().add((Component)rightPanel, "East");
        this.getContentPane().add((Component)new JScrollPane(this.txtSample), "South");
        this.setSize(200, 200);
        this.setResizable(false);
        this.pack();
        this.setPosition();
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            font = this.txtSample.getFont();
        }
        this.fontList.setSelectedValue(font.getName(), true);
        this.fontList.ensureIndexIsVisible(this.fontList.getSelectedIndex());
        this.sizeList.setSelectedValue("" + font.getSize(), true);
        this.sizeList.ensureIndexIsVisible(this.sizeList.getSelectedIndex());
        this.cbBold.setSelected(font.isBold());
        this.cbItalic.setSelected(font.isItalic());
    }

    @Override
    public Font getFont() {
        if (this.OPTION == OK_OPTION) {
            return this.getCurrentFont();
        }
        return null;
    }

    private Font getCurrentFont() {
        String fontFamily = (String)this.fontList.getSelectedValue();
        int fontSize = Integer.parseInt((String)this.sizeList.getSelectedValue());
        int fontType = 0;
        if (this.cbBold.isSelected()) {
            ++fontType;
        }
        if (this.cbItalic.isSelected()) {
            fontType += 2;
        }
        return new Font(fontFamily, fontType, fontSize);
    }

    private void setPosition() {
        Dimension d = this.getSize();
        Rectangle s = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setLocation(s.width / 2 - d.width / 2, s.height / 2 - d.height / 2);
    }
}

