/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import java.awt.Image;
import javaforce.awt.JFImage;
import javaforce.gl.GL;

public class Offscreen {
    private int os_fb;
    private int os_clr_rb;
    private int os_depth_rb;
    private int os_width;
    private int os_height;
    private int[] os_px;
    private int[] os_fpx;
    private JFImage os_img;

    public Image getOffscreen() {
        GL.glReadPixels(0, 0, this.os_width, this.os_height, 32993, 5121, this.os_px);
        int src = (this.os_height - 1) * this.os_width;
        int dst = 0;
        for (int y = 0; y < this.os_height; ++y) {
            for (int x = 0; x < this.os_width; ++x) {
                this.os_fpx[dst++] = this.os_px[src++] | 0xFF000000;
            }
            src -= this.os_width * 2;
        }
        this.os_img.putPixels(this.os_fpx, 0, 0, this.os_width, this.os_height, 0);
        return this.os_img.getImage();
    }

    public int[] getOffscreenPixels() {
        GL.glReadPixels(0, 0, this.os_width, this.os_height, 32993, 5121, this.os_px);
        int src = (this.os_height - 1) * this.os_width;
        int dst = 0;
        for (int y = 0; y < this.os_height; ++y) {
            System.arraycopy(this.os_px, src, this.os_fpx, dst, this.os_width);
            src -= this.os_width;
            dst += this.os_width;
        }
        return this.os_fpx;
    }

    private void createBuffers(int width, int height) {
        int[] ids = new int[1];
        GL.glGenRenderbuffers(1, ids);
        this.os_clr_rb = ids[0];
        GL.glBindRenderbuffer(36161, this.os_clr_rb);
        GL.glRenderbufferStorage(36161, 6408, width, height);
        GL.glFramebufferRenderbuffer(36160, 36064, 36161, this.os_clr_rb);
        GL.glGenRenderbuffers(1, ids);
        this.os_depth_rb = ids[0];
        GL.glBindRenderbuffer(36161, this.os_depth_rb);
        GL.glRenderbufferStorage(36161, 33191, width, height);
        GL.glFramebufferRenderbuffer(36160, 36096, 36161, this.os_depth_rb);
    }

    public void resizeOffscreen(int width, int height) {
        this.os_width = width;
        this.os_height = height;
        this.os_px = new int[this.os_width * this.os_height];
        this.os_fpx = new int[this.os_width * this.os_height];
        this.os_img = new JFImage(this.os_width, this.os_height);
        GL.glBindFramebuffer(36160, this.os_fb);
        int[] ids = new int[]{this.os_clr_rb, this.os_depth_rb};
        GL.glDeleteRenderbuffers(2, ids);
        this.createBuffers(width, height);
    }

    public void createOffscreen(int width, int height) {
        if (this.os_fb != 0) {
            return;
        }
        int[] ids = new int[1];
        GL.glGenFramebuffers(1, ids);
        this.os_fb = ids[0];
        GL.glBindFramebuffer(36160, this.os_fb);
        this.createBuffers(width, height);
        GL.glBindFramebuffer(36160, this.os_fb);
        this.os_width = width;
        this.os_height = height;
        this.os_px = new int[this.os_width * this.os_height];
        this.os_fpx = new int[this.os_width * this.os_height];
        this.os_img = new JFImage(this.os_width, this.os_height);
    }

    public void setRenderToOffscreen(boolean state) {
        GL.glBindFramebuffer(36160, state ? this.os_fb : 0);
    }
}

