/*
 * Decompiled with CFR 0.152.
 */
package javaforce.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;

@Deprecated
public abstract class SerialObject {
    public static final short javaforce_magic = 19014;
    public static final short java_magic = -21267;
    public static final short id_end = 0;
    public static final short id_1 = 256;
    public static final short id_2 = 512;
    public static final short id_4 = 1024;
    public static final short id_8 = 2048;
    public static final short id_len = 4096;
    public static final short id_array = 8192;
    public transient DataInputStream dis;
    public transient DataOutputStream dos;

    public static boolean isJavaSerialObject(InputStream is) {
        try {
            DataInputStream dis = new DataInputStream(is);
            return dis.readShort() == -21267;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isJavaSerialObject(String file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            boolean isJava = SerialObject.isJavaSerialObject(fis);
            fis.close();
            return isJava;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void readInit(DataInputStream dis) {
        this.dis = dis;
    }

    public void readInit(SerialObject so) {
        this.dis = so.dis;
    }

    public abstract void readObject() throws Exception;

    public byte readByte() throws Exception {
        return this.dis.readByte();
    }

    public short readShort() throws Exception {
        return this.dis.readShort();
    }

    public int readInt() throws Exception {
        return this.dis.readInt();
    }

    public long readLong() throws Exception {
        return this.dis.readLong();
    }

    public char readChar() throws Exception {
        return this.dis.readChar();
    }

    public String readString() throws Exception {
        int len = this.dis.readInt();
        if (len == -1) {
            return null;
        }
        byte[] bytes = new byte[len];
        this.dis.read(bytes);
        return new String(bytes, "UTF-8");
    }

    public boolean readBoolean() throws Exception {
        return this.readByte() != 0;
    }

    public float readFloat() throws Exception {
        return this.dis.readFloat();
    }

    public double readDouble() throws Exception {
        return this.dis.readDouble();
    }

    public byte[] readBytes() throws Exception {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        byte[] bytes = new byte[len];
        this.dis.read(bytes);
        return bytes;
    }

    public void skipChunk(short id) throws Exception {
        if (id == 0) {
            return;
        }
        switch (id & 0xFF00) {
            case 256: {
                this.readByte();
                break;
            }
            case 512: {
                this.readShort();
                break;
            }
            case 1024: {
                this.readInt();
                break;
            }
            case 2048: {
                this.readLong();
                break;
            }
            case 4096: {
                int len = this.readInt();
                byte[] data = new byte[len];
                this.dis.read(data);
                break;
            }
            case 8192: {
                int cnt = this.readInt();
                for (int a = 0; a < cnt; ++a) {
                    this.skipObject();
                }
                break;
            }
        }
    }

    private void skipObject() throws Exception {
        short id;
        while ((id = this.readShort()) != 0) {
            this.skipChunk(id);
        }
    }

    public void writeInit(DataOutputStream dos) {
        this.dos = dos;
    }

    public void writeInit(SerialObject so) {
        this.dos = so.dos;
    }

    public abstract void writeObject() throws Exception;

    public void writeByte(byte value) throws Exception {
        this.dos.writeByte(value);
    }

    public void writeShort(short value) throws Exception {
        this.dos.writeShort(value);
    }

    public void writeInt(int value) throws Exception {
        this.dos.writeInt(value);
    }

    public void writeLong(long value) throws Exception {
        this.dos.writeLong(value);
    }

    public void writeChar(char value) throws Exception {
        this.dos.writeChar(value);
    }

    public void writeString(String value) throws Exception {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        byte[] bytes = value.getBytes("UTF-8");
        this.dos.writeInt(bytes.length);
        this.dos.write(bytes);
    }

    public void writeBoolean(boolean value) throws Exception {
        this.writeByte((byte)(value ? 1 : 0));
    }

    public void writeFloat(float value) throws Exception {
        this.dos.writeFloat(value);
    }

    public void writeDouble(double value) throws Exception {
        this.dos.writeDouble(value);
    }

    public void writeBytes(byte[] bytes) throws Exception {
        if (bytes == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(bytes.length);
        this.dos.write(bytes);
    }
}

