/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javaforce.HTTP;
import javaforce.JF;
import javaforce.JFByteBuffer;
import javaforce.JFLog;
import javaforce.service.WebRequest;
import javaforce.webui.WebUIClient;
import javaforce.webui.WebUIServer;
import javaforce.webui.tasks.Status;

public class WebUpload {
    public static boolean debug = false;
    private static long maxlength = 0x4000000L;
    private static final int max_buffer_size = 8192;
    private static byte[] end_of_line = "\r\n".getBytes();
    private static byte[] end_of_headers = "\r\n\r\n".getBytes();
    private static byte[] end_of_files = "--\r\n".getBytes();
    private static final int SIZE = 1;
    private static final int CLIENT = 2;
    private static final int FILE = 3;
    private JFByteBuffer buffer = new JFByteBuffer(8192);

    public static boolean isMultipartContent(WebRequest req) {
        String contentType = req.getHeader("Content-Type");
        if (contentType == null) {
            return false;
        }
        return contentType.trim().startsWith("multipart/form-data;");
    }

    public static void setMaxLength(long maxlength) {
        WebUpload.maxlength = maxlength;
    }

    public WebFile[] processRequest(WebRequest req, String out_folder) {
        String file_size = null;
        Status status = null;
        OutputStream fos = null;
        try {
            String contentLength;
            int idx;
            String contentType = req.getHeader("Content-Type");
            if (contentType == null) {
                throw new Exception("WebUpload:No Content-Type");
            }
            if (debug) {
                for (String field : req.fields) {
                    JFLog.log(field);
                }
            }
            if ((idx = contentType.indexOf("boundary=")) == -1) {
                throw new Exception("WebUpload:No boundary");
            }
            byte[] boundary = ("--" + contentType.substring(idx + 9)).getBytes();
            int boundaryLength = boundary.length;
            if (debug) {
                JFLog.log("WebUpload:boundary=" + new String(boundary) + ":length=" + boundaryLength);
            }
            if ((contentLength = req.getHeader("Content-Length")) == null) {
                throw new Exception("WebUpload:No Content-Length");
            }
            long postLength = Long.valueOf(contentLength);
            if (maxlength > 0L && postLength > maxlength) {
                throw new Exception("WebUpload:Upload > Max allowed");
            }
            long postCopied = 0L;
            long postLeft = postLength;
            long pos = 0L;
            boolean done = false;
            if (debug) {
                JFLog.log("postLength=" + postLength);
            }
            ArrayList<WebFile> files = new ArrayList<WebFile>();
            while (postCopied < postLength) {
                ByteArrayOutputStream baos;
                String hash;
                WebUIClient client;
                while (this.buffer.getLength() < boundaryLength + 2) {
                    this.buffer.compact();
                    int toRead = boundaryLength + 2 - this.buffer.getLength();
                    if ((long)toRead > postLeft) {
                        toRead = (int)postLeft;
                    }
                    if (toRead > this.buffer.available()) {
                        toRead = this.buffer.available();
                    }
                    if (toRead == 0) {
                        throw new Exception("WebUpload:out of data");
                    }
                    int bytes = this.buffer.write(req.is, toRead);
                    if (bytes <= 0) continue;
                    postCopied += (long)bytes;
                    postLeft -= (long)bytes;
                }
                if (this.buffer.startsWith(end_of_line)) {
                    if (debug) {
                        JFLog.log("skip end_of_line");
                    }
                    this.buffer.skip(2);
                    pos += 2L;
                }
                int offset = this.buffer.getOffset();
                if (Arrays.compare(this.buffer.getBuffer(), offset, offset + boundaryLength, boundary, 0, boundaryLength) != 0) {
                    throw new Exception("WebUpload:Bad boundary @ " + postCopied);
                }
                if (debug) {
                    JFLog.log("Boundary@" + pos);
                }
                this.buffer.skip(boundaryLength);
                pos += (long)boundaryLength;
                this.buffer.compact();
                int headers_end = 0;
                do {
                    if (this.buffer.indexOf(end_of_files) == 0) {
                        done = true;
                        if (!debug) break;
                        JFLog.log("end_of_files");
                        break;
                    }
                    int toRead = 1024;
                    if (debug) {
                        JFLog.log("toRead=" + toRead + "," + postLeft + "," + this.buffer.available());
                    }
                    if ((long)toRead > postLeft) {
                        toRead = (int)postLeft;
                    }
                    if (toRead > this.buffer.available()) {
                        toRead = this.buffer.available();
                    }
                    if (toRead == 0) {
                        throw new Exception("WebUpload:out of data");
                    }
                    int bytes = this.buffer.write(req.is, toRead);
                    if (bytes <= 0) continue;
                    postCopied += (long)bytes;
                    postLeft -= (long)bytes;
                    headers_end = this.buffer.indexOf(end_of_headers);
                } while (headers_end == -1);
                if (done) break;
                headers_end += 4;
                String cd_filename = null;
                String cd_name = null;
                if (debug) {
                    JFLog.log("Headers@" + pos + ":length=" + headers_end);
                }
                String headers = this.buffer.readString(headers_end);
                pos += (long)headers_end;
                if (debug) {
                    JFLog.log("Headers=" + headers);
                }
                HTTP.Parameters params = HTTP.Parameters.decode(headers.split("\r\n"));
                block34: for (String p_key : params.keys()) {
                    String p_value = params.get(p_key);
                    switch (p_key) {
                        case "Content-Disposition": {
                            String[] fields;
                            block35: for (String field : fields = p_value.split(";")) {
                                int eq = (field = field.trim()).indexOf(61);
                                if (eq == -1) continue;
                                String f_key = field.substring(0, eq);
                                String f_value = field.substring(eq + 1);
                                switch (f_key) {
                                    case "filename": {
                                        cd_filename = f_value;
                                        if (!cd_filename.startsWith("\"") || !cd_filename.endsWith("\"")) continue block35;
                                        cd_filename = cd_filename.substring(1, cd_filename.length() - 1);
                                        continue block35;
                                    }
                                    case "name": {
                                        cd_name = f_value;
                                        if (!cd_name.startsWith("\"") || !cd_name.endsWith("\"")) continue block35;
                                        cd_name = cd_name.substring(1, cd_name.length() - 1);
                                    }
                                }
                            }
                            continue block34;
                        }
                        case "Content-Length": {
                            file_size = p_value;
                        }
                    }
                }
                int type = 0;
                switch (cd_name) {
                    case "size": {
                        file_size = null;
                        type = 1;
                        break;
                    }
                    case "client": {
                        type = 2;
                        break;
                    }
                    case "file": {
                        type = 3;
                        break;
                    }
                    default: {
                        throw new Exception("WebUpload:Unknown field:" + cd_name);
                    }
                }
                if (type == 3) {
                    if (cd_filename == null) {
                        throw new Exception("WebUpload:Upload has no filename");
                    }
                    WebFile uploadFile = new WebFile();
                    uploadFile.name = cd_filename;
                    uploadFile.file = new File(out_folder + "/" + cd_filename);
                    files.add(uploadFile);
                    fos = new FileOutputStream(uploadFile.file);
                    if (status != null) {
                        status.setPercent(0);
                    }
                } else {
                    fos = new ByteArrayOutputStream();
                }
                long fileLength = -1L;
                if (type == 3 && file_size != null) {
                    fileLength = Long.valueOf(file_size);
                    file_size = null;
                }
                long fileCopied = 0L;
                long fileLeft = fileLength;
                long fileCopiedMB = 0L;
                long fileLengthMB = fileLength / 0x100000L;
                int length = this.buffer.getLength();
                if (fileLength > (long)length + postLeft) {
                    throw new Exception("WebUpload:file exceeds post data size:" + fileLength + "," + ((long)length + postLeft));
                }
                if (debug) {
                    JFLog.log("file@" + pos + ":length=" + fileLength);
                }
                while (fileLength == -1L || fileCopied < fileLength) {
                    int toRead;
                    int buflen = this.buffer.getLength();
                    if (fileLength == -1L) {
                        idx = this.buffer.indexOf(boundary);
                        if (idx != -1) {
                            idx -= 2;
                            if (debug) {
                                JFLog.log("end of content@" + idx);
                            }
                            fileLength = fileCopied + (long)idx;
                            fileLeft = fileLength - fileCopied;
                            fileLengthMB = fileLength / 0x100000L;
                            buflen = idx;
                        } else {
                            buflen -= boundaryLength;
                        }
                    } else if ((long)buflen > fileLeft) {
                        buflen = (int)fileLeft;
                    }
                    if (buflen > 0) {
                        int writen = this.buffer.readBytes(fos, buflen);
                        if (writen == -1) {
                            throw new Exception("WebUpload:output error");
                        }
                        if (writen > 0) {
                            long copiedMB;
                            fileLeft -= (long)writen;
                            if (status != null && fileLength != -1L && (copiedMB = (fileCopied += (long)writen) / 0x100000L) != fileCopiedMB) {
                                fileCopiedMB = copiedMB;
                                int percent = (int)(fileCopiedMB * 100L / fileLengthMB);
                                if (debug) {
                                    JFLog.log("status:percent=" + percent);
                                }
                                status.setPercent(percent);
                            }
                        }
                    }
                    this.buffer.compact();
                    if (fileLength != -1L && fileLeft == 0L) break;
                    int available = this.buffer.available();
                    int n = toRead = fileLength == -1L ? available : (int)fileLeft;
                    if (debug) {
                        JFLog.log("toRead=" + toRead + "," + available + "," + fileLength + "," + fileLeft);
                    }
                    if (toRead > available) {
                        toRead = available;
                    }
                    if (toRead == 0) {
                        throw new Exception("WebUpload:out of data");
                    }
                    int bytes = this.buffer.write(req.is, toRead);
                    if (bytes == -1) {
                        throw new Exception("WebUpload:input error");
                    }
                    if (bytes <= 0) continue;
                    postCopied += (long)bytes;
                    postLeft -= (long)bytes;
                }
                if (type == 1) {
                    ByteArrayOutputStream baos2 = (ByteArrayOutputStream)fos;
                    file_size = new String(baos2.toByteArray());
                    if (debug) {
                        JFLog.log("size=" + file_size);
                    }
                }
                if (type == 2 && (client = WebUIServer.getClient(hash = new String((baos = (ByteArrayOutputStream)fos).toByteArray()))) != null) {
                    out_folder = client.getUploadFolder();
                    status = client.getUploadStatus();
                }
                pos += fileLength;
                fos.close();
                fos = null;
                if (status == null) continue;
                status.setPercent(100);
                status.setResult(true);
            }
            return files.toArray(new WebFile[0]);
        }
        catch (Exception e) {
            JFLog.log(e);
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (status != null) {
                status.setResult(false);
            }
            return null;
        }
    }

    public static class WebFile {
        public File file;
        public String name;

        public boolean move(File dest) throws Exception {
            if (dest.exists()) {
                return false;
            }
            return JF.moveFile(this.file, dest);
        }

        public String getName() {
            return this.name;
        }
    }
}

