/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.RTPH264;
import javaforce.voip.RTPH265;

public class PacketBuffer {
    private static final int maxPacketsSize = 0x1000000;
    private static final int maxPackets = 256;
    public boolean debug = false;
    public byte[] data;
    private Packet nextFrame = new Packet();
    private RTPH264 h264;
    private RTPH265 h265;
    private int codecType;
    private boolean started;
    public int[] offset = new int[256];
    public int[] length = new int[256];
    public byte[] type = new byte[256];
    public int nextOffset;
    public int head;
    public int tail;
    public int log;
    private int nal_size;
    private byte[] nal_list = new byte[64];

    public PacketBuffer(int codecType) {
        this.codecType = codecType;
        this.data = new byte[0x1000000];
        this.nextFrame.data = new byte[0x1000000];
        switch (codecType) {
            case 50: {
                this.h264 = new RTPH264();
                break;
            }
            case 60: {
                this.h265 = new RTPH265();
            }
        }
    }

    public void setLog(int id) {
        this.log = id;
    }

    public void reset() {
        this.head = 0;
        this.tail = 0;
        this.nextOffset = 0;
        this.started = false;
    }

    private boolean calcOffset(int nextLength) {
        int next_head;
        if (this.nextOffset + nextLength >= 0x1000000) {
            this.nextOffset = 0;
        }
        if ((next_head = this.head + 1) == 256) {
            next_head = 0;
        }
        if (next_head == this.tail) {
            JFLog.log(this.log, "PacketBuffer : Error : Buffer Overflow (# of packets exceeded)");
            this.reset();
            return false;
        }
        int _tail = this.tail;
        if (this.head == _tail) {
            return true;
        }
        int total_length = 0;
        while (_tail != this.head) {
            total_length += this.length[_tail];
            if (++_tail != 256) continue;
            _tail = 0;
        }
        if (total_length + nextLength > 0x1000000) {
            JFLog.log(this.log, "PacketBuffer : Error : Buffer Overflow (# of bytes exceeded)");
            this.reset();
            return false;
        }
        return true;
    }

    public void add(Packet packet) {
        byte nal_type = 0;
        if (this.h264 != null) {
            nal_type = RTPH264.get_nal_type(packet.data, 4);
            if (!RTPH264.canDecodePacket(nal_type)) {
                return;
            }
            if (!this.started) {
                if (!this.h264.isStart(nal_type)) {
                    return;
                }
                this.started = true;
            }
        } else if (this.h265 != null) {
            nal_type = RTPH265.get_nal_type(packet.data, 4);
            if (!RTPH265.canDecodePacket(nal_type)) {
                return;
            }
            if (!this.started) {
                if (!this.h265.isStart(nal_type)) {
                    return;
                }
                this.started = true;
            }
        }
        if (this.debug) {
            JFLog.log(this.log, "packet=" + nal_type);
        }
        if (!this.calcOffset(packet.length)) {
            return;
        }
        try {
            System.arraycopy(packet.data, packet.offset, this.data, this.nextOffset, packet.length);
        }
        catch (Exception e) {
            JFLog.log(this.log, "PacketBuffer : Error : arraycopy(src," + packet.offset + ",dst," + this.nextOffset + "," + packet.length + ")");
            JFLog.log(this.log, (Throwable)e);
            return;
        }
        this.offset[this.head] = this.nextOffset;
        this.length[this.head] = packet.length;
        switch (this.codecType) {
            case 50: {
                this.type[this.head] = RTPH264.get_nal_type(packet.data, packet.offset + 4);
                break;
            }
            case 60: {
                this.type[this.head] = RTPH265.get_nal_type_slice_flag(packet.data, packet.offset + 4);
            }
        }
        this.nextOffset += packet.length;
        int new_head = this.head + 1;
        if (new_head == 256) {
            new_head = 0;
        }
        this.head = new_head;
    }

    public void removePacket() {
        if (this.tail == this.head) {
            JFLog.log(this.log, "PacketBuffer : Error : Packets Buffer underflow");
            return;
        }
        int new_tail = this.tail + 1;
        if (new_tail == 256) {
            new_tail = 0;
        }
        this.tail = new_tail;
    }

    private byte get_this_type(int offset) {
        if (offset == this.head) {
            return 0;
        }
        return this.type[offset];
    }

    private byte get_next_type(int offset) {
        if (++offset == 256) {
            offset = 0;
        }
        if (offset == this.head) {
            return 0;
        }
        return this.type[offset];
    }

    public boolean haveCompleteFrame() {
        int pos = this.tail;
        while (pos != this.head) {
            byte this_type = this.get_this_type(pos);
            byte next_type = this.get_next_type(pos);
            switch (this.codecType) {
                case 50: {
                    if (!this.h264.isFrame(this_type)) break;
                    return true;
                }
                case 60: {
                    if (!this.h265.isFrame(this_type, next_type)) break;
                    return true;
                }
            }
            if (++pos != 256) continue;
            pos = 0;
        }
        return false;
    }

    public boolean isNextFrame_KeyFrame() {
        int pos = this.tail;
        while (pos != this.head) {
            byte this_type = this.get_this_type(pos);
            byte next_type = this.get_next_type(pos);
            switch (this.codecType) {
                case 50: {
                    if (this.h264.isKeyFrame(this_type)) {
                        return true;
                    }
                    if (!this.h264.isIFrame(this_type)) break;
                    return false;
                }
                case 60: {
                    if (this.h265.isKeyFrame(this_type, next_type)) {
                        return true;
                    }
                    if (!this.h265.isIFrame(this_type, next_type)) break;
                    return false;
                }
            }
            if (++pos != 256) continue;
            pos = 0;
        }
        return false;
    }

    public Packet getNextFrame() {
        if (!this.haveCompleteFrame()) {
            JFLog.log(this.log, "PacketBuffer : Error : getNextFrame() called but don't have one ???");
            return null;
        }
        this.nal_size = 0;
        this.nextFrame.length = 0;
        while (this.tail != this.head) {
            int new_tail;
            System.arraycopy(this.data, this.offset[this.tail], this.nextFrame.data, this.nextFrame.length, this.length[this.tail]);
            this.nextFrame.length += this.length[this.tail];
            byte this_type = this.get_this_type(this.tail);
            byte next_type = this.get_next_type(this.tail);
            boolean done = false;
            switch (this.codecType) {
                case 50: {
                    if (!this.h264.isFrame(this_type)) break;
                    done = true;
                    break;
                }
                case 60: {
                    if (!this.h265.isFrame(this_type, next_type)) break;
                    done = true;
                }
            }
            if (this.nal_size < this.nal_list.length) {
                this.nal_list[this.nal_size++] = this_type;
            }
            if ((new_tail = this.tail + 1) == 256) {
                new_tail = 0;
            }
            this.tail = new_tail;
            if (!done) continue;
            break;
        }
        return this.nextFrame;
    }

    public String get_nal_list() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int a = 0; a < this.nal_size; ++a) {
            if (a > 0) {
                sb.append(',');
            }
            sb.append(Integer.toString(this.nal_list[a] & 0xFF, 16));
        }
        sb.append('}');
        return sb.toString();
    }

    public String toString() {
        return "PacketBuffer:tail=" + this.tail + ":head=" + this.head;
    }
}

