/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Color;
import javaforce.webui.Component;
import javaforce.webui.Container;
import javaforce.webui.Label;
import javaforce.webui.Panel;

public class SplitPanel
extends Panel {
    private int dir;
    private int pos = 50;
    private int side;
    private Container div;
    private Container t1;
    private Container t2;
    private static final int DIV_SIZE = 5;

    public SplitPanel(int direction) {
        this.init(direction, direction == 1 ? 3 : 5);
    }

    public SplitPanel(int direction, int flexSide) {
        this.init(direction, flexSide);
    }

    private void init(int direction, int flexSide) {
        this.dir = direction;
        this.side = flexSide;
        this.div = new Container();
        this.div.setClass("splitDivider");
        this.div.setBackColor(Color.grey);
        block0 : switch (this.dir) {
            case 1: {
                this.setClass("splitPanelRow");
                this.t1 = new Panel();
                this.t1.setMaxHeight();
                this.t1.setVerticalAlign(4);
                this.t1.add(new Label("left"));
                this.t2 = new Panel();
                this.t2.setMaxHeight();
                this.t2.setVerticalAlign(4);
                this.t2.add(new Label("right"));
                this.div.setWidth(5);
                this.div.setMaxHeight();
                switch (this.side) {
                    case 1: {
                        this.t1.setFlex(true);
                        this.t2.setWidth(this.pos);
                        break;
                    }
                    case 3: {
                        this.t1.setWidth(this.pos);
                        this.t2.setFlex(true);
                    }
                }
                break;
            }
            case 2: {
                this.setClass("splitPanelColumn");
                this.t1 = new Panel();
                this.t1.setMaxWidth();
                this.t1.setVerticalAlign(4);
                this.t1.add(new Label("top"));
                this.t2 = new Panel();
                this.t2.setMaxHeight();
                this.t2.setVerticalAlign(4);
                this.t2.add(new Label("bottom"));
                this.div.setHeight(5);
                this.div.setMaxWidth();
                switch (this.side) {
                    case 4: {
                        this.t1.setFlex(true);
                        this.t2.setHeight(this.pos);
                        break block0;
                    }
                    case 5: {
                        this.t1.setHeight(this.pos);
                        this.t2.setFlex(true);
                    }
                }
            }
        }
        this.add(this.t1);
        this.add(this.div);
        this.add(this.t2);
        this.setMaxWidth();
        this.setMaxHeight();
    }

    @Override
    public void init() {
        super.init();
        this.div.addEvent("onmousedown", "onmousedownSplitPanel(event,this,\"" + this.t1.id + "\",\"" + this.div.id + "\",\"" + this.t2.id + "\",\"" + this.id + "\",\"" + (this.dir == 1 ? (char)'v' : 'h') + "\",\"" + (this.dir == 1 ? (this.side == 1 ? (char)'l' : 'r') : (this.side == 4 ? (char)'t' : 'b')) + "\");");
    }

    public int getDirection() {
        return this.dir;
    }

    public void setDividerPosition(int pos) {
        this.pos = pos;
        block0 : switch (this.dir) {
            case 1: {
                switch (this.side) {
                    case 1: {
                        this.t2.setWidth(pos);
                        break;
                    }
                    case 3: {
                        this.t1.setWidth(pos);
                    }
                }
                break;
            }
            case 2: {
                switch (this.side) {
                    case 4: {
                        this.t2.setHeight(pos);
                        break block0;
                    }
                    case 5: {
                        this.t1.setHeight(pos);
                    }
                }
            }
        }
    }

    public int getDividerPosition() {
        return this.pos;
    }

    public Component getLeftComponent() {
        return this.t1.get(0);
    }

    public Component getTopComponent() {
        return this.t1.get(0);
    }

    public Component getRightComponent() {
        return this.t2.get(0);
    }

    public Component getBottomComponent() {
        return this.t2.get(0);
    }

    public void setLeftComponent(Component c) {
        this.t1.set(0, c);
        this.sendOnResize();
    }

    public void setTopComponent(Component c) {
        this.t1.set(0, c);
        this.sendOnResize();
    }

    public void setRightComponent(Component c) {
        this.t2.set(0, c);
        this.sendOnResize();
    }

    public void setBottomComponent(Component c) {
        this.t2.set(0, c);
        this.sendOnResize();
    }

    @Override
    public void onEvent(String event, String[] args) {
        switch (event) {
            case "dividerpos": {
                for (String arg : args) {
                    if (!arg.startsWith("pos=")) continue;
                    this.pos = Integer.valueOf(arg.substring(4));
                    this.onChanged(null);
                }
                break;
            }
        }
    }
}

