/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.panel;

import javaforce.webui.Button;
import javaforce.webui.Column;
import javaforce.webui.Label;
import javaforce.webui.PopupPanel;
import javaforce.webui.Row;
import javaforce.webui.Slider;

public class ColorChooserPanel
extends PopupPanel {
    private Label rv;
    private Label gv;
    private Label bv;
    private Slider r;
    private Slider g;
    private Slider b;
    private Button ok;
    private Button cancel;
    private Button clr;

    public ColorChooserPanel() {
        super("Select Color");
        this.setModal(true);
        Row row = new Row();
        this.add(row);
        Column col = new Column();
        row.add(col);
        Label rl = new Label("R");
        rl.setAlign(2);
        col.add(rl);
        this.r = new Slider(1, 0, 255, 1);
        this.r.addChangedListener(c -> {
            this.rv.setText(Integer.toString(this.r.getPos()));
            this.setClr();
        });
        col.add(this.r);
        this.rv = new Label("0");
        this.rv.setAlign(2);
        this.rv.setSize(96, 32);
        col.add(this.rv);
        col = new Column();
        row.add(col);
        Label gl = new Label("G");
        gl.setAlign(2);
        col.add(gl);
        this.g = new Slider(1, 0, 255, 1);
        this.g.addChangedListener(c -> {
            this.gv.setText(Integer.toString(this.g.getPos()));
            this.setClr();
        });
        col.add(this.g);
        this.gv = new Label("0");
        this.gv.setAlign(2);
        this.gv.setSize(96, 32);
        col.add(this.gv);
        col = new Column();
        row.add(col);
        Label bl = new Label("B");
        bl.setAlign(2);
        col.add(bl);
        this.b = new Slider(1, 0, 255, 1);
        this.b.addChangedListener(c -> {
            this.bv.setText(Integer.toString(this.b.getPos()));
            this.setClr();
        });
        col.add(this.b);
        this.bv = new Label("0");
        this.bv.setAlign(2);
        this.bv.setSize(96, 32);
        col.add(this.bv);
        row = new Row();
        this.add(row);
        this.ok = new Button("OK");
        row.add(this.ok);
        this.cancel = new Button("Cancel");
        row.add(this.cancel);
        this.clr = new Button("-");
        row.add(this.clr);
        this.ok.addClickListener((e, c) -> {
            this.setVisible(false);
            this.action();
        });
        this.cancel.addClickListener((e, c) -> this.setVisible(false));
    }

    public void setValue(int rgb) {
        int _r = (rgb & 0xFF0000) >> 16;
        int _g = (rgb & 0xFF00) >> 8;
        int _b = rgb & 0xFF;
        this.rv.setText(Integer.toString(_r));
        this.r.setPos(_r);
        this.gv.setText(Integer.toString(_g));
        this.g.setPos(_g);
        this.bv.setText(Integer.toString(_b));
        this.b.setPos(_b);
        this.clr.setColor(rgb);
        this.clr.setBackColor(rgb);
    }

    public int getValue() {
        int rgb = 0;
        rgb |= this.r.getPos() << 16;
        rgb |= this.g.getPos() << 8;
        return rgb |= this.b.getPos();
    }

    public void setComponentsSize(int width, int height) {
        this.ok.setSize(width, height);
        this.cancel.setSize(width * 2, height);
        this.clr.setSize(width, height);
    }

    private void setClr() {
        this.clr.setBackColor(this.getValue());
    }
}

