/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.panel;

import java.util.ArrayList;
import javaforce.access.AccessControl;
import javaforce.access.Group;
import javaforce.webui.Button;
import javaforce.webui.Component;
import javaforce.webui.FlexBox;
import javaforce.webui.GridLayout;
import javaforce.webui.Label;
import javaforce.webui.ListBox;
import javaforce.webui.Panel;
import javaforce.webui.PopupPanel;
import javaforce.webui.TabPanel;
import javaforce.webui.TextField;
import javaforce.webui.ToolBar;
import javaforce.webui.WebUIClient;
import javaforce.webui.panel.SelectFromListPanel;

public class EditGroupPanel
extends PopupPanel {
    private TextField name;
    private TextField desc;
    private ListBox list;
    private ArrayList<String> removes;
    private Group group;
    private AccessControl access;

    public EditGroupPanel(String title, WebUIClient client) {
        super(title);
        this.setModal(true);
        this.access = client.getAccessControl();
        TabPanel tabs = new TabPanel();
        this.add(tabs);
        Panel general = new Panel();
        GridLayout grid = new GridLayout(2, 0, new int[]{3, 1});
        general.add(grid);
        Component[] componentArray = new Component[2];
        componentArray[0] = new Label("Name");
        this.name = new TextField("");
        componentArray[1] = this.name;
        grid.addRow(componentArray);
        Component[] componentArray2 = new Component[2];
        componentArray2[0] = new Label("Description");
        this.desc = new TextField("");
        componentArray2[1] = this.desc;
        grid.addRow(componentArray2);
        this.name.setReadonly(true);
        tabs.addTab(general, "Account");
        Panel membership = new Panel();
        this.list = new ListBox();
        this.list.setWidth(256);
        this.list.setHeight(256);
        membership.add(this.list);
        ToolBar tools = new ToolBar();
        membership.add(tools);
        Button add = new Button("Add");
        tools.add(add);
        Button remove = new Button("Remove");
        tools.add(remove);
        tabs.addTab(membership, "Members");
        tools = new ToolBar();
        this.add(tools);
        tools.add(new FlexBox());
        Button accept = new Button("Accept");
        tools.add(accept);
        Button cancel = new Button("Cancel");
        tools.add(cancel);
        add.addClickListener((event, cmp) -> {
            SelectFromListPanel select = client.getSelectFromListPanel();
            select.set(this.access.getUsers(), "Add User", () -> {
                String user = select.getSelectedText();
                if (this.list.contains(user)) {
                    return;
                }
                this.list.add(user);
                if (this.removes.contains(user)) {
                    this.removes.remove(user);
                }
            });
            select.setVisible(true);
        });
        remove.addClickListener((event, cmp) -> {
            int idx = this.list.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            String user = this.list.getSelectedItem();
            this.list.remove(idx);
            this.removes.add(user);
        });
        accept.addClickListener((event, cmp) -> {
            Object object = this.access.lock;
            synchronized (object) {
                this.group.desc = this.desc.getText();
                int cnt = this.list.getCount();
                for (int i = 0; i < cnt; ++i) {
                    String user = this.list.getItem(i);
                    if (this.group.contains(user)) continue;
                    this.group.addUser(user);
                }
                for (String user : this.removes) {
                    this.group.removeUser(user);
                }
                this.access.saveGroups();
            }
            this.setVisible(false);
        });
        cancel.addClickListener((event, cmp) -> this.setVisible(false));
    }

    public void set(Group group) {
        String[] users;
        this.group = group;
        this.name.setText(group.name);
        this.desc.setText(group.desc);
        this.list.removeAll();
        for (String name : users = group.getUsers()) {
            this.list.add(name);
        }
        this.removes = new ArrayList();
    }
}

