/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.panel;

import javaforce.access.Group;
import javaforce.access.Groups;
import javaforce.webui.Button;
import javaforce.webui.Component;
import javaforce.webui.Label;
import javaforce.webui.Panel;
import javaforce.webui.Table;
import javaforce.webui.ToolBar;
import javaforce.webui.WebUIClient;

public class GroupsPanel
extends Panel {
    private Table table;
    private Groups groups;
    private Group[] list;
    private static final int col_height = 25;

    public GroupsPanel(WebUIClient client) {
        this.groups = client.getAccessControl().getGroupsList();
        ToolBar toolbar = new ToolBar();
        this.add(toolbar);
        Button refresh = new Button("Refresh");
        toolbar.add(refresh);
        Button create = new Button("Create");
        toolbar.add(create);
        Button edit = new Button("Edit");
        toolbar.add(edit);
        Button delete = new Button("Delete");
        toolbar.add(delete);
        this.table = new Table(new int[]{150, 250}, 25, 4, 0);
        this.add(this.table);
        this.table.setSelectionMode(1);
        this.table.setBorder(true);
        final Runnable init = new Runnable(){

            @Override
            public void run() {
                GroupsPanel.this.table.removeAll();
                for (Group group : GroupsPanel.this.list = GroupsPanel.this.groups.getGroups()) {
                    GroupsPanel.this.table.addRow(new Component[]{new Label(group.name), new Label(group.desc)});
                }
            }
        };
        init.run();
        refresh.addClickListener((event, cmp) -> init.run());
        create.addClickListener((event, cmp) -> {
            client.new_group_panel.clear();
            client.new_group_panel.setVisible(true);
        });
        edit.addClickListener((event, cmp) -> {
            int idx = this.table.getSelectedRow();
            if (idx == -1) {
                return;
            }
            client.edit_group_panel.set(this.list[idx]);
            client.edit_group_panel.setVisible(true);
        });
        delete.addClickListener((event, cmp) -> {
            final int idx = this.table.getSelectedRow();
            if (idx == -1) {
                return;
            }
            client.confirm_panel.set("Delete group " + this.list[idx].name + "?", "Delete", new Runnable(){
                final /* synthetic */ GroupsPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    Group group = this.this$0.list[idx];
                    this.this$0.groups.removeGroup(group.name);
                    init.run();
                }
            });
            client.confirm_panel.setVisible(true);
        });
    }
}

