/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.JFLog;

public class FTP {
    protected Socket s;
    private Socket ds;
    protected InputStream is;
    protected OutputStream os;
    protected BufferedReader br;
    private boolean passive = true;
    protected String host;
    private int pasvport;
    private ServerSocket ss;
    private ProgressListener progress;
    private boolean aborted = false;
    protected boolean active = true;
    protected Reader reader;
    public static boolean debug = false;
    public static boolean debug_log = false;
    public static int log;
    public ArrayList<String> response = new ArrayList();
    private final int BUFSIZ = 65536;
    private Timer timer;
    private int timeoutCounter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponseLength() {
        ArrayList<String> arrayList = this.response;
        synchronized (arrayList) {
            return this.response.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponse(String r) {
        ArrayList<String> arrayList = this.response;
        synchronized (arrayList) {
            this.response.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextResponse() {
        ArrayList<String> arrayList = this.response;
        synchronized (arrayList) {
            if (this.response.size() == 0) {
                return null;
            }
            return this.response.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastResponse() {
        while (!this.aborted) {
            ArrayList<String> arrayList = this.response;
            synchronized (arrayList) {
                if (this.response.size() == 0) {
                    return null;
                }
                String res = this.response.remove(0);
                if (res.charAt(3) == ' ') {
                    return res;
                }
            }
        }
        return null;
    }

    public boolean connect(String host, int port) throws Exception {
        this.active = true;
        this.s = new Socket(host, port);
        this.is = this.s.getInputStream();
        this.br = new BufferedReader(new InputStreamReader(this.is));
        this.os = this.s.getOutputStream();
        this.host = host;
        this.reader = new Reader(this);
        this.reader.start();
        this.wait4Response();
        if (this.getLastResponse().startsWith("220")) {
            return true;
        }
        this.disconnect();
        return false;
    }

    public void abort() {
        this.aborted = true;
    }

    public void disconnect() throws Exception {
        this.active = false;
        if (this.s != null) {
            this.s.close();
        }
        this.s = null;
        this.is = null;
        this.os = null;
        this.reader = null;
    }

    public void addProgressListener(ProgressListener progress) {
        this.progress = progress;
    }

    public static void setLogging(boolean state) {
        debug_log = state;
    }

    public static void setLog(int id) {
        log = id;
    }

    public void setPassiveMode(boolean mode) {
        this.passive = mode;
    }

    public boolean setBinary() throws Exception {
        this.cmd("type i");
        this.wait4Response();
        return this.getLastResponse().startsWith("200");
    }

    public boolean setAscii() throws Exception {
        this.cmd("type a");
        this.wait4Response();
        return this.getLastResponse().startsWith("200");
    }

    public boolean login(String user, String pass) throws Exception {
        this.cmd("user " + user);
        this.wait4Response();
        String res = this.getLastResponse();
        if (res.startsWith("230")) {
            return true;
        }
        if (!res.startsWith("331")) {
            return false;
        }
        this.cmd("pass " + pass);
        this.wait4Response();
        return this.getLastResponse().startsWith("230");
    }

    public void logout() throws Exception {
        this.cmd("quit");
        this.wait4Response();
        this.getLastResponse();
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmd(String cmd) throws Exception {
        if (this.s == null || this.s.isClosed()) {
            throw new Exception("not connected");
        }
        this.aborted = false;
        if (debug_log) {
            if (((String)cmd).startsWith("pass ")) {
                JFLog.log(log, "pass ****");
            } else {
                JFLog.log(log, (String)cmd);
            }
        }
        ArrayList<String> arrayList = this.response;
        synchronized (arrayList) {
            this.response.clear();
        }
        cmd = (String)cmd + "\r\n";
        this.os.write(((String)cmd).getBytes());
    }

    public void get(String filename, String out) throws Exception {
        this.getPort();
        this.cmd("retr " + filename);
        FileOutputStream fos = new FileOutputStream(out);
        this.getData(fos);
        fos.close();
        this.wait4Response();
        this.getLastResponse();
    }

    public void get(String filename, OutputStream os) throws Exception {
        this.getPort();
        this.cmd("retr " + filename);
        this.getData(os);
        this.wait4Response();
        this.getLastResponse();
    }

    public InputStream getStart(String filename) throws Exception {
        this.getPort();
        this.cmd("retr " + filename);
        return this.getData();
    }

    public void get(File remote, File local) throws Exception {
        this.get(remote.getAbsolutePath(), local.getAbsolutePath());
    }

    public void getFinish() throws Exception {
        this.wait4Response();
        this.getLastResponse();
    }

    public void put(InputStream is, String filename) throws Exception {
        this.getPort();
        this.cmd("stor " + filename);
        this.putData(is);
        this.wait4Response();
        if (!this.getLastResponse().startsWith("226")) {
            throw new Exception("bad put");
        }
    }

    public void put(String in, String filename) throws Exception {
        this.getPort();
        this.cmd("stor " + filename);
        FileInputStream fis = new FileInputStream(in);
        this.putData(fis);
        fis.close();
        this.wait4Response();
        if (!this.getLastResponse().startsWith("226")) {
            throw new Exception("bad put");
        }
    }

    public void put(File local, File remote) throws Exception {
        this.put(local.getAbsolutePath(), remote.getName());
    }

    public OutputStream putStart(String filename) throws Exception {
        this.getPort();
        this.cmd("stor " + filename);
        return this.putData();
    }

    public void putFinish() throws Exception {
        this.wait4Response();
        this.getLastResponse();
    }

    public void cd(String path) throws Exception {
        this.cmd("cwd " + path);
        this.wait4Response();
        this.getLastResponse();
    }

    public void chmod(int mode, String path) throws Exception {
        this.cmd("site chmod " + Integer.toString(mode, 8) + " " + path);
        this.wait4Response();
        this.getLastResponse();
    }

    public void mkdir(String path) throws Exception {
        this.cmd("mkd " + path);
        this.wait4Response();
        this.getLastResponse();
    }

    public void rename(String oldpath, String newpath) throws Exception {
        this.cmd("rnfr " + oldpath);
        this.wait4Response();
        this.getLastResponse();
        this.cmd("rnto " + newpath);
        this.wait4Response();
        this.getLastResponse();
    }

    public void rm(String path) throws Exception {
        this.cmd("dele " + path);
        this.wait4Response();
        this.getLastResponse();
    }

    public void rmdir(String path) throws Exception {
        this.cmd("rmd " + path);
        this.wait4Response();
        this.getLastResponse();
    }

    public String ls(String path) throws Exception {
        this.getPort();
        this.cmd("list " + path);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getData(baos);
        this.wait4Response();
        if (!this.getLastResponse().startsWith("226")) {
            throw new Exception("bad listing");
        }
        return baos.toString();
    }

    public String pwd() throws Exception {
        this.cmd("pwd");
        this.wait4Response();
        String str = this.getLastResponse();
        if (!str.startsWith("257")) {
            throw new Exception("pwd failed");
        }
        if (str.charAt(4) == '\"' && str.charAt(str.length() - 1) == '\"') {
            return str.substring(5, str.length() - 1);
        }
        return str.substring(4);
    }

    protected ServerSocket createServerSocket() throws Exception {
        return new ServerSocket();
    }

    protected Socket connectData(String host, int port) throws Exception {
        return new Socket(host, port);
    }

    private void getPort() throws Exception {
        if (this.passive) {
            this.cmd("pasv");
            this.wait4Response();
            String str = this.getLastResponse();
            if (!str.startsWith("227")) {
                throw new Exception("pasv failed");
            }
            String[] strs = str.split(",");
            if (strs.length != 6) {
                throw new Exception("pasv failed - bad response");
            }
            int hi = Integer.valueOf(strs[4]);
            int lo = Integer.valueOf(strs[5].substring(0, strs[5].indexOf(")")));
            this.pasvport = (hi << 8) + lo;
        } else {
            this.ss = this.createServerSocket();
            int hi = this.ss.getLocalPort() >> 8;
            int lo = this.ss.getLocalPort() & 0xFF;
            this.cmd("port " + this.s.getLocalAddress().getHostAddress().replaceAll("[.]", ",") + "," + hi + "," + lo);
            this.wait4Response();
            String str = this.getLastResponse();
            if (!str.startsWith("200")) {
                throw new Exception("port failed");
            }
        }
        this.ds = this.passive ? this.connectData(this.host, this.pasvport) : this.ss.accept();
    }

    private InputStream getData() throws Exception {
        this.aborted = false;
        InputStream dis = this.ds.getInputStream();
        this.wait4Response();
        if (!this.getLastResponse().startsWith("150")) {
            throw new Exception("bad get");
        }
        return dis;
    }

    private void getData(OutputStream os) throws Exception {
        int read;
        this.aborted = false;
        byte[] data = new byte[65536];
        InputStream dis = this.ds.getInputStream();
        this.wait4Response();
        if (!this.getLastResponse().startsWith("150")) {
            throw new Exception("bad get");
        }
        int total = 0;
        this.startTimeoutThread();
        while (!this.ds.isClosed() && !this.aborted) {
            this.timeoutCounter = 0;
            read = dis.read(data);
            if (read == -1) break;
            if (read <= 0) continue;
            os.write(data, 0, read);
            total += read;
            if (this.progress == null) continue;
            this.progress.setProgress(total);
        }
        if (this.aborted) {
            return;
        }
        do {
            this.timeoutCounter = 0;
            read = dis.read(data);
            if (read <= 0) continue;
            os.write(data, 0, read);
            total += read;
            if (this.progress == null) continue;
            this.progress.setProgress(total);
        } while (read > 0 && !this.aborted);
        this.stopTimeoutThread();
    }

    private OutputStream putData() throws Exception {
        this.aborted = false;
        OutputStream dos = this.ds.getOutputStream();
        this.wait4Response();
        if (!this.getLastResponse().startsWith("150")) {
            throw new Exception("bad put");
        }
        return dos;
    }

    private void putData(InputStream is) throws Exception {
        this.aborted = false;
        byte[] data = new byte[65536];
        OutputStream dos = this.ds.getOutputStream();
        this.wait4Response();
        if (!this.getLastResponse().startsWith("150")) {
            throw new Exception("bad put");
        }
        int total = 0;
        this.startTimeoutThread();
        while (!this.ds.isClosed() && is.available() > 0 && !this.aborted) {
            this.timeoutCounter = 0;
            int read = is.read(data);
            if (read <= 0) continue;
            dos.write(data, 0, read);
            total += read;
            if (this.progress == null) continue;
            this.progress.setProgress(total);
        }
        this.stopTimeoutThread();
        dos.flush();
        this.ds.close();
        this.ds = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wait4Response() throws Exception {
        while (!this.aborted) {
            ArrayList<String> arrayList = this.response;
            synchronized (arrayList) {
                String last;
                int size = this.response.size();
                if (size > 0 && (last = this.response.get(size - 1)).charAt(3) == ' ') {
                    return;
                }
                this.response.wait();
            }
        }
    }

    private void startTimeoutThread() {
        this.timeoutCounter = 0;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ FTP this$0;
            {
                FTP fTP = this$0;
                Objects.requireNonNull(fTP);
                this.this$0 = fTP;
            }

            @Override
            public void run() {
                ++this.this$0.timeoutCounter;
                if (this.this$0.timeoutCounter == 20) {
                    JFLog.log(log, "Error:Transfer Timeout");
                    this.this$0.aborted = true;
                    if (this.this$0.ds != null) {
                        try {
                            this.this$0.ds.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.this$0.ds = null;
                    }
                    this.this$0.timer.cancel();
                    this.this$0.timer = null;
                }
            }
        }, 1000L, 1000L);
    }

    private void stopTimeoutThread() {
        this.timer.cancel();
        this.timer = null;
    }

    public static void main(String[] args) {
    }

    protected class Reader
    extends Thread {
        final /* synthetic */ FTP this$0;

        protected Reader(FTP this$0) {
            FTP fTP = this$0;
            Objects.requireNonNull(fTP);
            this.this$0 = fTP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.this$0.active) {
                try {
                    String res = this.this$0.br.readLine();
                    if (res == null) {
                        throw new Exception("FTP:invalid reply:null");
                    }
                    if (res.length() < 3) {
                        throw new Exception("FTP:invalid reply:" + res);
                    }
                    JFLog.log(log, res);
                    this.this$0.addResponse(res);
                    if (res.charAt(3) == ' ') {
                        ArrayList<String> arrayList = this.this$0.response;
                        synchronized (arrayList) {
                            this.this$0.response.notify();
                        }
                    }
                    if (!res.startsWith("5")) continue;
                    JFLog.log(log, "Aborted");
                    this.this$0.aborted = true;
                    if (this.this$0.ds == null) continue;
                    this.this$0.ds.close();
                    this.this$0.ds = null;
                }
                catch (SocketException se) {
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }

    public static interface ProgressListener {
        public void setProgress(int var1);
    }
}

