/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javaforce.BE;
import javaforce.JFLog;

public class JFByteBuffer {
    private byte[] buffer;
    private int length;
    private int read_offset;
    private int write_offset;
    private int max_length;
    private byte[] tmp = new byte[8];

    public JFByteBuffer(int max_length) {
        this.max_length = max_length;
        this.buffer = new byte[max_length];
    }

    public void reset() {
        this.length = 0;
        this.read_offset = 0;
        this.write_offset = 0;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getOffset() {
        return this.read_offset;
    }

    public int getLength() {
        return this.length;
    }

    public int available() {
        return this.buffer.length - this.write_offset;
    }

    public void compact() {
        if (this.read_offset == 0) {
            return;
        }
        if (this.length == 0) {
            this.read_offset = 0;
            this.write_offset = 0;
            return;
        }
        System.arraycopy(this.buffer, this.read_offset, this.buffer, 0, this.length);
        this.read_offset = 0;
        this.write_offset = this.length;
    }

    public int indexOf(byte[] key) {
        int key_len = key.length;
        if (this.length < key_len) {
            return -1;
        }
        int end = this.length - key_len;
        for (int i = 0; i <= end; ++i) {
            if (Arrays.compare(this.buffer, this.read_offset + i, this.read_offset + i + key_len, key, 0, key_len) != 0) continue;
            return i;
        }
        return -1;
    }

    public boolean startsWith(byte[] key) {
        int key_len = key.length;
        if (this.length < key_len) {
            return false;
        }
        for (int i = 0; i < key_len; ++i) {
            if (this.buffer[this.read_offset + i] == key[i]) continue;
            return false;
        }
        return true;
    }

    public void skip(int bytes) {
        if (this.length <= bytes) {
            this.length = 0;
            this.read_offset = 0;
            this.write_offset = 0;
            return;
        }
        this.read_offset += bytes;
        this.length -= bytes;
    }

    public byte readByte() {
        if (this.length < 1) {
            return -1;
        }
        --this.length;
        return this.buffer[this.read_offset++];
    }

    public short readShort() {
        if (this.length < 2) {
            return -1;
        }
        short value = (short)BE.getuint16(this.buffer, this.read_offset);
        this.read_offset += 2;
        this.length -= 2;
        return value;
    }

    public int readInt() {
        if (this.length < 4) {
            return -1;
        }
        int value = BE.getuint32(this.buffer, this.read_offset);
        this.read_offset += 4;
        this.length -= 4;
        return value;
    }

    public long readLong() {
        if (this.length < 8) {
            return -1L;
        }
        long value = BE.getuint64(this.buffer, this.read_offset);
        this.read_offset += 8;
        this.length -= 8;
        return value;
    }

    public boolean readBytes(byte[] out, int off, int len) {
        if (this.length < len) {
            return false;
        }
        System.arraycopy(this.buffer, this.read_offset, out, off, len);
        this.read_offset += len;
        this.length -= len;
        return true;
    }

    public int readBytes(OutputStream os, int max_bytes) {
        if (max_bytes > this.length) {
            max_bytes = this.length;
        }
        try {
            os.write(this.buffer, this.read_offset, max_bytes);
            this.length -= max_bytes;
            this.read_offset += max_bytes;
            return max_bytes;
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1;
        }
    }

    public String readString(int strlen) {
        if (this.length < strlen) {
            return null;
        }
        String s = new String(this.buffer, this.read_offset, strlen);
        this.read_offset += strlen;
        this.length -= strlen;
        return s;
    }

    public boolean write(byte b) {
        if (this.available() < 1) {
            return false;
        }
        this.buffer[this.write_offset++] = b;
        ++this.length;
        return true;
    }

    public boolean write(short len) {
        BE.setuint16(this.tmp, 0, len);
        return this.write(this.tmp, 0, 2);
    }

    public boolean write(int len) {
        BE.setuint32(this.tmp, 0, len);
        return this.write(this.tmp, 0, 4);
    }

    public boolean write(long len) {
        BE.setuint64(this.tmp, 0, len);
        return this.write(this.tmp, 0, 8);
    }

    public boolean write(byte[] in, int off, int len) {
        if (this.available() < len) {
            return false;
        }
        System.arraycopy(in, off, this.buffer, this.write_offset, len);
        this.write_offset += len;
        this.length += len;
        return true;
    }

    public boolean write(String s) {
        return this.write(s.getBytes(), 0, s.length());
    }

    public int write(InputStream is, int max_bytes) {
        if (max_bytes > this.available()) {
            max_bytes = this.available();
        }
        try {
            int read = is.read(this.buffer, this.write_offset, max_bytes);
            if (read == -1) {
                throw new Exception("JFByteBuffer:read() failed");
            }
            if (read > 0) {
                this.write_offset += read;
                this.length += read;
            }
            return read;
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1;
        }
    }
}

