/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.util.ArrayList;
import java.util.Objects;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.MQTT;
import javaforce.MQTTEvents;

public class MQTTForward {
    private String host;
    private int port = 1883;
    private KeyMgmt keys;
    private String user;
    private String pass;
    private int max_queue_size = 1000;
    private int keep_alive = 30;
    private long last_packet = -1L;
    private boolean connected;
    private ArrayList<Entry> queue = new ArrayList();
    private Object queue_lock = new Object();
    private MQTT client;
    private Object client_lock = new Object();
    private Server server;
    private boolean active;

    public void start(String host, int port) {
        this.start(host, port, null, null, null);
    }

    public void start(String host, int port, KeyMgmt keys) {
        this.start(host, port, keys, null, null);
    }

    public void start(String host, String user, String pass) {
        this.start(host, 1883, null, user, pass);
    }

    public void start(String host, KeyMgmt keys, String user, String pass) {
        this.start(host, 1883, keys, user, pass);
    }

    public void start(String host, int port, String user, String pass) {
        this.start(host, port, null, user, pass);
    }

    public void start(String host, int port, KeyMgmt keys, String user, String pass) {
        this.host = host;
        this.port = port;
        this.keys = keys;
        this.user = user;
        this.pass = pass;
        this.active = true;
        this.server = new Server(this);
        this.server.start();
    }

    public void stop() {
        this.active = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setMaxQueueSize(int size) {
        if (size < 100) {
            size = 100;
        }
        this.max_queue_size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String topic, String msg) {
        Object object = this.queue_lock;
        synchronized (object) {
            if (this.queue.size() > this.max_queue_size) {
                JFLog.log("Error:MQTTForward Queue > " + this.max_queue_size);
                return;
            }
            this.queue.add(new Entry(topic, msg));
            this.queue_lock.notify();
        }
    }

    public void setKeepAlive(int value) {
        this.keep_alive = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.client_lock;
        synchronized (object) {
            this.connected = false;
            if (this.client != null) {
                this.client.disconnect();
                this.client = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry remove() {
        if (this.active) {
            Object object = this.queue_lock;
            synchronized (object) {
                if (this.queue.size() == 0) {
                    try {
                        this.queue_lock.wait(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
                Entry entry = this.queue.remove(0);
                return entry;
            }
        }
        return null;
    }

    private class Server
    extends Thread
    implements MQTTEvents {
        public int count;
        final /* synthetic */ MQTTForward this$0;

        private Server(MQTTForward mQTTForward) {
            MQTTForward mQTTForward2 = mQTTForward;
            Objects.requireNonNull(mQTTForward2);
            this.this$0 = mQTTForward2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.this$0.active) {
                Entry entry = this.this$0.remove();
                if (entry == null) {
                    JF.sleep(500);
                    if (this.this$0.keep_alive <= 0) continue;
                    ++this.count;
                    if (this.count < this.this$0.keep_alive) continue;
                    this.count = 0;
                }
                this.count = 0;
                try {
                    Object object = this.this$0.client_lock;
                    synchronized (object) {
                        if (this.this$0.client != null && this.this$0.keep_alive > 0) {
                            long timeout = System.currentTimeMillis() - (long)(this.this$0.keep_alive * 1000 * 2);
                            if (this.this$0.client.getLastPacketTimestamp() < timeout) {
                                this.this$0.reconnect();
                            }
                        }
                        if (this.this$0.client != null && !this.this$0.client.isConnected()) {
                            this.this$0.reconnect();
                        }
                        while (this.this$0.client == null) {
                            this.this$0.client = new MQTT();
                            this.this$0.client.setListener(this);
                            if (this.this$0.keys == null) {
                                if (!this.this$0.client.connect(this.this$0.host, this.this$0.port)) {
                                    this.this$0.client = null;
                                    this.this$0.connected = false;
                                }
                            } else if (!this.this$0.client.connect(this.this$0.host, this.this$0.port, this.this$0.keys)) {
                                this.this$0.client = null;
                                this.this$0.connected = false;
                            }
                            if (this.this$0.client != null) {
                                if (this.this$0.user != null && this.this$0.pass != null) {
                                    this.this$0.client.connect(this.this$0.user, this.this$0.pass);
                                } else {
                                    this.this$0.client.connect();
                                }
                            }
                            if (this.this$0.client == null) continue;
                            if (this.this$0.client.isConnected()) break;
                            this.this$0.client = null;
                            this.this$0.connected = false;
                            JF.sleep(1000);
                        }
                        if (entry != null) {
                            this.this$0.client.publish(entry.topic, entry.msg);
                        } else {
                            this.this$0.client.ping();
                        }
                    }
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }

        @Override
        public void onConnect() {
            this.this$0.connected = true;
        }

        @Override
        public void onSubscribe(String topic) {
        }

        @Override
        public void onMessage(String topic, String msg) {
        }
    }

    private static class Entry {
        public String topic;
        public String msg;

        public Entry(String topic, String msg) {
            this.topic = topic;
            this.msg = msg;
        }
    }
}

