/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ShellProcessListener;

public class ShellProcess {
    private Process p;
    private InputStream is;
    private InputStream es;
    private OutputStream os;
    private StringBuffer stdout;
    private StringBuffer stderr;
    private boolean active;
    private ArrayList<Response> script = new ArrayList();
    private ArrayList<Variable> envAdd = new ArrayList();
    private ArrayList<Variable> envRemove = new ArrayList();
    private ShellProcessListener listener = null;
    private File path;
    private int errorLevel;
    private boolean keepOutput = true;
    private boolean inherit = false;
    public static boolean log = false;
    public static boolean logPrompt = false;
    public String command;

    public void addResponse(String prompt, String reply, boolean repeat) {
        Response res = new Response();
        res.prompt = prompt.trim();
        res.reply = reply;
        res.repeat = repeat;
        res.regex = false;
        res.term = false;
        this.script.add(res);
    }

    public void addTerminate(String prompt) {
        Response res = new Response();
        res.prompt = prompt.trim();
        res.reply = "";
        res.repeat = false;
        res.regex = false;
        res.term = true;
        this.script.add(res);
    }

    public void addRegexResponse(String prompt_regex, String reply, boolean repeat) {
        Response res = new Response();
        res.prompt = prompt_regex.trim();
        res.reply = reply;
        res.repeat = repeat;
        res.regex = true;
        res.term = false;
        this.script.add(res);
    }

    public void addRegexTerminate(String prompt_regex) {
        Response res = new Response();
        res.prompt = prompt_regex.trim();
        res.reply = "";
        res.repeat = false;
        res.regex = true;
        res.term = true;
        this.script.add(res);
    }

    public void addListener(ShellProcessListener listener) {
        this.listener = listener;
    }

    public ShellProcessListener getListener() {
        return this.listener;
    }

    public void addEnvironmentVariable(String name, String value) {
        this.envAdd.add(new Variable(name, value));
    }

    public void removeEnvironmentVariable(String name) {
        this.envRemove.add(new Variable(name, null));
    }

    public void setFolder(File path) {
        this.path = path;
    }

    public void keepOutput(boolean state) {
        this.keepOutput = state;
    }

    public void inherit(boolean state) {
        this.inherit = state;
    }

    public String run(List<String> cmd, boolean redirStderr) {
        return this.run(cmd.toArray(JF.StringArrayType), redirStderr);
    }

    public String run(String[] cmd, boolean redirStderr) {
        Variable v;
        int a;
        if (cmd[0].equals("sudo")) {
            String[] newcmd = new String[cmd.length + 1];
            newcmd[0] = "sudo";
            newcmd[1] = "-A";
            System.arraycopy(cmd, 1, newcmd, 2, cmd.length - 1);
            cmd = newcmd;
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (redirStderr) {
            pb.redirectErrorStream(true);
        }
        if (this.inherit) {
            pb.inheritIO();
        }
        if (this.path != null) {
            pb.directory(this.path);
        }
        Map<String, String> env = pb.environment();
        if (cmd[0].equals("sudo")) {
            env.put("SUDO_ASKPASS", "/usr/bin/jfsudo-ask");
        }
        for (a = 0; a < this.envAdd.size(); ++a) {
            v = this.envAdd.get(a);
            env.put(v.name, v.value);
        }
        for (a = 0; a < this.envRemove.size(); ++a) {
            v = this.envRemove.get(a);
            env.remove(v.name);
        }
        this.command = "";
        for (a = 0; a < cmd.length; ++a) {
            this.command = this.command + cmd[a] + " ";
        }
        this.stdout = new StringBuffer();
        if (!redirStderr) {
            this.stderr = new StringBuffer();
        }
        this.active = true;
        if (log) {
            Object msg = "Exec :";
            for (int a2 = 0; a2 < cmd.length; ++a2) {
                msg = (String)msg + " ";
                msg = (String)msg + cmd[a2];
            }
            JFLog.log((String)msg);
        }
        try {
            this.p = pb.start();
            this.is = this.p.getInputStream();
            this.os = this.p.getOutputStream();
            this.es = this.p.getErrorStream();
            Worker wstdout = null;
            Thread wstderr = null;
            if (!this.inherit) {
                wstdout = new Worker(this, this.is, this.stdout, true);
                wstdout.start();
                if (!redirStderr) {
                    wstderr = new Worker(this, this.es, this.stderr, false);
                    wstderr.start();
                }
            }
            this.p.waitFor();
            this.active = false;
            if (wstdout != null) {
                wstdout.join();
            }
            if (wstderr != null) {
                wstderr.join();
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            this.errorLevel = -1;
            return null;
        }
        if (log) {
            JFLog.log("Exec:Complete");
        }
        this.errorLevel = this.p.exitValue();
        return this.stdout.toString();
    }

    public void destroy() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    public void destroyForcibly() {
        if (this.p != null) {
            this.p.destroyForcibly();
        }
    }

    private void _destroy() {
        this.destroy();
    }

    public String getStdout() {
        if (this.stdout == null) {
            return null;
        }
        return this.stdout.toString();
    }

    public String getStderr() {
        if (this.stderr == null) {
            return null;
        }
        return this.stderr.toString();
    }

    public Output getOutput() {
        Output output = new Output();
        if (this.stdout != null) {
            output.stdout = this.stdout.toString();
        }
        if (this.stderr != null) {
            output.stderr = this.stderr.toString();
        }
        output.errorLevel = this.errorLevel;
        return output;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public boolean isAlive() {
        if (this.p == null) {
            return false;
        }
        return this.p.isAlive();
    }

    public Process getProcess() {
        return this.p;
    }

    public static Output exec(String[] cmd, boolean redirStderr) {
        try {
            ShellProcess p = new ShellProcess();
            p.run(cmd, redirStderr);
            return p.getOutput();
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static Output exec(String[] cmd) {
        return ShellProcess.exec(cmd, false);
    }

    private static class Response {
        public String prompt;
        public String reply;
        public boolean repeat;
        public boolean used;
        public boolean regex;
        public boolean term;

        private Response() {
        }
    }

    private static class Variable {
        public String name;
        public String value;

        public Variable(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    private class Worker
    extends Thread {
        private InputStream wis;
        private boolean processScript;
        private StringBuffer output;
        final /* synthetic */ ShellProcess this$0;

        public Worker(ShellProcess shellProcess, InputStream wis, StringBuffer output, boolean processScript) {
            ShellProcess shellProcess2 = shellProcess;
            Objects.requireNonNull(shellProcess2);
            this.this$0 = shellProcess2;
            this.processScript = processScript;
            this.wis = wis;
            this.output = output;
        }

        @Override
        public void run() {
            byte[] buf = new byte[1024];
            int pidx = 0;
            try {
                int read;
                block4: while ((this.this$0.active || this.wis.available() > 0) && (read = this.wis.read(buf)) != -1) {
                    if (read == 0) continue;
                    String str = new String(buf, 0, read);
                    if (log) {
                        JFLog.log(str);
                    }
                    if (this.this$0.listener != null) {
                        try {
                            this.this$0.listener.shellProcessOutput(str);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.this$0.keepOutput || !this.processScript) continue;
                    this.output.append(str);
                    String prompt = this.output.substring(pidx).trim();
                    if (prompt.length() == 0) continue;
                    int in = prompt.lastIndexOf("\n");
                    int ir = prompt.lastIndexOf("\r");
                    if (in != -1 && in > ir) {
                        prompt = prompt.substring(in + 1).trim();
                    }
                    if (ir != -1 && ir > in) {
                        prompt = prompt.substring(ir + 1).trim();
                    }
                    if (logPrompt) {
                        JFLog.log("prompt=" + prompt);
                    }
                    for (int a = 0; a < this.this$0.script.size(); ++a) {
                        Response res = this.this$0.script.get(a);
                        if (res.used) continue;
                        boolean matches = false;
                        matches = res.regex ? prompt.matches(res.prompt) : prompt.equals(res.prompt);
                        if (!matches) continue;
                        pidx = this.output.length();
                        if (res.term) {
                            this.this$0._destroy();
                            return;
                        }
                        if (log) {
                            JFLog.log(res.reply);
                        }
                        this.this$0.os.write(res.reply.getBytes());
                        this.this$0.os.flush();
                        if (res.repeat) continue block4;
                        res.used = true;
                        continue block4;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (log) {
                JFLog.log("ShellProcess:Worker thread exiting");
            }
        }
    }

    public static class Output {
        public String stdout;
        public String stderr;
        public int errorLevel;
    }
}

