/*
 * Decompiled with CFR 0.152.
 */
package javaforce.access;

import java.io.File;
import java.util.ArrayList;
import javaforce.Compression;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.access.Group;
import javaforce.access.Groups;
import javaforce.access.User;
import javaforce.access.Users;

public class AccessControl {
    private String cfg_folder;
    private File users_file;
    private File groups_file;
    public Object lock = new Object();
    private Users users;
    private Groups groups;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConfigFolder(String folder) {
        this.cfg_folder = folder;
        this.users_file = new File(folder + "/users.dat");
        this.groups_file = new File(folder + "/groups.dat");
        boolean exists = true;
        Object object = this.lock;
        synchronized (object) {
            if (!this.loadUsers()) {
                exists = false;
            }
            if (!this.loadGroups()) {
                exists = false;
            }
        }
        return exists;
    }

    private boolean loadUsers() {
        if (this.users_file.exists()) {
            this.users = (Users)Compression.deserialize(this.users_file);
            return true;
        }
        this.users = new Users();
        this.users.addUser(new User("admin", "admin", "Built-in admin account"));
        this.saveUsers();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUsers() {
        Object object = this.lock;
        synchronized (object) {
            Compression.serialize(this.users_file, (Object)this.users);
        }
    }

    private boolean loadGroups() {
        if (this.groups_file.exists()) {
            this.groups = (Groups)Compression.deserialize(this.groups_file);
            return true;
        }
        this.groups = new Groups();
        this.groups.addGroup(new Group("administrators", "Built-in administrators group", new String[]{"admin"}));
        this.saveGroups();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGroups() {
        Object object = this.lock;
        synchronized (object) {
            Compression.serialize(this.groups_file, (Object)this.groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        Object object = this.lock;
        synchronized (object) {
            this.saveUsers();
            this.saveGroups();
        }
    }

    public String getConfigFolder() {
        return this.cfg_folder;
    }

    public String[] getGroups(String user) {
        if (this.cfg_folder == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Group group : this.groups.groups) {
            if (!group.contains(user)) continue;
            list.add(group.getName());
        }
        return list.toArray(JF.StringArrayType);
    }

    public Users getUsersList() {
        return this.users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User[] getUsers() {
        Object object = this.lock;
        synchronized (object) {
            return this.users.users.toArray(User.ARRAY_TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String name) {
        Object object = this.lock;
        synchronized (object) {
            for (User user : this.getUsers()) {
                if (!user.name.equals(name)) continue;
                return user;
            }
        }
        JFLog.log("AccessControl:user not found:" + name);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String name) {
        Object object = this.lock;
        synchronized (object) {
            for (Group group : this.getGroups()) {
                if (!group.name.equals(name)) continue;
                return group;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group[] getGroups() {
        Object object = this.lock;
        synchronized (object) {
            return this.groups.groups.toArray(Group.ARRAY_TYPE);
        }
    }

    public Groups getGroupsList() {
        return this.groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(User user) {
        Object object = this.lock;
        synchronized (object) {
            this.users.addUser(user);
            this.saveUsers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String user) {
        if (user.equals("admin")) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.users.removeUser(user);
            this.saveUsers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(String name, String desc) {
        Object object = this.lock;
        synchronized (object) {
            this.groups.addGroup(new Group(name, desc));
            this.saveGroups();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String name) {
        if (name.equals("administrators")) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.groups.removeGroup(name);
            this.saveGroups();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupMember(String name, String user) {
        Object object = this.lock;
        synchronized (object) {
            Group group = this.getGroup(name);
            if (group == null) {
                return;
            }
            group.addUser(user);
            this.saveGroups();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserPassword(String name, String pass) {
        Object object = this.lock;
        synchronized (object) {
            User user = this.getUser(name);
            if (user == null) {
                return;
            }
            user.setPassword(pass);
            this.saveUsers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUser(String name, String desc) {
        Object object = this.lock;
        synchronized (object) {
            User user = this.getUser(name);
            if (user == null) {
                return;
            }
            user.desc = desc;
            this.saveUsers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroup(String name, String desc) {
        Object object = this.lock;
        synchronized (object) {
            Group group = this.getGroup(name);
            if (group == null) {
                return;
            }
            group.desc = desc;
            this.saveGroups();
        }
    }

    public boolean login(String user, String pass) {
        if (this.cfg_folder == null) {
            JFLog.log("AccessControl.login:cfg_folder == null");
            return false;
        }
        User acct = this.getUser(user);
        if (acct == null) {
            return false;
        }
        return acct.checkPassword(pass);
    }
}

