/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Objects;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ansi.client.Buffer;
import javaforce.ansi.client.Line;
import javaforce.ansi.client.Profile;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;

public class BufferViewer
extends JComponent
implements KeyListener,
MouseListener,
MouseMotionListener,
Buffer.UI {
    public static boolean debug = false;
    public Buffer buffer;
    public Profile profile;
    private volatile boolean ready = false;
    private Object lock;
    private Render render;
    private final int RenderPriority = 9;
    private boolean init = false;
    private JScrollPane pane;
    private JFImage img = new JFImage();
    private HashMap<Integer, Color> clrmap = new HashMap();

    public BufferViewer(Profile profile) {
        this.buffer = new Buffer(profile, this);
        this.profile = profile;
        this.changeFont();
    }

    private void init() {
        JFLog.log("BufferViewer.init start");
        this.buffer.init();
        try {
            this.lock = new Object();
            this.setFocusable(true);
            this.setRequestFocusEnabled(true);
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.pane = (JScrollPane)this.getClientProperty("pane");
            this.pane.getVerticalScrollBar().setUnitIncrement(8);
            if (this.profile.autoSize) {
                Dimension d = this.pane.getViewport().getExtentSize();
                if (d.width < this.profile.fontWidth) {
                    d.width = this.profile.fontWidth;
                }
                if (d.height < this.profile.fontHeight) {
                    d.height = this.profile.fontHeight;
                }
                this.profile.sx = d.width / this.profile.fontWidth;
                this.profile.sy = d.height / this.profile.fontHeight;
            }
            this.init = true;
            if (this.profile.autoSize) {
                this.changeSize();
            } else {
                this.reSize();
            }
            this.setVisible(true);
            this.requestFocus();
            this.ready = true;
            this.render = new Render(this);
            this.render.setPriority(9);
            this.render.start();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        JFLog.log("BufferViewer.init done");
    }

    public byte[] char2byte(char[] buf, int buflen) {
        byte[] tmp = new byte[buflen];
        for (int a = 0; a < buflen; ++a) {
            tmp[a] = (byte)buf[a];
        }
        return tmp;
    }

    public char[] byte2char(byte[] buf, int buflen) {
        char[] tmp = new char[buflen];
        int a = 0;
        while (a < buflen) {
            tmp[a] = (char)buf[a];
            int n = a++;
            tmp[n] = (char)(tmp[n] & 0xFF);
        }
        return tmp;
    }

    public void changeSize() {
        if (this.pane == null) {
            return;
        }
        this.buffer.changeSize(this.pane.getViewport().getExtentSize());
        this.signalRepaint(true, true);
    }

    public void changeFont() {
        int[] metrics = JFAWT.getFontMetrics(this.profile.fnt);
        JFLog.log("metrics=" + metrics[0] + "," + metrics[1] + "," + metrics[2]);
        this.profile.fontWidth = metrics[0];
        this.profile.fontHeight = metrics[1] + metrics[2];
        this.profile.fontDescent = metrics[2];
    }

    private void setPreferredSize() {
        this.setPreferredSize(new Dimension(this.profile.fontWidth * this.buffer.sx, this.profile.fontHeight * (this.buffer.sy + this.buffer.scrollBack)));
    }

    public void reSize() {
        this.signalRepaint(true, true);
    }

    public void repaint(boolean showCursor) {
        if (showCursor) {
            this.scrollRectToVisible(new Rectangle(0, this.profile.fontHeight * this.buffer.scrollBack, this.profile.fontWidth * this.buffer.sx, this.profile.fontHeight * (this.buffer.scrollBack + this.buffer.sy)));
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        if (!this.ready) {
            if (!this.init) {
                this.init();
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.paintComponentLocked(g);
        }
    }

    private void paintComponentLocked(Graphics gc) {
        Rectangle r = gc.getClipBounds();
        Color fC = null;
        int fc = -1;
        int nfc = 0;
        Color bC = null;
        int bc = -1;
        int nbc = 0;
        if (this.img.getWidth() != r.width || this.img.getHeight() != r.height) {
            this.img.setImageSize(r.width, r.height);
        }
        this.img.fill(0, 0, r.width, r.height, this.profile.backColor);
        Graphics g = this.img.getGraphics();
        g.setFont(this.profile.fnt);
        int startx = r.x / this.profile.fontWidth;
        int offx = r.x % this.profile.fontWidth;
        int endx = (r.x + r.width) / this.profile.fontWidth + 1;
        if (endx > this.buffer.sx) {
            endx = this.buffer.sx;
        }
        int starty = r.y / this.profile.fontHeight;
        int offy = r.y % this.profile.fontHeight;
        int endy = (r.y + r.height) / this.profile.fontHeight + 1;
        if (endy > this.buffer.sy + this.buffer.scrollBack) {
            endy = this.buffer.sy + this.buffer.scrollBack;
        }
        boolean have_selection = this.buffer.have_selection();
        for (int y = starty; y < endy; ++y) {
            if (y >= this.buffer.lines.length) continue;
            Line line = this.buffer.lines[y];
            for (int x = startx; x < endx; ++x) {
                nbc = have_selection && (this.buffer.selectStartY == this.buffer.selectEndY && y == this.buffer.selectStartY && x >= this.buffer.selectStartX && x <= this.buffer.selectEndX || this.buffer.selectStartY != this.buffer.selectEndY && y == this.buffer.selectStartY && x >= this.buffer.selectStartX || this.buffer.selectStartY != this.buffer.selectEndY && y == this.buffer.selectEndY && x <= this.buffer.selectEndX || y > this.buffer.selectStartY && y < this.buffer.selectEndY) ? this.profile.selectColor : line.bcs[x];
                if (this.buffer.cursorShown && x == this.buffer.cx && y == this.buffer.cy + this.buffer.scrollBack) {
                    nbc ^= 0xFFFFFF;
                }
                if ((nbc &= 0xFFFFFF) != bc && (bC = this.clrmap.get(bc = nbc)) == null) {
                    bC = new Color(bc);
                    this.clrmap.put(bc, bC);
                }
                g.setColor(bC);
                g.fillRect((x - startx) * this.profile.fontWidth - offx, (y - starty) * this.profile.fontHeight - offy, this.profile.fontWidth, this.profile.fontHeight);
                char ch = line.chs[x];
                if (ch == '\u0000') continue;
                nfc = this.buffer.blinkerShown && line.blinks[x] ? line.bcs[x] : line.fcs[x];
                if ((nfc &= 0xFFFFFF) != fc && (fC = this.clrmap.get(fc = nfc)) == null) {
                    fC = new Color(fc);
                    this.clrmap.put(fc, fC);
                }
                g.setColor(fC);
                g.drawString(Character.toString(ch), (x - startx) * this.profile.fontWidth - offx, (y + 1 - starty) * this.profile.fontHeight - this.profile.fontDescent - offy);
            }
            if (y != this.buffer.scrollBack || this.buffer.scrollBack <= 0) continue;
            g.setColor(Color.RED);
            g.drawLine(0 - offx, (y - starty) * this.profile.fontHeight - 2 - offy, (endx - startx) * this.profile.fontWidth - 1 - offx, (y - starty) * this.profile.fontHeight - 2 - offy);
        }
        gc.drawImage(this.img.getImage(), r.x, r.y, null);
    }

    public void setAutoWrap(boolean state) {
        this.profile.autowrap = state;
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public void copy() {
        this.buffer.copy();
    }

    public void paste() {
        this.buffer.paste();
    }

    public void output(char[] buf) {
        this.buffer.output(buf);
    }

    public void changeScrollBack(int newSize) {
        this.buffer.changeScrollBack(newSize);
    }

    public void nextTab() {
        System.out.println("nextTab");
    }

    public void prevTab() {
        System.out.println("prevTab");
    }

    public void setTab(int idx) {
        System.out.println("setTab" + idx);
    }

    @Override
    public void setName(String str) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalRepaint(boolean findCursor, boolean revalidate) {
        if (revalidate) {
            this.setPreferredSize();
            this.revalidate();
        }
        if (this.render == null) {
            JFLog.log("Warning:render not ready");
            return;
        }
        Render render = this.render;
        synchronized (render) {
            this.render.findCursor = findCursor;
            this.render.draw = true;
            this.render.notify();
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void logFile() {
        if (this.buffer.fos == null) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showSaveDialog(this) == 0) {
                this.buffer.fos = JF.filecreate(chooser.getSelectedFile().getAbsolutePath());
                if (this.buffer.fos != null) {
                    this.setName(this.profile.name + "*");
                }
            }
        } else {
            this.buffer.fos = null;
            this.setName(this.profile.name);
        }
    }

    @Override
    public String toString() {
        return "BufferViewer";
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int keyMods = e.getModifiersEx() & JFAWT.KEY_MASKS;
        if (debug) {
            JFLog.log("BufferViewer.keyPressed=" + keyCode + ",mods=" + keyMods);
        }
        if (keyMods == 128) {
            switch (keyCode) {
                case 65: {
                    this.buffer.selectStartY = 0;
                    this.buffer.selectEndY = this.buffer.sy + this.buffer.scrollBack;
                    this.buffer.selectStartX = 0;
                    this.buffer.selectEndX = this.buffer.sx;
                    break;
                }
                case 87: {
                    this.close();
                    break;
                }
                case 67: 
                case 155: {
                    this.buffer.copy();
                    break;
                }
                case 86: {
                    this.buffer.paste();
                    break;
                }
                case 9: {
                    this.nextTab();
                    break;
                }
                case 35: 
                case 36: {
                    e.consume();
                }
            }
        }
        if (keyMods == 64) {
            switch (keyCode) {
                case 155: {
                    this.buffer.paste();
                }
            }
        }
        if (keyMods == 0) {
            switch (keyCode) {
                case 9: {
                    this.prevTab();
                }
            }
        }
        if (keyMods == 512) {
            switch (keyCode) {
                case 36: {
                    this.buffer.clrscr();
                    break;
                }
                case 49: {
                    this.setTab(0);
                    break;
                }
                case 50: {
                    this.setTab(1);
                    break;
                }
                case 51: {
                    this.setTab(2);
                    break;
                }
                case 52: {
                    this.setTab(3);
                    break;
                }
                case 53: {
                    this.setTab(4);
                    break;
                }
                case 54: {
                    this.setTab(5);
                    break;
                }
                case 55: {
                    this.setTab(6);
                    break;
                }
                case 56: {
                    this.setTab(7);
                    break;
                }
                case 57: {
                    this.setTab(8);
                    break;
                }
                case 48: {
                    this.setTab(9);
                }
            }
        }
        if (keyMods == 0) {
            switch (keyCode) {
                case 33: 
                case 34: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 121: {
                    e.consume();
                }
            }
        }
        if (!this.buffer.connected) {
            return;
        }
        this.buffer.ansi.keyPressed(keyCode, keyMods, this.buffer);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!this.buffer.connected) {
            if (this.buffer.failed) {
                this.buffer.failed = false;
                this.buffer.signalReconnect();
            }
            return;
        }
        char key = e.getKeyChar();
        int mods = e.getModifiersEx() & JFAWT.KEY_MASKS;
        if (debug) {
            JFLog.log("BufferViewer.keyTyped:key=" + key + ",mods=" + mods);
        }
        if (mods == 128) {
            if (key == '\n' || key == '\r') {
                this.buffer.output('\r');
            }
            return;
        }
        if (mods == 512) {
            return;
        }
        if (mods == 640) {
            return;
        }
        if (key == '\n') {
            key = '\r';
        }
        if (key == '\u007f') {
            return;
        }
        this.buffer.output(key);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 2) {
            this.buffer.paste();
        }
        if (e.getButton() == 1) {
            this.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int y;
        if (e.getButton() != 1) {
            return;
        }
        int x = e.getX() / this.profile.fontWidth;
        this.buffer.selectStartY = y = e.getY() / this.profile.fontHeight;
        this.buffer.selectStartX = x;
        this.buffer.selectEndY = -1;
        this.buffer.selectEndX = -1;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int y;
        if (e.getButton() != 1) {
            return;
        }
        if (this.buffer.selectStartY == -1) {
            return;
        }
        int x = e.getX() / this.profile.fontWidth;
        this.buffer.selectEndY = y = e.getY() / this.profile.fontHeight;
        this.buffer.selectEndX = x;
        this.signalRepaint(false, false);
        if (this.buffer.selectStartY != -1 && this.buffer.selectEndY != -1) {
            this.buffer.copy();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.buffer.selectStartY == -1) {
            return;
        }
        int x = e.getX() / this.profile.fontWidth;
        int y = e.getY() / this.profile.fontHeight;
        if (x < 0) {
            x = 0;
        }
        if (x >= this.buffer.sx) {
            x = this.buffer.sx - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= this.buffer.sy + this.buffer.scrollBack) {
            y = this.buffer.sy + this.buffer.scrollBack - 1;
        }
        if (y < this.buffer.selectStartY || y == this.buffer.selectStartY && x <= this.buffer.selectStartX) {
            if (this.buffer.selectEndY == -1) {
                this.buffer.selectEndY = this.buffer.selectStartY;
                this.buffer.selectEndX = this.buffer.selectStartX;
            }
            this.buffer.selectStartY = y;
            this.buffer.selectStartX = x;
        } else {
            this.buffer.selectEndY = y;
            this.buffer.selectEndX = x;
        }
        if (this.buffer.selectStartY > this.buffer.selectEndY || this.buffer.selectStartY == this.buffer.selectEndY && this.buffer.selectStartX > this.buffer.selectEndX) {
            this.buffer.swap_selection();
        }
        this.signalRepaint(false, false);
        this.scrollRectToVisible(new Rectangle(e.getX(), e.getY(), 1, 1));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private class Render
    extends Thread {
        public volatile boolean findCursor;
        public volatile boolean draw;
        final /* synthetic */ BufferViewer this$0;

        private Render(BufferViewer bufferViewer) {
            BufferViewer bufferViewer2 = bufferViewer;
            Objects.requireNonNull(bufferViewer2);
            this.this$0 = bufferViewer2;
            this.findCursor = true;
            this.draw = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.this$0.buffer.closed) {
                this.draw = false;
                this.this$0.repaint(this.findCursor);
                Render render = this;
                synchronized (render) {
                    if (this.draw) {
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            JFLog.log("Render thread done");
        }
    }
}

