/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class JFTextArea
extends JTextArea {
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static boolean isOvertypeMode;
    private Caret defaultCaret;
    private Caret overtypeCaret;
    private UndoManager undo;

    public void clearHistory() {
        this.undo.discardAllEdits();
    }

    private void init() {
        this.setCaretColor(Color.black);
        this.defaultCaret = this.getCaret();
        this.overtypeCaret = new OvertypeCaret(this);
        this.overtypeCaret.setBlinkRate(this.defaultCaret.getBlinkRate());
        this.setOvertypeMode(false);
        this.undo = new UndoManager();
        this.getDocument().addUndoableEditListener(new UndoableEditListener(this){
            final /* synthetic */ JFTextArea this$0;
            {
                JFTextArea jFTextArea = this$0;
                Objects.requireNonNull(jFTextArea);
                this.this$0 = jFTextArea;
            }

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                this.this$0.undo.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction(this, "Undo"){
            final /* synthetic */ JFTextArea this$0;
            {
                JFTextArea jFTextArea = this$0;
                Objects.requireNonNull(jFTextArea);
                this.this$0 = jFTextArea;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (this.this$0.undo.canUndo()) {
                        this.this$0.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction(this, "Redo"){
            final /* synthetic */ JFTextArea this$0;
            {
                JFTextArea jFTextArea = this$0;
                Objects.requireNonNull(jFTextArea);
                this.this$0 = jFTextArea;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (this.this$0.undo.canRedo()) {
                        this.this$0.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    public JFTextArea() {
        this.init();
    }

    public JFTextArea(int row, int column) {
        super(row, column);
        this.init();
    }

    public boolean isOvertypeMode() {
        return isOvertypeMode;
    }

    public void setOvertypeMode(boolean isOvertypeMode) {
        JFTextArea.isOvertypeMode = isOvertypeMode;
        int pos = this.getCaretPosition();
        if (this.isOvertypeMode()) {
            this.setCaret(this.overtypeCaret);
        } else {
            this.setCaret(this.defaultCaret);
        }
        this.setCaretPosition(pos);
    }

    @Override
    public void replaceSelection(String text) {
        if (this.isOvertypeMode()) {
            int pos = this.getCaretPosition();
            if (this.getSelectedText() == null && pos < this.getDocument().getLength()) {
                this.moveCaretPosition(pos + 1);
            }
        }
        super.replaceSelection(text);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (e.getID() == 402 && e.getKeyCode() == 155) {
            this.setOvertypeMode(!this.isOvertypeMode());
        }
    }

    private class OvertypeCaret
    extends DefaultCaret {
        final /* synthetic */ JFTextArea this$0;

        private OvertypeCaret(JFTextArea jFTextArea) {
            JFTextArea jFTextArea2 = jFTextArea;
            Objects.requireNonNull(jFTextArea2);
            this.this$0 = jFTextArea2;
        }

        @Override
        public void paint(Graphics g) {
            if (this.isVisible()) {
                try {
                    JTextComponent component = this.getComponent();
                    TextUI mapper = component.getUI();
                    Rectangle2D r = mapper.modelToView2D(component, this.getDot(), Position.Bias.Forward);
                    g.setColor(component.getCaretColor());
                    int width = g.getFontMetrics().charWidth('w');
                    int y = (int)(r.getY() + r.getHeight() - 2.0);
                    g.drawLine((int)r.getX(), y, (int)(r.getX() + (double)width - 2.0), y);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        protected synchronized void damage(Rectangle r) {
            if (r != null) {
                JTextComponent component = this.getComponent();
                this.x = r.x;
                this.y = r.y;
                this.width = component.getFontMetrics(component.getFont()).charWidth('w');
                this.height = r.height;
                this.repaint();
            }
        }
    }
}

