/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.Objects;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.KeyParams;
import javaforce.MQTT;
import javaforce.MQTTEvents;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MQTTViewer
extends JFrame
implements MQTTEvents {
    private JCheckBox authenticate;
    private JButton clear;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JTextArea msgs;
    private JTextField password;
    private JCheckBox secure;
    private JButton send;
    private JTextField send_msg;
    private JTextField send_topic;
    private JTextField server;
    private JButton start;
    private JButton subscribe;
    private JTextField topic;
    private JTextField username;
    private MQTT client;
    private KeyMgmt keys;
    private static String[] args;

    public MQTTViewer() {
        this.initComponents();
        this.initSecureWebKeys();
        this.setState(true);
        if (args.length > 0) {
            this.server.setText(args[0]);
            if (args.length > 1) {
                this.authenticate.setSelected(true);
                this.username.setText(args[1]);
                if (args.length > 2) {
                    this.password.setText(args[2]);
                    if (args.length > 3) {
                        block8: for (int a = 3; a < args.length; ++a) {
                            String value;
                            String key;
                            String arg = args[a];
                            int idx = arg.indexOf(61);
                            if (idx == -1) {
                                key = arg;
                                value = "";
                            } else {
                                key = arg.substring(0, idx);
                                value = arg.substring(idx + 1);
                            }
                            switch (key) {
                                case "-secure": {
                                    this.secure.setSelected(true);
                                    continue block8;
                                }
                                case "-topic": {
                                    this.topic.setText(value);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.server = new JTextField();
        this.jLabel2 = new JLabel();
        this.topic = new JTextField();
        this.start = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.msgs = new JTextArea();
        this.jLabel3 = new JLabel();
        this.authenticate = new JCheckBox();
        this.username = new JTextField();
        this.jLabel4 = new JLabel();
        this.password = new JTextField();
        this.clear = new JButton();
        this.secure = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.send_topic = new JTextField();
        this.jLabel6 = new JLabel();
        this.send_msg = new JTextField();
        this.send = new JButton();
        this.subscribe = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("MQTT Viewer");
        this.jLabel1.setText("Server");
        this.server.setText("127.0.0.1");
        this.server.setMinimumSize(new Dimension(200, 22));
        this.server.setPreferredSize(new Dimension(200, 22));
        this.jLabel2.setText("Topic");
        this.topic.setText("#");
        this.start.setText("Start");
        this.start.addActionListener(new ActionListener(this){
            final /* synthetic */ MQTTViewer this$0;
            {
                MQTTViewer mQTTViewer = this$0;
                Objects.requireNonNull(mQTTViewer);
                this.this$0 = mQTTViewer;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.startActionPerformed(evt);
            }
        });
        this.msgs.setColumns(20);
        this.msgs.setRows(5);
        this.jScrollPane1.setViewportView(this.msgs);
        this.jLabel3.setText("Username");
        this.authenticate.setText("Authenticate");
        this.username.setMinimumSize(new Dimension(100, 22));
        this.username.setPreferredSize(new Dimension(100, 22));
        this.jLabel4.setText("Password");
        this.password.setMinimumSize(new Dimension(100, 22));
        this.password.setPreferredSize(new Dimension(100, 22));
        this.clear.setText("Clear");
        this.clear.addActionListener(new ActionListener(this){
            final /* synthetic */ MQTTViewer this$0;
            {
                MQTTViewer mQTTViewer = this$0;
                Objects.requireNonNull(mQTTViewer);
                this.this$0 = mQTTViewer;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.clearActionPerformed(evt);
            }
        });
        this.secure.setText("Secure");
        this.jLabel5.setText("Topic");
        this.send_topic.setText("uns/topic");
        this.jLabel6.setText("Msg");
        this.send_msg.setText("{data}");
        this.send.setText("Send");
        this.send.addActionListener(new ActionListener(this){
            final /* synthetic */ MQTTViewer this$0;
            {
                MQTTViewer mQTTViewer = this$0;
                Objects.requireNonNull(mQTTViewer);
                this.this$0 = mQTTViewer;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.sendActionPerformed(evt);
            }
        });
        this.subscribe.setText("Subscribe");
        this.subscribe.addActionListener(new ActionListener(this){
            final /* synthetic */ MQTTViewer this$0;
            {
                MQTTViewer mQTTViewer = this$0;
                Objects.requireNonNull(mQTTViewer);
                this.this$0 = mQTTViewer;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.subscribeActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.topic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subscribe)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.server, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authenticate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.username, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.password, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secure).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.clear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.start)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.send_topic, -2, 303, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.send_msg).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.send))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.server, -2, -1, -2).addComponent(this.start).addComponent(this.jLabel3).addComponent(this.authenticate).addComponent(this.username, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.password, -2, -1, -2).addComponent(this.clear).addComponent(this.secure)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.topic, -2, -1, -2)).addComponent(this.subscribe, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 603, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.send_topic, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jLabel5).addComponent(this.send_msg, -2, -1, -2).addComponent(this.send)).addContainerGap()));
        this.pack();
    }

    private void startActionPerformed(ActionEvent evt) {
        this.start();
    }

    private void clearActionPerformed(ActionEvent evt) {
        this.clear();
    }

    private void sendActionPerformed(ActionEvent evt) {
        this.send();
    }

    private void subscribeActionPerformed(ActionEvent evt) {
        this.subscribe();
    }

    public static void main(String[] args) {
        MQTTViewer.args = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MQTTViewer().setVisible(true);
            }
        });
    }

    public void addText(String msg) {
        this.msgs.setText(this.msgs.getText() + msg);
    }

    @Override
    public void onConnect() {
        this.addText("connection accepted!\r\n");
    }

    @Override
    public void onSubscribe(String topic) {
        this.addText("subscribe accepted!\r\n");
    }

    @Override
    public void onMessage(String topic, String msg) {
        String ln = topic + "=" + msg + "\r\n";
        this.addText(ln);
    }

    public void start() {
        if (this.client == null) {
            this.start_new();
        } else {
            this.stop();
        }
    }

    public void start_new() {
        String _server = this.server.getText();
        boolean _secure = this.secure.isSelected();
        int port = -1;
        port = _secure ? 8883 : 1883;
        int idx = _server.indexOf(58);
        if (idx != -1) {
            String _port = _server.substring(idx + 1);
            _server = _server.substring(0, idx);
            port = JF.atoi(_port);
        }
        this.msgs.setText("Connecting to " + _server + ":" + port + "...");
        this.client = new MQTT();
        if (_secure) {
            if (!this.client.connect(_server, port, this.keys)) {
                this.msgs.setText("Connection failed!");
                this.client = null;
                return;
            }
        } else if (!this.client.connect(_server, port)) {
            this.msgs.setText("Connection failed!");
            this.client = null;
            return;
        }
        if (this.authenticate.isSelected()) {
            String _user = this.username.getText();
            String _pass = this.password.getText();
            this.client.connect(_user, _pass);
        } else {
            this.client.connect();
        }
        this.msgs.setText("Connected to " + _server + "\r\n");
        this.client.setListener(this);
        this.start.setText("Stop");
        this.setState(false);
    }

    public void stop() {
        if (this.client != null) {
            this.client.disconnect();
            this.client = null;
        }
        this.start.setText("Start");
        this.setState(true);
    }

    public void subscribe() {
        if (this.client == null) {
            return;
        }
        String _topic = this.topic.getText();
        this.client.subscribe(_topic);
        this.addText("Subscribed to : " + _topic + "\r\n");
    }

    private void setState(boolean state) {
        this.server.setEditable(state);
        this.authenticate.setEnabled(state);
        this.username.setEditable(state);
        this.password.setEditable(state);
        this.secure.setEnabled(state);
        this.topic.setEditable(!state);
        this.subscribe.setEnabled(!state);
        this.send.setEnabled(!state);
    }

    private void clear() {
        if (this.client == null) {
            this.msgs.setText("");
        } else {
            this.msgs.setText("Connected to " + this.server.getText() + "\r\n");
        }
    }

    private void send() {
        if (this.client == null) {
            return;
        }
        String topic = this.send_topic.getText();
        String msg = this.send_msg.getText();
        this.client.publish(topic, msg);
    }

    private void initSecureWebKeys() {
        String keyfile = JF.getUserPath() + "/jfmqtt.key";
        String password = "password";
        KeyParams params = new KeyParams();
        params.dname = "CN=jfmqtt.sourceforge.net, O=client, OU=mqtt, C=CA";
        if (new File(keyfile).exists()) {
            this.keys = new KeyMgmt();
            try {
                FileInputStream fis = new FileInputStream(keyfile);
                this.keys.open(fis, password);
                fis.close();
            }
            catch (Exception e) {
                if (!this.keys.isValid()) {
                    this.keys = KeyMgmt.create(keyfile, password, "webserver", params, password);
                }
                JFLog.log(e);
            }
        } else {
            this.keys = KeyMgmt.create(keyfile, password, "webserver", params, password);
        }
    }
}

