/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Objects;
import java.util.logging.Logger;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.JFTextArea;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;

public class SVGEditor
extends JFrame {
    private static final Logger logger = Logger.getLogger(SVGEditor.class.getName());
    private JLabel img;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JLabel msg;
    private JButton open;
    private JButton save;
    private JTextArea svg;
    private JTextField sx;
    private JTextField sy;
    private JButton update;
    private static String[] args;
    private File file;

    public SVGEditor() {
        this.initComponents();
        this.svg.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ SVGEditor this$0;
            {
                SVGEditor sVGEditor = this$0;
                Objects.requireNonNull(sVGEditor);
                this.this$0 = sVGEditor;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.keyPressedEvent(evt);
            }
        });
        this.processArgs();
        this.svg.requestFocus();
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.open = new JButton();
        this.save = new JButton();
        this.update = new JButton();
        this.jLabel1 = new JLabel();
        this.sx = new JTextField();
        this.jLabel2 = new JLabel();
        this.sy = new JTextField();
        this.msg = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.svg = new JFTextArea();
        this.img = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("SVG Editor");
        this.setPreferredSize(new Dimension(1280, 1024));
        this.open.setText("Open");
        this.open.setFocusable(false);
        this.open.setHorizontalTextPosition(0);
        this.open.setVerticalTextPosition(3);
        this.open.addActionListener(new ActionListener(this){
            final /* synthetic */ SVGEditor this$0;
            {
                SVGEditor sVGEditor = this$0;
                Objects.requireNonNull(sVGEditor);
                this.this$0 = sVGEditor;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.openActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.open);
        this.save.setText("Save");
        this.save.setToolTipText("Save and update image");
        this.save.setFocusable(false);
        this.save.setHorizontalTextPosition(0);
        this.save.setVerticalTextPosition(3);
        this.save.addActionListener(new ActionListener(this){
            final /* synthetic */ SVGEditor this$0;
            {
                SVGEditor sVGEditor = this$0;
                Objects.requireNonNull(sVGEditor);
                this.this$0 = sVGEditor;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.saveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.save);
        this.update.setText("Update");
        this.update.setFocusable(false);
        this.update.setHorizontalTextPosition(0);
        this.update.setVerticalTextPosition(3);
        this.update.addActionListener(new ActionListener(this){
            final /* synthetic */ SVGEditor this$0;
            {
                SVGEditor sVGEditor = this$0;
                Objects.requireNonNull(sVGEditor);
                this.this$0 = sVGEditor;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.updateActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.update);
        this.jLabel1.setText("Size:");
        this.jToolBar1.add(this.jLabel1);
        this.sx.setText("512");
        this.sx.setMaximumSize(new Dimension(100, Integer.MAX_VALUE));
        this.jToolBar1.add(this.sx);
        this.jLabel2.setText("x");
        this.jToolBar1.add(this.jLabel2);
        this.sy.setText("512");
        this.sy.setMaximumSize(new Dimension(100, Integer.MAX_VALUE));
        this.jToolBar1.add(this.sy);
        this.msg.setText("...");
        this.jToolBar1.add(this.msg);
        this.jSplitPane1.setDividerLocation(512);
        this.svg.setColumns(20);
        this.svg.setRows(5);
        this.jScrollPane1.setViewportView(this.svg);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.img.setText("[img]");
        this.jSplitPane1.setRightComponent(this.img);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1, -1, 956, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 830, Short.MAX_VALUE)));
        this.pack();
    }

    private void openActionPerformed(ActionEvent evt) {
        this.open();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void updateActionPerformed(ActionEvent evt) {
        this.update();
    }

    public static void main(String[] args) {
        SVGEditor.args = args;
        EventQueue.invokeLater(() -> new SVGEditor().setVisible(true));
    }

    public void processArgs() {
        try {
            for (String arg : args) {
                this.file = new File(arg);
                this.load();
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void open() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setCurrentDirectory(new File(JF.getCurrentPath()));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        this.file = chooser.getSelectedFile();
        this.clear();
        this.load();
    }

    public void clear() {
        this.svg.setText("");
    }

    public void load() {
        JFLog.log("loading:" + this.file.getAbsolutePath());
        try {
            FileInputStream fis = new FileInputStream(this.file);
            byte[] data = fis.readAllBytes();
            fis.close();
            this.svg.setText(new String(data));
            this.update();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void save() {
        if (this.file == null) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            byte[] data = this.svg.getText().getBytes();
            fos.write(data);
            fos.close();
            this.update();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void update() {
        try {
            this.msg.setText("");
            int x = Integer.valueOf(this.sx.getText());
            int y = Integer.valueOf(this.sy.getText());
            byte[] data = this.svg.getText().getBytes();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            JFImage.setDefaultColor(0xFFFFFF);
            JFImage tmp = new JFImage();
            tmp.loadSVG(bais, x, y);
            this.img.setText("");
            this.img.setIcon(tmp);
        }
        catch (Exception e) {
            JFLog.log(e);
            this.msg.setText("SVG corrupt");
        }
    }

    private void keyPressedEvent(KeyEvent evt) {
        int key = evt.getKeyCode();
        int mod = evt.getModifiersEx() & JFAWT.KEY_MASKS;
        switch (mod) {
            case 0: {
                switch (key) {
                    case 112: {
                        JOptionPane.showMessageDialog(this, "SVGEditor/" + JF.getVersion() + "\n\nF1 = Help\nF5 = Update\nCTRL-O = Open\nCTRL-S = Save\n", "Help", 1);
                        break;
                    }
                    case 116: {
                        this.update();
                    }
                }
                break;
            }
            case 64: {
                break;
            }
            case 128: {
                switch (key) {
                    case 83: {
                        this.save();
                        return;
                    }
                    case 79: {
                        this.open();
                        return;
                    }
                }
                break;
            }
        }
    }
}

