/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javaforce.awt.RFB;
import javaforce.awt.VNCJavaRobot;
import javaforce.awt.VNCRobot;
import javaforce.awt.VNCSessionServer;
import javaforce.awt.VNCWebServer;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javaforce.jni.WinNative;
import javaforce.utils.WinService;

public class VNCServer {
    public static final String busPack = "net.sf.jfvnc";
    private VNCWebServer web;
    private Server server;
    private ServerSocket ss;
    private VNCSessionServer session_server;
    private JBusClient busClient;
    private boolean active;
    private boolean service_mode;
    private static boolean debug = false;
    public static final boolean update_sid = false;
    private ArrayList<Client> clients = new ArrayList();
    private Object clientsLock = new Object();
    private boolean[] keys = new boolean[256];
    private static VNCServer service;
    private static Config config;
    private static JBusServer busServer;

    private boolean start() {
        return this.start(VNCServer.loadConfig(), true);
    }

    public boolean start(String pass) {
        Config config = new Config();
        config.password = pass;
        config.port = 5900;
        return this.start(config, false);
    }

    public boolean start(String pass, int port) {
        Config config = new Config();
        config.password = pass;
        config.port = port;
        return this.start(config, false);
    }

    private boolean start(Config config, boolean service_mode) {
        if (this.active) {
            this.stop();
        }
        VNCServer.config = config;
        config.validate();
        this.service_mode = service_mode;
        try {
            JFLog.log("VNCServer starting on port " + config.port + "...");
            this.active = true;
            this.ss = new ServerSocket(config.port);
            this.server = new Server(this);
            this.server.start();
            if (service_mode) {
                this.session_server = new VNCSessionServer();
                this.session_server.start();
            }
            if (config.web) {
                this.web = new VNCWebServer();
                this.web.start(VNCServer.getWebPort(), VNCServer.getWebSecurePort());
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public void stop() {
        this.active = false;
        try {
            if (this.ss != null) {
                this.ss.close();
                this.ss = null;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        if (this.session_server != null) {
            this.session_server.stop();
            this.session_server = null;
        }
        if (this.busClient != null) {
            this.busClient.close();
            this.busClient = null;
        }
        if (this.web != null) {
            this.web.stop();
            this.web = null;
        }
    }

    public void setViewOnlyPassword(String viewonly_password) {
        VNCServer.config.viewonly = viewonly_password;
    }

    private static Config loadConfig() {
        try {
            String delaystr;
            String websecureport;
            String webport;
            String web2;
            File file = new File(VNCServer.getConfigFile());
            FileInputStream fis = new FileInputStream(file);
            Properties props = new Properties();
            props.load(fis);
            fis.close();
            Config config = new Config();
            String password = props.getProperty("password");
            config.password = password != null ? password : VNCServer.randomPassword();
            String viewonly = props.getProperty("viewonly");
            config.viewonly = viewonly != null ? viewonly : VNCServer.randomPassword();
            String port = props.getProperty("port");
            if (port != null) {
                config.port = JF.atoi(port);
                if (config.port < 1 || config.port > 65535) {
                    config.port = 5900;
                }
            }
            if ((web2 = props.getProperty("web")) != null) {
                config.web = web2.equals("true");
            }
            if ((webport = props.getProperty("webport")) != null) {
                config.webport = JF.atoi(webport);
                if (config.webport < 1 || config.webport > 65535) {
                    config.webport = 5800;
                }
            }
            if ((websecureport = props.getProperty("websecureport")) != null) {
                config.websecureport = JF.atoi(websecureport);
                if (config.websecureport < 1 || config.websecureport > 65535) {
                    config.websecureport = 5843;
                }
            }
            if ((delaystr = props.getProperty("delay")) != null) {
                config.delay = JF.atoi(delaystr);
            }
            if (JF.isUnix()) {
                String display;
                String user = props.getProperty("user");
                if (user != null) {
                    config.user = user;
                }
                if ((display = props.getProperty("display")) != null) {
                    config.display = display;
                }
            }
            config.validate();
            return config;
        }
        catch (FileNotFoundException e) {
            Config config = new Config();
            config.password = VNCServer.randomPassword();
            config.viewonly = VNCServer.randomPassword();
            try {
                FileOutputStream fos = new FileOutputStream(VNCServer.getConfigFile());
                fos.write(config.toString().getBytes());
                fos.close();
            }
            catch (Exception e2) {
                JFLog.log(e2);
            }
            return config;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private static int getWebPort() {
        if (config == null) {
            return 5800;
        }
        return VNCServer.config.webport;
    }

    private static int getWebSecurePort() {
        if (config == null) {
            return 5843;
        }
        return VNCServer.config.websecureport;
    }

    private static String randomPassword() {
        byte[] cs = new byte[8];
        Random r = new Random();
        for (int a = 0; a < 8; ++a) {
            cs[a] = (byte)(r.nextInt(26) + 97);
        }
        return new String(cs);
    }

    private VNCRobot newSession() {
        if (debug) {
            JFLog.log("Starting new Session");
        }
        long token = -1L;
        if (JF.isWindows()) {
            if (debug) {
                JFLog.log("Session ID=" + WinNative.getSessionID());
            }
            token = WinNative.executeSession(System.getProperty("java.app.home") + "/jfvncsession.exe", new String[0]);
        } else {
            try {
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                pb.environment().put("DISPLAY", VNCServer.config.display);
                pb.environment().put("XAUTHORITY", "/home/" + this.getLinuxUser() + "/.Xauthority");
                pb.command(System.getProperty("java.app.home") + "/jfvncsession");
                pb.start();
            }
            catch (Exception e) {
                JFLog.log(e);
                return null;
            }
        }
        VNCSessionServer.Client robot = this.session_server.getClient();
        if (JF.isWindows()) {
            robot.token = token;
            robot.sid = -1;
            while (robot.sid == -1) {
                robot.sid = WinNative.getSessionID();
                JF.sleep(100);
            }
        }
        if (debug) {
            JFLog.log("robot=" + String.valueOf(robot));
        }
        return robot;
    }

    private String getLinuxUser() {
        if (VNCServer.config.user != null) {
            return VNCServer.config.user;
        }
        File[] users = new File("/home").listFiles();
        if (users == null || users.length == 0) {
            return "null";
        }
        return users[0].getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClient(Client client) {
        Object object = this.clientsLock;
        synchronized (object) {
            this.clients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(Client client) {
        Object object = this.clientsLock;
        synchronized (object) {
            this.clients.remove(client);
        }
    }

    private int getClientCount() {
        return this.clients.size();
    }

    public static void serviceStart(String[] args) {
        JFLog.init(VNCServer.getLogFile(), true);
        service = new VNCServer();
        service.start();
        if (JF.isWindows()) {
            busServer = new JBusServer(VNCServer.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
    }

    public static void serviceStop() {
        service.stop();
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33015;
        }
        return 777;
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfvnc.log";
    }

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfvnc.cfg";
    }

    private static String getServiceFile() {
        return System.getProperty("user.dir") + "\\jfvncsvc.exe";
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            String usage = "";
            usage = JF.isWindows() ? "Usage:\nVNCServer {password} [port]\nVNCServer -install | -remove | -start | -stop" : "Usage:\nVNCServer {password} [port]";
            JFAWT.showError("Usage", usage);
            System.exit(1);
        }
        if (args[0].startsWith("-")) {
            String exe;
            if (!JF.isWindows()) {
                JFAWT.showError("Error", "Not supported");
                System.exit(1);
            }
            if (!new File(exe = VNCServer.getServiceFile()).exists()) {
                JFAWT.showError("Error", "Unable to find jfvncsvc.exe");
                System.exit(1);
            }
            switch (args[0]) {
                case "-install": {
                    WinService.create("jfVNCServer", exe);
                    break;
                }
                case "-remove": {
                    WinService.delete("jfVNCServer");
                    break;
                }
                case "-start": {
                    WinService.start("jfVNCServer");
                    break;
                }
                case "-stop": {
                    WinService.stop("jfVNCServer");
                    break;
                }
                default: {
                    JFAWT.showError("Error", "Unknown option:" + args[0]);
                    System.exit(1);
                    break;
                }
            }
        } else {
            JFLog.init("jfvnccli.log", true);
            String password = args[0];
            int port = 5900;
            if (args.length > 1 && ((port = JF.atoi(args[1])) < 0 || port > 65535)) {
                port = 5900;
            }
            VNCServer server = new VNCServer();
            server.start(password, port);
        }
    }

    public String getStatus() {
        StringBuilder msg = new StringBuilder();
        try {
            msg.append("Service active on port:" + VNCServer.config.port + "\n");
            msg.append("Clients active:" + this.getClientCount() + "\n");
        }
        catch (Exception e) {
            msg.append("Exception:" + String.valueOf(e));
        }
        return msg.toString();
    }

    private static class Config {
        public String password;
        public String viewonly;
        public int port = 5900;
        public boolean web = true;
        public int webport = 5800;
        public int websecureport = 5843;
        public int delay = 100;
        public String user;
        public String display = ":0";
        private static final int min_delay = 100;
        private static final int max_delay = 5000;

        private Config() {
        }

        public void validate() {
            this.password = RFB.checkPassword(this.password);
            if (this.viewonly != null) {
                this.viewonly = RFB.checkPassword(this.viewonly);
            }
            if (this.delay < 100) {
                this.delay = 100;
            }
            if (this.delay > 5000) {
                this.delay = 5000;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("port=" + this.port + "\n");
            sb.append("web=" + this.web + "\n");
            sb.append("webport=" + this.webport + "\n");
            sb.append("websecureport=" + this.websecureport + "\n");
            sb.append("password=" + this.password + "\n");
            sb.append("delay=" + this.delay + "\n");
            if (this.viewonly != null) {
                sb.append("viewonly=" + this.viewonly + "\n");
            } else {
                sb.append("#viewonly=password\n");
            }
            if (this.user != null) {
                sb.append("user=" + this.user + "\n");
            } else {
                sb.append("#user=username  #linux account with X11 authorization\n");
            }
            sb.append("display=" + this.display + "  #linux display name\n");
            return sb.toString();
        }
    }

    private class Server
    extends Thread {
        final /* synthetic */ VNCServer this$0;

        private Server(VNCServer vNCServer) {
            VNCServer vNCServer2 = vNCServer;
            Objects.requireNonNull(vNCServer2);
            this.this$0 = vNCServer2;
        }

        @Override
        public void run() {
            this.this$0.busClient = new JBusClient(VNCServer.busPack, new JBusMethods());
            this.this$0.busClient.setPort(VNCServer.getBusPort());
            this.this$0.busClient.start();
            while (this.this$0.active) {
                try {
                    VNCRobot robot;
                    Socket s = this.this$0.ss.accept();
                    if (this.this$0.service_mode) {
                        robot = this.this$0.newSession();
                    } else {
                        GraphicsEnvironment gfx = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        robot = new VNCJavaRobot(gfx.getDefaultScreenDevice());
                    }
                    if (robot == null) {
                        s.close();
                        continue;
                    }
                    Client client = new Client(this.this$0, s, robot);
                    this.this$0.addClient(client);
                    client.start();
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            byte[] cfg = JF.readFile(VNCServer.getConfigFile());
            if (cfg == null) {
                cfg = new byte[]{};
            }
            String config = new String(cfg);
            VNCServer.service.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(config)));
        }

        public void setConfig(String cfg) {
            try {
                FileOutputStream fos = new FileOutputStream(VNCServer.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            service.stop();
            service = new VNCServer();
            service.start();
        }

        public void getStatus(String pack) {
            String status = null;
            status = service != null ? service.getStatus() : "Service not running!";
            VNCServer.service.busClient.call(pack, "getStatus", JBusClient.quote(JBusClient.encodeString(status)));
        }
    }

    private class Client
    extends Thread {
        private Socket s;
        private RFB rfb;
        private Object lock;
        private VNCRobot robot;
        private Rectangle size;
        private Updater updater;
        private boolean connected;
        private boolean control;
        private int buttons;
        private int pf;
        final /* synthetic */ VNCServer this$0;

        public Client(VNCServer vNCServer, Socket s, VNCRobot robot) {
            VNCServer vNCServer2 = vNCServer;
            Objects.requireNonNull(vNCServer2);
            this.this$0 = vNCServer2;
            this.lock = new Object();
            this.pf = RFB.PF_LE_RGB;
            this.s = s;
            this.robot = robot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.connected = true;
            try {
                byte[] reply;
                this.rfb = new RFB();
                this.rfb.connect(this.s);
                this.rfb.writeVersion(RFB.VERSION_3_8);
                float ver = this.rfb.readVersion();
                this.rfb.writeAuthTypes();
                byte type = this.rfb.readAuthType();
                if (type != 2) {
                    throw new Exception("Auth failed");
                }
                byte[] challenge = this.rfb.writeAuthChallenge();
                byte[] password_encoded = RFB.encodeResponse(challenge, VNCServer.config.password.getBytes());
                byte[] viewonly_encoded = null;
                if (viewonly_encoded != null) {
                    viewonly_encoded = RFB.encodeResponse(challenge, VNCServer.config.viewonly.getBytes());
                }
                if (Arrays.equals(password_encoded, reply = this.rfb.readAuthChallenge())) {
                    this.rfb.writeAuthResult(true);
                    this.control = true;
                } else if (viewonly_encoded != null && Arrays.equals(viewonly_encoded, reply)) {
                    this.rfb.writeAuthResult(true);
                    this.control = false;
                } else {
                    this.rfb.writeAuthResult(false);
                    throw new Exception("Auth Failed");
                }
                this.size = this.robot.getScreenSize();
                this.rfb.writeServerInit(this.size.width, this.size.height);
                this.rfb.readClientInit();
                this.updater = new Updater(this);
                this.updater.start();
                block26: while (this.this$0.active && this.connected) {
                    this.connected = this.rfb.isConnected();
                    int cmd = this.rfb.readMessageType();
                    Object object = this.lock;
                    synchronized (object) {
                        if (!this.robot.active()) {
                            this.robot.close();
                            this.robot = this.this$0.newSession();
                        }
                    }
                    switch (cmd) {
                        case 3: {
                            RFB.Rectangle rect = this.rfb.readBufferUpdateRequest();
                            this.updater.refresh(rect);
                            break;
                        }
                        case 5: {
                            Object event = this.rfb.readMouseEvent();
                            if (!this.control) break;
                            try {
                                Object object2 = this.lock;
                                synchronized (object2) {
                                    this.robot.mouseMove(((RFB.RFBMouseEvent)event).x, ((RFB.RFBMouseEvent)event).y);
                                    int mask = 1;
                                    for (int a = 0; a < 3; mask <<= 1, ++a) {
                                        if ((this.buttons & mask) == (((RFB.RFBMouseEvent)event).buttons & mask)) continue;
                                        if ((((RFB.RFBMouseEvent)event).buttons & mask) == 0) {
                                            this.robot.mouseRelease(VNCRobot.convertMouseButtons(mask));
                                            continue;
                                        }
                                        this.robot.mousePress(VNCRobot.convertMouseButtons(mask));
                                    }
                                }
                            }
                            catch (Exception e) {
                                JFLog.log(e);
                            }
                            this.buttons = ((RFB.RFBMouseEvent)event).buttons;
                            break;
                        }
                        case 4: {
                            Object event = this.rfb.readKeyEvent();
                            if (!this.control) break;
                            if (debug) {
                                JFLog.log("KeyEvent:" + (((RFB.RFBKeyEvent)event).down ? "down" : "up"));
                                JFLog.log("old.key=0x" + Integer.toString(((RFB.RFBKeyEvent)event).code, 16));
                            }
                            int code = VNCRobot.convertRFBKeyCode(((RFB.RFBKeyEvent)event).code);
                            if (debug) {
                                JFLog.log("new.key=0x" + Integer.toString(code, 16));
                            }
                            try {
                                if (((RFB.RFBKeyEvent)event).down) {
                                    if (JF.isWindows()) {
                                        if (code > 0 && code < 256) {
                                            this.this$0.keys[code] = true;
                                        }
                                        boolean shift = this.this$0.keys[16];
                                        boolean ctrl = this.this$0.keys[17];
                                        boolean alt = this.this$0.keys[18];
                                        if (debug) {
                                            JFLog.log("shift=" + shift + ",ctrl=" + ctrl + ",alt=" + alt);
                                        }
                                        if (code == 127 && !shift && ctrl && alt) {
                                            if (debug) {
                                                JFLog.log("Simulating Ctrl+Alt+Del");
                                            }
                                            WinNative.simulateCtrlAltDel();
                                        }
                                    }
                                    if (code == -1) continue block26;
                                    Object shift = this.lock;
                                    synchronized (shift) {
                                        this.robot.keyPress(code);
                                        break;
                                    }
                                }
                                if (JF.isWindows() && code > 0 && code < 256) {
                                    this.this$0.keys[code] = false;
                                }
                                if (code == -1) continue block26;
                                Object shift = this.lock;
                                synchronized (shift) {
                                    this.robot.keyRelease(code);
                                }
                            }
                            catch (Exception e) {
                                JFLog.log(e);
                            }
                            continue block26;
                        }
                        case 2: {
                            int[] encodings = this.rfb.readEncodings();
                            if (encodings != null) break;
                            throw new Exception("invalid encodings");
                        }
                        case 0: {
                            RFB.PixelFormat rfb_pf = this.rfb.readPixelFormat();
                            this.pf = rfb_pf.getFormat();
                            break;
                        }
                        case 6: {
                            String text = this.rfb.readCutText();
                            if (this.control) break;
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                this.close();
            }
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.robot.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.this$0.removeClient(this);
        }

        public void close() {
            this.connected = false;
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private class Updater
        extends Thread {
            private boolean updater_active;
            private int[] img;
            private boolean refresh;
            private int sid;
            private static final int INF = 65536;
            final /* synthetic */ Client this$1;

            private Updater(Client client) {
                Client client2 = client;
                Objects.requireNonNull(client2);
                this.this$1 = client2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.updater_active = true;
                this.refresh = true;
                try {
                    if (JF.isWindows()) {
                        this.sid = -1;
                        while (this.sid == -1) {
                            this.sid = WinNative.getSessionID();
                            JF.sleep(100);
                        }
                    }
                    while (this.updater_active && this.this$1.connected) {
                        Object object;
                        int newsid;
                        if (!this.this$1.rfb.haveEncodings()) {
                            JF.sleep(100);
                            continue;
                        }
                        if (JF.isWindows() && this.this$1.this$0.service_mode && (newsid = WinNative.getSessionID()) != -1 && newsid != this.sid) {
                            if (debug) {
                                JFLog.log("Session ID change detected, creating a new session.");
                            }
                            object = this.this$1.lock;
                            synchronized (object) {
                                this.this$1.robot.close();
                                this.this$1.robot = null;
                                this.this$1.robot = this.this$1.this$0.newSession();
                            }
                            this.sid = newsid;
                        }
                        Rectangle new_size = null;
                        object = this.this$1.lock;
                        synchronized (object) {
                            new_size = this.this$1.robot.getScreenSize();
                        }
                        if (new_size.width != this.this$1.size.width || new_size.height != this.this$1.size.height) {
                            this.this$1.size = new_size;
                            this.this$1.rfb.writeBufferUpdate(new RFB.Rectangle(new_size), -223);
                        }
                        if (this.refresh) {
                            object = this.this$1.lock;
                            synchronized (object) {
                                this.img = this.this$1.robot.getScreenCapture(this.this$1.pf);
                            }
                            this.this$1.rfb.setBuffer(this.img);
                            RFB.Rectangle rect = new RFB.Rectangle();
                            rect.width = this.this$1.size.width;
                            rect.height = this.this$1.size.height;
                            this.this$1.rfb.writeBufferUpdate(rect, -1);
                            this.refresh = false;
                        } else {
                            int[] update;
                            Object object2 = this.this$1.lock;
                            synchronized (object2) {
                                update = this.this$1.robot.getScreenCapture(this.this$1.pf);
                            }
                            boolean changed = false;
                            int x1 = 65536;
                            int x2 = -1;
                            int y1 = 65536;
                            int y2 = -1;
                            int x = 0;
                            int width = this.this$1.size.width;
                            int y = 0;
                            int height = this.this$1.size.height;
                            int idx = 0;
                            int[] ipx = this.img;
                            int[] upx = update;
                            for (y = 0; y < height; ++y) {
                                for (x = 0; x < width; ++x) {
                                    if (ipx[idx] != upx[idx]) {
                                        if (x1 > x) {
                                            x1 = x;
                                        }
                                        if (x2 < x) {
                                            x2 = x;
                                        }
                                        if (y1 > y) {
                                            y1 = y;
                                        }
                                        if (y2 < y) {
                                            y2 = y;
                                        }
                                        changed = true;
                                        ipx[idx] = upx[idx];
                                    }
                                    ++idx;
                                }
                            }
                            if (changed) {
                                this.this$1.rfb.setBuffer(update);
                                RFB.Rectangle rect = new RFB.Rectangle();
                                rect.x = x1;
                                rect.y = y1;
                                rect.width = x2 - x1 + 1;
                                rect.height = y2 - y1 + 1;
                                this.this$1.rfb.writeBufferUpdate(rect, -1);
                            }
                        }
                        JF.sleep(VNCServer.config.delay);
                    }
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }

            public void cancel() {
                this.updater_active = false;
                JF.sleep(250);
            }

            public void refresh(RFB.Rectangle rect) {
                this.refresh = true;
            }
        }
    }
}

