/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Objects;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.VNCRobot;
import javaforce.jni.WinNative;

public class VNCSessionServer {
    public static final int port = 5999;
    private Server server;
    private Object lock = new Object();
    private Client client;

    public void start() {
        this.server = new Server(this);
        this.server.start();
    }

    public void stop() {
        if (this.server != null) {
            this.server.cancel();
            this.server = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClient() {
        Object object = this.lock;
        synchronized (object) {
            int count = 60;
            while (this.client == null) {
                try {
                    this.lock.wait(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (--count != 0) continue;
                JFLog.log("VNCSessionServer:Error:Unable to acquire Client (VNCSessionClient did not start).");
                return null;
            }
            Client ret = this.client;
            this.client = null;
            return ret;
        }
    }

    public class Server
    extends Thread {
        private ServerSocket ss;
        private boolean active;
        final /* synthetic */ VNCSessionServer this$0;

        public Server(VNCSessionServer this$0) {
            VNCSessionServer vNCSessionServer = this$0;
            Objects.requireNonNull(vNCSessionServer);
            this.this$0 = vNCSessionServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.active = true;
            try {
                this.ss = new ServerSocket(5999, 0, Inet4Address.getLoopbackAddress());
            }
            catch (Exception e) {
                JFLog.log(e);
                return;
            }
            while (this.active) {
                try {
                    Socket s = this.ss.accept();
                    Object object = this.this$0.lock;
                    synchronized (object) {
                        this.this$0.client = new Client(s);
                        this.this$0.lock.notify();
                    }
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }

        public void cancel() {
            this.active = false;
            try {
                if (this.ss != null) {
                    this.ss.close();
                    this.ss = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class Client
    implements VNCRobot {
        private Socket s;
        private InputStream is;
        private OutputStream os;
        private DataInputStream dis;
        private DataOutputStream dos;
        private boolean connected;
        public long token;
        public int sid;

        public Client(Socket s) {
            this.s = s;
            this.connected = true;
            try {
                this.is = s.getInputStream();
                this.os = s.getOutputStream();
            }
            catch (Exception e) {
                JFLog.log(e);
                this.connected = false;
            }
            this.dis = new DataInputStream(this.is);
            this.dos = new DataOutputStream(this.os);
        }

        @Override
        public Rectangle getScreenSize() {
            try {
                if (JF.isWindows()) {
                    // empty if block
                }
                this.os.write(1);
                int width = this.dis.readInt();
                int height = this.dis.readInt();
                return new Rectangle(0, 0, width, height);
            }
            catch (Exception e) {
                JFLog.log(e);
                this.connected = false;
                return null;
            }
        }

        @Override
        public int[] getScreenCapture(int pf) {
            try {
                this.os.write(2);
                this.os.write(pf);
                int width = this.dis.readInt();
                int height = this.dis.readInt();
                int pixels = width * height;
                int bytes = pixels * 4;
                byte[] px8 = this.dis.readNBytes(bytes);
                int[] px32 = new int[pixels];
                int i8 = 0;
                for (int i = 0; i < pixels; ++i) {
                    px32[i] = BE.getuint32(px8, i8);
                    i8 += 4;
                }
                return px32;
            }
            catch (Exception e) {
                JFLog.log(e);
                this.connected = false;
                return null;
            }
        }

        @Override
        public void keyPress(int code) {
            try {
                this.os.write(3);
                this.dos.writeInt(code);
            }
            catch (Exception e) {
                JFLog.log(e);
                this.connected = false;
            }
        }

        @Override
        public void keyRelease(int code) {
            try {
                this.os.write(4);
                this.dos.writeInt(code);
            }
            catch (Exception e) {
                JFLog.log(e);
                this.connected = false;
            }
        }

        @Override
        public void mouseMove(int x, int y) {
            try {
                this.os.write(5);
                this.dos.writeInt(x);
                this.dos.writeInt(y);
            }
            catch (Exception e) {
                JFLog.log(e);
                this.connected = false;
            }
        }

        @Override
        public void mousePress(int button) {
            try {
                this.os.write(6);
                this.dos.writeInt(button);
            }
            catch (Exception e) {
                JFLog.log(e);
                this.connected = false;
            }
        }

        @Override
        public void mouseRelease(int button) {
            try {
                this.os.write(7);
                this.dos.writeInt(button);
            }
            catch (Exception e) {
                JFLog.log(e);
                this.connected = false;
            }
        }

        @Override
        public boolean active() {
            return this.connected;
        }

        @Override
        public void close() {
            try {
                if (this.connected) {
                    this.os.write(99);
                    this.os.flush();
                    this.s.close();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            this.connected = false;
            if (JF.isWindows()) {
                if (this.token != 0L) {
                    WinNative.closeSession(this.token);
                }
                this.token = 0L;
            }
        }

        public String toString() {
            return "VNCSessionServer.Client:s=" + String.valueOf(this.s);
        }
    }
}

