/*
 * Decompiled with CFR 0.152.
 */
package javaforce.cl;

import java.io.File;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LE;
import javaforce.api.CLAPI;
import javaforce.ffm.CLFFM;
import javaforce.ffm.FFM;
import javaforce.jni.CLJNI;
import javaforce.jni.JFNative;
import javaforce.jni.Library;
import javaforce.jni.LnxNative;

public class CL {
    public static final int TYPE_DEFAULT = 1;
    public static final int TYPE_CPU = 2;
    public static final int TYPE_GPU = 4;
    public static final int TYPE_ACCELERATOR = 8;
    private CLAPI api;
    private static CL instance;
    public static final int MEM_READ_WRITE = 1;
    public static final int MEM_WRITE = 2;
    public static final int MEM_READ = 4;

    public static CL getInstance() {
        if (instance == null) {
            instance = new CL();
            CL.instance.api = FFM.enabled() ? CLFFM.getInstance() : CLJNI.getInstance();
            if (!instance.init()) {
                return null;
            }
        }
        return instance;
    }

    private boolean init() {
        File[] sysFolders;
        String ext = "";
        String apphome = System.getProperty("java.app.home");
        String name = "OpenCL";
        if (apphome == null) {
            apphome = ".";
        }
        if (JF.isWindows()) {
            sysFolders = new File[]{new File(System.getenv("windir") + "\\system32"), new File(apphome), new File(".")};
            ext = ".dll";
            name = name.toLowerCase();
        } else if (JF.isMac()) {
            sysFolders = new File[]{new File("/System/Library/Frameworks/OpenCL.framework/Versions/Current/Libraries"), new File(apphome), new File(".")};
            ext = ".dylib";
        } else {
            sysFolders = new File[]{new File("/usr/lib"), new File(LnxNative.getArchLibFolder())};
            ext = ".so";
        }
        Library[] libs = new Library[]{new Library(name)};
        JFNative.findLibraries(sysFolders, libs, ext);
        if (libs[0].path == null) {
            JFLog.log("Error:Unable to find OpenCL library");
            return false;
        }
        return this.api.clLoadLibrary(libs[0].path);
    }

    public long create(String src, int type) {
        return this.api.clCreate(src, type);
    }

    public long create(String src) {
        return this.create(src, 1);
    }

    public long kernel(long ctx, String func) {
        return this.api.clKernel(ctx, func);
    }

    public long createBuffer(long ctx, int size, int type) {
        return this.api.clCreateBuffer(ctx, size, type);
    }

    public long createReadBuffer(long ctx, int size) {
        return this.createBuffer(ctx, size, 4);
    }

    public long createWriteBuffer(long ctx, int size) {
        return this.createBuffer(ctx, size, 2);
    }

    public long createReadWriteBuffer(long ctx, int size) {
        return this.createBuffer(ctx, size, 1);
    }

    public boolean setArg(long ctx, long kernel, int idx, byte[] value) {
        return this.api.clSetArg(ctx, kernel, idx, value, value.length);
    }

    public boolean setArg(long ctx, long kernel, int idx, int value) {
        byte[] tmp = new byte[4];
        LE.setuint32(tmp, 0, value);
        return this.setArg(ctx, kernel, idx, tmp);
    }

    public boolean setArg(long ctx, long kernel, int idx, long value) {
        byte[] tmp = new byte[8];
        LE.setuint64(tmp, 0, value);
        return this.setArg(ctx, kernel, idx, tmp);
    }

    public boolean writeBufferi8(long ctx, long buffer, byte[] value) {
        return this.api.clWriteBufferi8(ctx, buffer, value, value.length);
    }

    public boolean writeBufferf32(long ctx, long buffer, float[] value) {
        return this.api.clWriteBufferf32(ctx, buffer, value, value.length);
    }

    public boolean writeBuffer(long ctx, long buffer, byte[] data) {
        return this.writeBufferi8(ctx, buffer, data);
    }

    public boolean writeBuffer(long ctx, long buffer, float[] data) {
        return this.writeBufferf32(ctx, buffer, data);
    }

    public boolean execute(long ctx, long kernel, int count) {
        return this.api.clExecute(ctx, kernel, count);
    }

    public boolean execute2(long ctx, long kernel, int count1, int count2) {
        return this.api.clExecute2(ctx, kernel, count1, count2);
    }

    public boolean execute3(long ctx, long kernel, int count1, int count2, int count3) {
        return this.api.clExecute3(ctx, kernel, count1, count2, count3);
    }

    public boolean execute4(long ctx, long kernel, int count1, int count2, int count3, int count4) {
        return this.api.clExecute4(ctx, kernel, count1, count2, count3, count4);
    }

    public boolean readBuffer(long ctx, long buffer, byte[] data) {
        return this.api.clReadBufferi8(ctx, buffer, data, data.length);
    }

    public boolean readBuffer(long ctx, long buffer, float[] data) {
        return this.api.clReadBufferf32(ctx, buffer, data, data.length);
    }

    public boolean freeKernel(long ctx, long kernel) {
        return this.api.clFreeKernel(ctx, kernel);
    }

    public boolean freeBuffer(long ctx, long buffer) {
        return this.api.clFreeBuffer(ctx, buffer);
    }

    public boolean close(long ctx) {
        return this.api.clClose(ctx);
    }
}

