/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javaforce.JFLog;
import javaforce.LE;
import javaforce.SOCKS;
import javaforce.controls.ab.ABContext;
import javaforce.controls.ab.ABPacket;
import javaforce.controls.ab.ENIP;
import javaforce.controls.jfc.JFPacket;
import javaforce.controls.jfc.JFTag;
import javaforce.controls.mod.ModAddr;
import javaforce.controls.mod.ModData;
import javaforce.controls.mod.ModPacket;
import javaforce.controls.ni.DAQmx;
import javaforce.controls.s7.S7Data;
import javaforce.controls.s7.S7Packet;
import javaforce.controls.s7.S7Types;
import javaforce.media.AudioInput;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcDriver;
import org.apache.plc4x.java.api.PlcDriverManager;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.value.PlcValue;

public class Controller {
    private boolean connected;
    private Socket socket;
    private InputStream is;
    private OutputStream os;
    private PlcConnection plcConn;
    private PlcDriver plcDrv;
    private int plcType;
    private int plcSubType;
    private DAQmx daq;
    private Object lock = new Object();
    private static Object s7_connect_lock = new Object();
    private AudioInput mic;
    private int micBufferSize;
    private short[] micBuffer;
    private int timeout = 3000;
    private ABContext ab_context;
    public static double rate;
    public Exception lastException;
    public static boolean debug;
    private static boolean netty;
    private String socks;
    private static byte[] empty;

    public void setRate(float rate) {
        Controller.rate = rate;
    }

    public void setTimeout(int ms) {
        if (ms < 1000) {
            ms = 1000;
        }
        if (ms > 30000) {
            ms = 30000;
        }
        this.timeout = ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(String url) {
        if (debug) {
            JFLog.log("Controller.connect():" + url);
        }
        this.connected = false;
        if (url == null) {
            JFLog.log("Controller:connect():url == null");
            return false;
        }
        if (url.contains("://")) {
            String driver;
            if (!netty) {
                netty = true;
                JFLog.log("Disabling netty unsafe usage!");
                System.setProperty("org.jboss.netty.debug", "true");
                System.setProperty("io.netty.allocator.numDirectArenas", "0");
                System.setProperty("io.netty.noPreferDirect", "true");
                System.setProperty("io.netty.noUnsafe", "true");
            }
            this.plcType = 7;
            int idx = url.indexOf(58);
            switch (driver = url.substring(0, idx).toUpperCase()) {
                case "S7": {
                    this.plcSubType = 2;
                    break;
                }
                case "AB": {
                    this.plcSubType = 3;
                }
            }
            try {
                this.plcConn = PlcDriverManager.getDefault().getConnectionManager().getConnection(url);
                JFLog.log("Controller:conn=" + String.valueOf(this.plcConn));
                this.plcDrv = PlcDriverManager.getDefault().getDriver(driver);
                JFLog.log("Controller:driver=" + String.valueOf(this.plcDrv));
                return true;
            }
            catch (Exception e) {
                JFLog.log(e);
                return false;
            }
        }
        if (url.startsWith("S7:")) {
            this.plcType = 2;
            String host = url.substring(3);
            Object driver = s7_connect_lock;
            synchronized (driver) {
                try {
                    int read;
                    this.connect(host, 102);
                    this.socket.setSoTimeout(this.timeout);
                    this.os = this.socket.getOutputStream();
                    this.is = this.socket.getInputStream();
                    byte[] packet = S7Packet.makeConnectPacket1();
                    this.os.write(packet);
                    byte[] reply = new byte[1500];
                    int replySize = 0;
                    do {
                        if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                        throw new Exception("bad read");
                    } while (!S7Packet.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
                    packet = S7Packet.makeConnectPacket2();
                    this.os.write(packet);
                    reply = new byte[1500];
                    replySize = 0;
                    do {
                        if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                        throw new Exception("bad read");
                    } while (!S7Packet.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            this.connected = true;
            return true;
        }
        if (url.startsWith("MODBUS:")) {
            this.plcType = 4;
            String host = url.substring(7);
            try {
                this.connect(host, 502);
                this.socket.setSoTimeout(this.timeout);
                this.os = this.socket.getOutputStream();
                this.is = this.socket.getInputStream();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            this.connected = true;
            return true;
        }
        if (url.startsWith("AB:")) {
            this.ab_context = new ABContext();
            this.plcType = 3;
            String host = url.substring(3);
            try {
                int read;
                this.connect(host, 44818);
                this.socket.setSoTimeout(this.timeout);
                this.os = this.socket.getOutputStream();
                this.is = this.socket.getInputStream();
                byte[] packet = ABPacket.makeConnectPacket(this.ab_context);
                this.os.write(packet);
                byte[] reply = new byte[1500];
                int replySize = 0;
                do {
                    if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                    throw new Exception("bad read");
                } while (!ABPacket.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
                ENIP ip = new ENIP();
                ip.read(reply, 0);
                this.ab_context.session = ip.session;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            this.connected = true;
            return true;
        }
        if (url.startsWith("NI:")) {
            this.plcType = 5;
            this.daq = DAQmx.getInstance();
            this.connected = this.daq.connect(url.substring(3));
            if (!this.connected) {
                this.daq.close();
                this.daq = null;
            }
            return this.connected;
        }
        if (url.startsWith("MIC:")) {
            this.plcType = 6;
            this.mic = new AudioInput();
            this.micBufferSize = (int)(44100.0 / (1000.0 / rate));
            this.micBuffer = new short[this.micBufferSize];
            this.connected = this.mic.start(1, 44100, 16, this.micBufferSize, url.substring(4));
            return this.connected;
        }
        return false;
    }

    private void connect(String host, int port) throws Exception {
        if (this.socks != null) {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.socks, 1080), this.timeout);
            if (!SOCKS.connect(this.socket, host, port)) {
                throw new Exception("SOCKS connection failed");
            }
        } else {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(host, port), this.timeout);
        }
    }

    public void setSOCKS(String host) {
        this.socks = host;
    }

    public boolean disconnect() {
        if (!this.connected) {
            return false;
        }
        switch (this.plcType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                try {
                    if (this.socket == null) break;
                    this.socket.close();
                    this.socket = null;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            case 5: {
                if (this.daq == null) break;
                this.daq.close();
                this.daq = null;
                break;
            }
            case 6: {
                this.mic.stop();
                this.mic = null;
            }
        }
        this.connected = false;
        return true;
    }

    private boolean writePartial(S7Data s7) {
        byte[] packet = S7Packet.makeWritePacket(s7);
        try {
            this.os.write(packet);
        }
        catch (Exception e) {
            this.lastException = e;
            return false;
        }
        byte[] reply = new byte[1500];
        int replySize = 0;
        try {
            int read;
            do {
                if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                throw new Exception("bad read");
            } while (!S7Packet.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
        }
        catch (Exception e) {
            this.lastException = e;
            return false;
        }
        return true;
    }

    public boolean write(String addr, byte[] data) {
        return this.write(addr, data, datatype.ANY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(String addr, byte[] data, datatype type) {
        addr = addr.toUpperCase();
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                return false;
            }
            switch (this.plcType) {
                case 2: {
                    S7Data s7 = S7Packet.decodeAddress(addr);
                    if (s7.data_type == 1) {
                        s7.data = data;
                        if (!this.writePartial(s7)) {
                            return false;
                        }
                    } else {
                        int left = s7.getLength();
                        int dst_offset = s7.offset >> 3;
                        int src_offset = 0;
                        int copying = 0;
                        while (left > 0) {
                            if (left > 200) {
                                copying = 200;
                                s7.data = Arrays.copyOfRange(data, src_offset, src_offset + 200);
                                s7.length = (short)(200 / S7Types.getTypeSize(s7.data_type, 1));
                                s7.offset = dst_offset << 3;
                                if (!this.writePartial(s7)) {
                                    return false;
                                }
                            } else {
                                copying = left;
                                s7.data = Arrays.copyOfRange(data, src_offset, src_offset + left);
                                s7.length = (short)(left / S7Types.getTypeSize(s7.data_type, 1));
                                s7.offset = dst_offset << 3;
                                if (!this.writePartial(s7)) {
                                    return false;
                                }
                            }
                            left -= copying;
                            dst_offset += copying;
                            src_offset += copying;
                        }
                    }
                    return true;
                }
                case 4: {
                    ModAddr ma = ModPacket.decodeAddress(addr);
                    ma.data = data;
                    byte[] packet = ModPacket.makeWritePacket(ma);
                    try {
                        this.os.write(packet);
                    }
                    catch (Exception e) {
                        this.lastException = e;
                        return false;
                    }
                    byte[] reply = new byte[1500];
                    int replySize = 0;
                    try {
                        int read;
                        do {
                            if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                            throw new Exception("bad read");
                        } while (!ModPacket.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
                    }
                    catch (Exception e) {
                        this.lastException = e;
                        return false;
                    }
                    return true;
                }
                case 3: {
                    if (type == datatype.ANY) {
                        return false;
                    }
                    byte[] packet = ABPacket.makeWritePacket(addr, ABPacket.getType(type), data, this.ab_context);
                    try {
                        this.os.write(packet);
                    }
                    catch (Exception e) {
                        this.lastException = e;
                        return false;
                    }
                    byte[] reply = new byte[1500];
                    int replySize = 0;
                    try {
                        int read;
                        do {
                            if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                            throw new Exception("bad read");
                        } while (!ABPacket.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
                    }
                    catch (Exception e) {
                        this.lastException = e;
                        return false;
                    }
                    return true;
                }
                case 1: {
                    JFTag tag = JFPacket.decodeAddress(addr);
                    tag.data = data;
                    byte[] packet = JFPacket.makeWritePacket(tag, data);
                    try {
                        this.os.write(packet);
                    }
                    catch (Exception e) {
                        this.lastException = e;
                        return false;
                    }
                    return true;
                }
                case 5: {
                    JFLog.log("Controller:write():NI not implemented");
                    return false;
                }
                case 6: {
                    JFLog.log("Controller:write():MIC not supported");
                    return false;
                }
            }
            return false;
        }
    }

    private byte[] readPartial(S7Data s7) {
        byte[] packet = S7Packet.makeReadPacket(s7);
        try {
            this.os.write(packet);
        }
        catch (Exception e) {
            this.lastException = e;
            return null;
        }
        byte[] reply = new byte[1500];
        int replySize = 0;
        try {
            int read;
            do {
                if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                throw new Exception("bad read");
            } while (!S7Packet.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
        }
        catch (Exception e) {
            this.lastException = e;
            return null;
        }
        s7 = S7Packet.decodePacket(Arrays.copyOf(reply, replySize));
        if (s7 == null) {
            return null;
        }
        return s7.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(String addr) {
        addr = ((String)addr).toUpperCase();
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                return null;
            }
            switch (this.plcType) {
                case 7: {
                    try {
                        PlcReadRequest.Builder reader = this.plcConn.readRequestBuilder();
                        switch (this.plcSubType) {
                            case 2: {
                                if (((String)addr).startsWith("%")) break;
                                addr = "%" + (String)addr;
                            }
                        }
                        PlcTag plcTag = this.plcDrv.prepareTag((String)addr);
                        reader.addTag("tag0", plcTag);
                        PlcReadResponse data = (PlcReadResponse)reader.build().execute().get(5000L, TimeUnit.MILLISECONDS);
                        PlcValue value = data.getPlcValue("tag0");
                        if (value != null) {
                            return value.getRaw();
                        }
                        return empty;
                    }
                    catch (Exception e) {
                        JFLog.log(e);
                        break;
                    }
                }
                case 2: {
                    S7Data s7 = S7Packet.decodeAddress((String)addr);
                    if (s7 == null) {
                        return null;
                    }
                    byte[] data = new byte[s7.getLength()];
                    int offset = 0;
                    int read = 0;
                    int left = data.length;
                    while (read < data.length) {
                        s7.length = left > 200 ? (int)((short)(200 / S7Types.getTypeSize(s7.data_type, 1))) : (int)((short)(left / S7Types.getTypeSize(s7.data_type, 1)));
                        byte[] part = this.readPartial(s7);
                        if (part == null) {
                            return null;
                        }
                        System.arraycopy(part, 0, data, offset, part.length);
                        left -= part.length;
                        read += part.length;
                        s7.offset += part.length << 3;
                        offset += part.length;
                    }
                    return data;
                }
                case 4: {
                    ModAddr ma = ModPacket.decodeAddress((String)addr);
                    byte[] packet = ModPacket.makeReadPacket(ma);
                    try {
                        this.os.write(packet);
                    }
                    catch (Exception e) {
                        this.lastException = e;
                        return null;
                    }
                    byte[] reply = new byte[1500];
                    int replySize = 0;
                    try {
                        int read;
                        do {
                            if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                            throw new Exception("bad read");
                        } while (!ModPacket.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
                    }
                    catch (Exception e) {
                        this.lastException = e;
                        return null;
                    }
                    ModData data = ModPacket.decodePacket(Arrays.copyOf(reply, replySize));
                    return data.data;
                }
                case 3: {
                    byte[] packet = ABPacket.makeReadPacket((String)addr, this.ab_context);
                    try {
                        this.os.write(packet);
                    }
                    catch (Exception e) {
                        this.lastException = e;
                        return null;
                    }
                    byte[] reply = new byte[1500];
                    int replySize = 0;
                    try {
                        int read;
                        do {
                            if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                            throw new Exception("bad read");
                        } while (!ABPacket.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
                        return ABPacket.decodePacket(reply);
                    }
                    catch (Exception e) {
                        this.lastException = e;
                        return null;
                    }
                }
                case 1: {
                    JFTag tag = JFPacket.decodeAddress((String)addr);
                    if (tag == null) {
                        return null;
                    }
                    byte[] packet = JFPacket.makeReadPacket(tag);
                    try {
                        this.os.write(packet);
                    }
                    catch (Exception e) {
                        this.lastException = e;
                        return null;
                    }
                    byte[] reply = new byte[1500];
                    int replySize = 0;
                    try {
                        int read;
                        do {
                            if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                            throw new Exception("bad read");
                        } while (!JFPacket.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
                    }
                    catch (Exception e) {
                        this.lastException = e;
                        return null;
                    }
                    tag = JFPacket.decodePacket(Arrays.copyOf(reply, replySize));
                    return tag.data;
                }
                case 5: {
                    return this.daq.read();
                }
                case 6: {
                    byte[] ret = new byte[2];
                    if (!this.mic.read(this.micBuffer)) {
                        return null;
                    }
                    short max = 0;
                    for (int a = 0; a < this.micBufferSize; ++a) {
                        short sam = this.micBuffer[a];
                        if (sam < 0) {
                            sam = (short)(sam * -1);
                        }
                        if (sam <= max) continue;
                        max = sam;
                    }
                    LE.setuint16(ret, 0, max);
                    return ret;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[][] read(String[] addr) {
        if (!this.connected) {
            return null;
        }
        for (int a = 0; a < addr.length; ++a) {
            addr[a] = addr[a].toUpperCase();
        }
        switch (this.plcType) {
            case 7: {
                try {
                    PlcReadRequest.Builder reader = this.plcConn.readRequestBuilder();
                    int idx = 0;
                    for (String string : addr) {
                        void var7_29;
                        switch (this.plcSubType) {
                            case 2: {
                                if (string.startsWith("%")) break;
                                String string2 = "%" + string;
                            }
                        }
                        PlcTag plcTag = this.plcDrv.prepareTag((String)var7_29);
                        reader.addTag("tag" + idx, plcTag);
                        ++idx;
                    }
                    PlcReadResponse data = (PlcReadResponse)reader.build().execute().get(5000L, TimeUnit.MILLISECONDS);
                    byte[][] ret = new byte[addr.length][];
                    idx = 0;
                    for (String string : data.getTagNames()) {
                        PlcValue value = data.getPlcValue("tag" + idx);
                        ret[idx] = value != null ? value.getRaw() : empty;
                        ++idx;
                    }
                    return ret;
                }
                catch (Exception e) {
                    JFLog.log(e);
                    break;
                }
            }
            case 2: {
                void var7_35;
                S7Data[] s7 = new S7Data[addr.length];
                for (int a = 0; a < addr.length; ++a) {
                    s7[a] = S7Packet.decodeAddress(addr[a]);
                }
                byte[] packet = S7Packet.makeReadPacket(s7);
                try {
                    this.os.write(packet);
                }
                catch (Exception e) {
                    this.lastException = e;
                    return null;
                }
                byte[] reply = new byte[1500];
                int replySize = 0;
                try {
                    int read;
                    do {
                        if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                        throw new Exception("bad read");
                    } while (!S7Packet.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
                }
                catch (Exception e) {
                    this.lastException = e;
                    return null;
                }
                s7 = S7Packet.decodeMultiPacket(Arrays.copyOf(reply, replySize), addr.length);
                byte[][] ret = new byte[addr.length][];
                boolean bl = false;
                while (var7_35 < addr.length) {
                    ret[var7_35] = s7[var7_35].data;
                    ++var7_35;
                }
                return ret;
            }
            case 1: {
                void var7_37;
                JFTag[] tags = new JFTag[addr.length];
                for (int a = 0; a < addr.length; ++a) {
                    tags[a] = JFPacket.decodeAddress(addr[a]);
                }
                byte[] packet = JFPacket.makeReadPacket(tags);
                try {
                    this.os.write(packet);
                }
                catch (Exception e) {
                    this.lastException = e;
                    return null;
                }
                byte[] reply = new byte[1500];
                int replySize = 0;
                try {
                    int read;
                    do {
                        if ((read = this.is.read(reply, replySize, 1500 - replySize)) != -1) continue;
                        throw new Exception("bad read");
                    } while (!JFPacket.isPacketComplete(Arrays.copyOf(reply, replySize += read)));
                }
                catch (Exception e) {
                    this.lastException = e;
                    return null;
                }
                tags = JFPacket.decodeMultiPacket(Arrays.copyOf(reply, replySize), addr.length);
                byte[][] ret = new byte[addr.length][];
                boolean bl = false;
                while (var7_37 < addr.length) {
                    ret[var7_37] = tags[var7_37].data;
                    ++var7_37;
                }
                return ret;
            }
        }
        return null;
    }

    public boolean isConnected() {
        if (this.plcType == 0) {
            return false;
        }
        try {
            switch (this.plcType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return this.socket.isConnected();
                }
            }
            return this.connected;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isBE() {
        switch (this.plcType) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return false;
            }
        }
        return true;
    }

    public boolean isLE() {
        return !this.isBE();
    }

    static {
        empty = new byte[0];
    }

    public static enum datatype {
        ANY,
        INTEGER8,
        INTEGER16,
        INTEGER32,
        INTEGER64,
        FLOAT,
        DOUBLE,
        BOOLEAN;

    }
}

