/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls.ni;

import javaforce.BE;
import javaforce.controls.Controller;
import javaforce.jni.DAQmxJNI;

public abstract class DAQmx {
    private static DAQmx instance;
    private long handle;
    private types type;
    private int chs = 1;

    public static DAQmx getInstance() {
        if (instance == null && !(instance = new DAQmxJNI()).niInit()) {
            instance = null;
        }
        return instance;
    }

    public static boolean loaded() {
        return instance != null;
    }

    public abstract boolean niInit();

    public abstract long createTask();

    public abstract boolean createChannelAnalog(long var1, String var3, double var4, long var6, double var8, double var10);

    public abstract boolean createChannelDigital(long var1, String var3, double var4, long var6);

    public abstract boolean createChannelCounter(long var1, String var3, double var4, long var6, double var8, double var10, String var12, double var13, int var15);

    public abstract boolean startTask(long var1);

    public abstract int readTaskAnalog(long var1, int var3, double[] var4);

    public abstract int readTaskBinary(long var1, int var3, int[] var4);

    public abstract int readTaskDigital(long var1, int var3, int[] var4);

    public abstract int readTaskCounter(long var1, int var3, double[] var4);

    public abstract boolean stopTask(long var1);

    public abstract boolean clearTask(long var1);

    public abstract void niPrintError();

    public boolean connect(String url) {
        int idx = url.indexOf(47);
        Object device = url.substring(0, idx);
        Object port = url.substring(idx + 1);
        int samples = (int)Controller.rate;
        if (samples == 0) {
            samples = 1;
        }
        samples = 1;
        if (((String)port).startsWith("ai")) {
            this.type = types.AI;
            this.handle = this.createTask();
            if (!this.createChannelAnalog(this.handle, url, Controller.rate, samples, -10.0, 10.0)) {
                return false;
            }
            if (this.startTask(this.handle)) {
                return true;
            }
            this.niPrintError();
            return false;
        }
        if (((String)port).startsWith("port")) {
            String ln;
            String[] yz;
            this.type = types.DI;
            this.handle = this.createTask();
            if (!this.createChannelDigital(this.handle, url, Controller.rate, samples)) {
                return false;
            }
            int li = url.lastIndexOf("/");
            if (li != -1 && (yz = (ln = url.substring(li + 1 + 4)).split(":")).length == 2) {
                int y = Integer.valueOf(yz[0]);
                int z = Integer.valueOf(yz[1]);
                this.chs = z - y + 1;
            }
            if (this.startTask(this.handle)) {
                return true;
            }
            this.niPrintError();
            return false;
        }
        if (((String)port).startsWith("ctr")) {
            this.type = types.CI;
            this.handle = this.createTask();
            String[] p = url.split("/");
            device = p[0] + "/" + p[1];
            if (!this.createChannelCounter(this.handle, (String)device, 2.0E7, samples, 2.0, 1000.0, (String)(port = "/" + p[0] + "/" + p[2]), 1.0 / Controller.rate, 4)) {
                return false;
            }
            if (this.startTask(this.handle)) {
                return true;
            }
            this.niPrintError();
            return false;
        }
        System.out.println("Unsupported DAQmx host:" + url);
        return false;
    }

    public void close() {
        if (this.handle != 0L) {
            this.stopTask(this.handle);
            this.clearTask(this.handle);
            this.handle = 0L;
        }
    }

    public byte[] read() {
        int read = 0;
        byte[] out = null;
        switch (this.type.ordinal()) {
            case 0: {
                double[] data = new double[this.chs];
                read = this.readTaskAnalog(this.handle, 1, data);
                out = new byte[this.chs * 8];
                int pos = 0;
                for (int a = 0; a < this.chs; ++a) {
                    BE.setuint64(out, pos, Double.doubleToLongBits(data[a]));
                    pos += 8;
                }
                break;
            }
            case 1: {
                int[] data = new int[this.chs];
                read = this.readTaskDigital(this.handle, this.chs, data);
                out = new byte[this.chs];
                int pos = 0;
                for (int a = 0; a < this.chs; ++a) {
                    int n = pos++;
                    out[n] = (byte)(out[n] | (byte)data[a]);
                    if (pos != this.chs) continue;
                    pos = 0;
                }
                break;
            }
            case 2: {
                double[] data = new double[this.chs];
                read = this.readTaskCounter(this.handle, 1, data);
                out = new byte[this.chs * 8];
                int pos = 0;
                for (int a = 0; a < this.chs; ++a) {
                    BE.setuint64(out, pos, Double.doubleToLongBits(data[a]));
                    pos += 8;
                }
                break;
            }
        }
        if (read != this.chs) {
            this.niPrintError();
        }
        return out;
    }

    private static enum types {
        AI,
        DI,
        CI;

    }
}

