/*
 * Decompiled with CFR 0.152.
 */
package javaforce.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javaforce.JFLog;
import javaforce.db.Row;
import javaforce.io.ObjectReader;
import javaforce.io.ObjectWriter;
import javaforce.io.SerialObject;

@Deprecated
public class Table<ROW extends Row>
extends SerialObject {
    private Row.Creator ctr;
    private ArrayList<ROW> rows = new ArrayList();
    private int minid = 1;
    private int nextid = 1;
    private int maxid = Integer.MAX_VALUE;
    private boolean reuseids = false;
    public int id;
    public String name;
    public int xid;
    protected transient String filename;
    private static final int version = 1;

    private ROW create() {
        return (ROW)this.ctr.newInstance();
    }

    public Table(Row.Creator rowCreator) {
        this.ctr = rowCreator;
    }

    public boolean load(String filename) {
        this.rows.clear();
        this.filename = filename;
        if (!new File(filename).exists()) {
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(filename);
            ObjectReader ois = new ObjectReader(fis);
            ois.readObject(this);
            fis.close();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean save() {
        try {
            FileOutputStream fos = new FileOutputStream(this.filename);
            ObjectWriter oos = new ObjectWriter(fos);
            oos.writeObject(this);
            fos.close();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private int findIdx(ROW row) {
        int cnt = this.rows.size();
        if (cnt == 0) {
            return 0;
        }
        int min = 0;
        int idx = cnt / 2;
        int max = cnt;
        while (idx != cnt) {
            Row r = (Row)this.rows.get(idx);
            switch (r.compare((Row)row)) {
                case 0: {
                    return idx;
                }
                case -1: {
                    if (idx == max) {
                        return idx;
                    }
                    int tmp = idx;
                    int delta = (max - idx) / 2;
                    if (delta == 0) {
                        ++delta;
                    }
                    idx += delta;
                    min = tmp;
                    break;
                }
                case 1: {
                    if (idx == min) {
                        return idx;
                    }
                    int tmp = idx;
                    int delta = (idx - min) / 2;
                    if (delta == 0) {
                        ++delta;
                    }
                    idx -= delta;
                    max = tmp;
                }
            }
        }
        return idx;
    }

    public synchronized void add(ROW row) {
        if (this.reuseids) {
            int id = this.minid;
            int cnt = this.getCount();
            for (int a = 0; a < cnt; ++a) {
                Row r = (Row)this.rows.get(a);
                if (r.id != id) continue;
                if (++id == this.maxid) {
                    JFLog.log("Warning:Table is full!");
                    return;
                }
                a = -1;
            }
            ((Row)row).id = id;
        } else {
            ((Row)row).id = this.nextid++;
            if (this.nextid == this.maxid) {
                JFLog.log("Warning:Table id reset to start!");
                this.nextid = this.minid;
            }
        }
        ((Row)row).timestamp = System.currentTimeMillis();
        this.rows.add(this.findIdx(row), row);
    }

    public ROW get(int id) {
        int size = this.rows.size();
        for (int a = 0; a < size; ++a) {
            Row row = (Row)this.rows.get(a);
            if (row.id != id) continue;
            return (ROW)row;
        }
        return null;
    }

    public void remove(int id) {
        int size = this.rows.size();
        for (int a = 0; a < size; ++a) {
            Row row = (Row)this.rows.get(a);
            if (row.id != id) continue;
            this.rows.remove(a);
            break;
        }
    }

    public void clear() {
        this.rows.clear();
    }

    public ArrayList<ROW> getRows() {
        return this.rows;
    }

    public int getCount() {
        return this.rows.size();
    }

    public int getMinId() {
        return this.minid;
    }

    public int getMaxId() {
        return this.maxid;
    }

    public int getNextId() {
        return this.nextid;
    }

    public void setMinId(int id) {
        if (this.nextid < id) {
            this.nextid = id;
        }
        this.minid = id;
    }

    public void setMaxId(int id) {
        if (this.nextid > id) {
            this.nextid = this.minid;
        }
        this.maxid = id;
    }

    public boolean getReuseIds() {
        return this.reuseids;
    }

    public void setReuseIds(boolean state) {
        this.reuseids = state;
    }

    @Override
    public void readObject() throws Exception {
        int ver = this.readInt();
        this.minid = this.readInt();
        this.nextid = this.readInt();
        this.maxid = this.readInt();
        this.reuseids = this.readBoolean();
        this.id = this.readInt();
        this.name = this.readString();
        this.xid = this.readInt();
        int cnt = this.readInt();
        for (int a = 0; a < cnt; ++a) {
            ROW row = this.create();
            ((SerialObject)row).readInit(this);
            ((Row)row).readObject();
            this.rows.add(row);
        }
    }

    @Override
    public void writeObject() throws Exception {
        this.writeInt(1);
        this.writeInt(this.minid);
        this.writeInt(this.nextid);
        this.writeInt(this.maxid);
        this.writeBoolean(this.reuseids);
        this.writeInt(this.id);
        this.writeString(this.name);
        this.writeInt(this.xid);
        int cnt = this.rows.size();
        this.writeInt(cnt);
        for (int a = 0; a < cnt; ++a) {
            Row row = (Row)this.rows.get(a);
            row.writeInit(this);
            row.writeObject();
        }
    }
}

