/*
 * Decompiled with CFR 0.152.
 */
package javaforce.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javaforce.JFLog;
import javaforce.db.Row;
import javaforce.db.Table;
import javaforce.io.ObjectReader;
import javaforce.io.ObjectWriter;
import javaforce.io.SerialObject;

@Deprecated
public class TableList<ROW extends Row>
extends SerialObject {
    private Row.Creator ctr;
    private String folder;
    private int minid = 1;
    private int nextid = 1;
    private int maxid = Integer.MAX_VALUE;
    private transient ArrayList<Table<ROW>> tables = new ArrayList();
    private static final int version = 1;

    public Table<ROW> create() {
        return new Table(this.ctr);
    }

    public TableList(Row.Creator rowCreator) {
        this.ctr = rowCreator;
    }

    private void loadTables() {
        for (int a = 1; a < this.nextid; ++a) {
            String filename = this.folder + "/" + a + ".dat";
            if (!new File(filename).exists()) continue;
            Table<ROW> table = this.create();
            table.load(filename);
            if (table == null) {
                JFLog.log("Error:Table.load() failed:" + filename);
                continue;
            }
            this.tables.add(table);
        }
    }

    public boolean load(String folder) {
        this.folder = folder;
        try {
            File file = new File(folder + "/0.dat");
            if (!file.exists()) {
                return false;
            }
            String filename = folder + "/0.dat";
            FileInputStream fis = new FileInputStream(filename);
            new ObjectReader(fis).readObject(this);
            fis.close();
            this.tables = new ArrayList();
            this.loadTables();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public Table<ROW> get(int id) {
        int cnt = this.tables.size();
        for (int a = 0; a < cnt; ++a) {
            Table<ROW> table = this.tables.get(a);
            if (table.id != id) continue;
            return table;
        }
        return null;
    }

    public Table<ROW> get(String name) {
        int cnt = this.tables.size();
        for (int a = 0; a < cnt; ++a) {
            Table<ROW> table = this.tables.get(a);
            if (!table.name.equals(name)) continue;
            return table;
        }
        JFLog.log("Error:Table not found:" + name);
        return null;
    }

    public void save(int id) {
        Table<ROW> table = this.get(id);
        if (table != null) {
            table.save();
        }
    }

    private void save() {
        try {
            new File(this.folder).mkdirs();
            FileOutputStream fos = new FileOutputStream(this.folder + "/0.dat");
            ObjectWriter oos = new ObjectWriter(fos);
            oos.writeObject(this);
            fos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public synchronized void add(Table<ROW> table) {
        table.id = this.nextid++;
        if (this.nextid == this.maxid) {
            JFLog.log("Warning:TableList:next id reset to start");
            this.nextid = this.minid;
        }
        table.filename = this.folder + "/" + table.id + ".dat";
        this.tables.add(table);
        this.save();
    }

    public ArrayList<Table<ROW>> getTables() {
        return this.tables;
    }

    public void remove(int id) {
        File file = new File(this.folder + "/" + id + ".dat");
        if (file.exists()) {
            file.delete();
        }
        int cnt = this.tables.size();
        for (int a = 0; a < cnt; ++a) {
            Table<ROW> table = this.tables.get(a);
            if (table.id != id) continue;
            this.tables.remove(a);
            break;
        }
    }

    @Override
    public void readObject() throws Exception {
        int ver = this.readInt();
        this.folder = this.readString();
        this.minid = this.readInt();
        this.nextid = this.readInt();
        this.maxid = this.readInt();
    }

    @Override
    public void writeObject() throws Exception {
        this.writeInt(1);
        this.writeString(this.folder);
        this.writeInt(this.minid);
        this.writeInt(this.nextid);
        this.writeInt(this.maxid);
    }
}

