/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ffm;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import javaforce.JFLog;
import javaforce.api.CLAPI;
import javaforce.ffm.FFM;

public class CLFFM
implements CLAPI {
    private Arena arena;
    private static CLFFM instance;
    private MethodHandle clLoadLibrary;
    private MethodHandle clCreate;
    private MethodHandle clKernel;
    private MethodHandle clCreateBuffer;
    private MethodHandle clSetArg;
    private MethodHandle clWriteBufferi8;
    private MethodHandle clWriteBufferf32;
    private MethodHandle clExecute;
    private MethodHandle clExecute2;
    private MethodHandle clExecute3;
    private MethodHandle clExecute4;
    private MethodHandle clReadBufferi8;
    private MethodHandle clReadBufferf32;
    private MethodHandle clFreeKernel;
    private MethodHandle clFreeBuffer;
    private MethodHandle clClose;

    public static CLFFM getInstance() {
        if (instance == null && !(instance = new CLFFM()).ffm_init()) {
            JFLog.log("CLFFM init failed!");
            instance = null;
        }
        return instance;
    }

    @Override
    public boolean clLoadLibrary(String file) {
        try {
            boolean _ret_value_ = this.clLoadLibrary.invokeExact(this.arena.allocateFrom(file));
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public long clCreate(String src, int type) {
        try {
            long _ret_value_ = this.clCreate.invokeExact(this.arena.allocateFrom(src), type);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1L;
        }
    }

    @Override
    public long clKernel(long ctx, String func) {
        try {
            long _ret_value_ = this.clKernel.invokeExact(ctx, this.arena.allocateFrom(func));
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1L;
        }
    }

    @Override
    public long clCreateBuffer(long ctx, int size, int type) {
        try {
            long _ret_value_ = this.clCreateBuffer.invokeExact(ctx, size, type);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1L;
        }
    }

    @Override
    public boolean clSetArg(long ctx, long kernel, int idx, byte[] value, int size) {
        MemorySegment _array_value = FFM.toMemory(this.arena, value);
        try {
            boolean _ret_value_ = this.clSetArg.invokeExact(ctx, kernel, idx, _array_value, size);
            FFM.copyBack(_array_value, value);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean clWriteBufferi8(long ctx, long buffer, byte[] value, int size) {
        MemorySegment _array_value = FFM.toMemory(this.arena, value);
        try {
            boolean _ret_value_ = this.clWriteBufferi8.invokeExact(ctx, buffer, _array_value, size);
            FFM.copyBack(_array_value, value);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean clWriteBufferf32(long ctx, long buffer, float[] value, int size) {
        MemorySegment _array_value = FFM.toMemory(this.arena, value);
        try {
            boolean _ret_value_ = this.clWriteBufferf32.invokeExact(ctx, buffer, _array_value, size);
            FFM.copyBack(_array_value, value);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean clExecute(long ctx, long kernel, int count) {
        try {
            boolean _ret_value_ = this.clExecute.invokeExact(ctx, kernel, count);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean clExecute2(long ctx, long kernel, int count1, int count2) {
        try {
            boolean _ret_value_ = this.clExecute2.invokeExact(ctx, kernel, count1, count2);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean clExecute3(long ctx, long kernel, int count1, int count2, int count3) {
        try {
            boolean _ret_value_ = this.clExecute3.invokeExact(ctx, kernel, count1, count2, count3);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean clExecute4(long ctx, long kernel, int count1, int count2, int count3, int count4) {
        try {
            boolean _ret_value_ = this.clExecute4.invokeExact(ctx, kernel, count1, count2, count3, count4);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean clReadBufferi8(long ctx, long buffer, byte[] value, int size) {
        MemorySegment _array_value = FFM.toMemory(this.arena, value);
        try {
            boolean _ret_value_ = this.clReadBufferi8.invokeExact(ctx, buffer, _array_value, size);
            FFM.copyBack(_array_value, value);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean clReadBufferf32(long ctx, long buffer, float[] value, int size) {
        MemorySegment _array_value = FFM.toMemory(this.arena, value);
        try {
            boolean _ret_value_ = this.clReadBufferf32.invokeExact(ctx, buffer, _array_value, size);
            FFM.copyBack(_array_value, value);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean clFreeKernel(long ctx, long kernel) {
        try {
            boolean _ret_value_ = this.clFreeKernel.invokeExact(ctx, kernel);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean clFreeBuffer(long ctx, long buffer) {
        try {
            boolean _ret_value_ = this.clFreeBuffer.invokeExact(ctx, buffer);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean clClose(long ctx) {
        try {
            boolean _ret_value_ = this.clClose.invokeExact(ctx);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    private boolean ffm_init() {
        FFM ffm = FFM.getInstance();
        this.arena = Arena.ofAuto();
        MethodHandle init = ffm.getFunction("CLAPIinit", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN));
        if (init == null) {
            return false;
        }
        try {
            if (!init.invokeExact()) {
                return false;
            }
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
        this.clLoadLibrary = ffm.getFunctionPtr("_clLoadLibrary", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS));
        this.clCreate = ffm.getFunctionPtr("_clCreate", ffm.getFunctionDesciptor(ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        this.clKernel = ffm.getFunctionPtr("_clKernel", ffm.getFunctionDesciptor(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS));
        this.clCreateBuffer = ffm.getFunctionPtr("_clCreateBuffer", ffm.getFunctionDesciptor(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.clSetArg = ffm.getFunctionPtr("_clSetArg", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        this.clWriteBufferi8 = ffm.getFunctionPtr("_clWriteBufferi8", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        this.clWriteBufferf32 = ffm.getFunctionPtr("_clWriteBufferf32", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        this.clExecute = ffm.getFunctionPtr("_clExecute", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT));
        this.clExecute2 = ffm.getFunctionPtr("_clExecute2", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.clExecute3 = ffm.getFunctionPtr("_clExecute3", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.clExecute4 = ffm.getFunctionPtr("_clExecute4", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.clReadBufferi8 = ffm.getFunctionPtr("_clReadBufferi8", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        this.clReadBufferf32 = ffm.getFunctionPtr("_clReadBufferf32", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        this.clFreeKernel = ffm.getFunctionPtr("_clFreeKernel", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG));
        this.clFreeBuffer = ffm.getFunctionPtr("_clFreeBuffer", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG));
        this.clClose = ffm.getFunctionPtr("_clClose", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG));
        return true;
    }
}

