/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ffm;

import java.lang.foreign.Arena;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import javaforce.JFLog;
import javaforce.api.CameraAPI;
import javaforce.ffm.FFM;

public class CameraFFM
implements CameraAPI {
    private Arena arena;
    private static CameraFFM instance;
    private MethodHandle cameraInit;
    private MethodHandle cameraUninit;
    private MethodHandle cameraListDevices;
    private MethodHandle cameraListModes;
    private MethodHandle cameraStart;
    private MethodHandle cameraStop;
    private MethodHandle cameraGetFrame;
    private MethodHandle cameraGetWidth;
    private MethodHandle cameraGetHeight;

    public static CameraFFM getInstance() {
        if (instance == null && !(instance = new CameraFFM()).ffm_init()) {
            JFLog.log("CameraFFM init failed!");
            instance = null;
        }
        return instance;
    }

    @Override
    public long cameraInit() {
        try {
            long _ret_value_ = this.cameraInit.invokeExact();
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1L;
        }
    }

    @Override
    public boolean cameraUninit(long ctx) {
        try {
            boolean _ret_value_ = this.cameraUninit.invokeExact(ctx);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public String[] cameraListDevices(long ctx) {
        try {
            String[] _ret_value_ = FFM.toArrayString(this.cameraListDevices.invokeExact(ctx));
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return null;
        }
    }

    @Override
    public String[] cameraListModes(long ctx, int deviceIdx) {
        try {
            String[] _ret_value_ = FFM.toArrayString(this.cameraListModes.invokeExact(ctx, deviceIdx));
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return null;
        }
    }

    @Override
    public boolean cameraStart(long ctx, int deviceIdx, int width, int height) {
        try {
            boolean _ret_value_ = this.cameraStart.invokeExact(ctx, deviceIdx, width, height);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public boolean cameraStop(long ctx) {
        try {
            boolean _ret_value_ = this.cameraStop.invokeExact(ctx);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public int[] cameraGetFrame(long ctx) {
        try {
            int[] _ret_value_ = FFM.toArrayInt(this.cameraGetFrame.invokeExact(ctx));
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return null;
        }
    }

    @Override
    public int cameraGetWidth(long ctx) {
        try {
            int _ret_value_ = this.cameraGetWidth.invokeExact(ctx);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1;
        }
    }

    @Override
    public int cameraGetHeight(long ctx) {
        try {
            int _ret_value_ = this.cameraGetHeight.invokeExact(ctx);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1;
        }
    }

    private boolean ffm_init() {
        FFM ffm = FFM.getInstance();
        this.arena = Arena.ofAuto();
        MethodHandle init = ffm.getFunction("CameraAPIinit", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN));
        if (init == null) {
            return false;
        }
        try {
            if (!init.invokeExact()) {
                return false;
            }
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
        this.cameraInit = ffm.getFunctionPtr("_cameraInit", ffm.getFunctionDesciptor(ValueLayout.JAVA_LONG));
        this.cameraUninit = ffm.getFunctionPtr("_cameraUninit", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG));
        this.cameraListDevices = ffm.getFunctionPtr("_cameraListDevices", ffm.getFunctionDesciptor(ValueLayout.ADDRESS, ValueLayout.JAVA_LONG));
        this.cameraListModes = ffm.getFunctionPtr("_cameraListModes", ffm.getFunctionDesciptor(ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT));
        this.cameraStart = ffm.getFunctionPtr("_cameraStart", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.cameraStop = ffm.getFunctionPtr("_cameraStop", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG));
        this.cameraGetFrame = ffm.getFunctionPtr("_cameraGetFrame", ffm.getFunctionDesciptor(ValueLayout.ADDRESS, ValueLayout.JAVA_LONG));
        this.cameraGetWidth = ffm.getFunctionPtr("_cameraGetWidth", ffm.getFunctionDesciptor(ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG));
        this.cameraGetHeight = ffm.getFunctionPtr("_cameraGetHeight", ffm.getFunctionDesciptor(ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG));
        return true;
    }
}

