/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ffm;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Optional;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ffm.FFM;

public class ExecSymbolLookup
implements SymbolLookup {
    private MemorySegment handle;
    private MethodHandle getsymbol;
    private Arena arena;
    private static final int RTLD_LAZY = 1;
    private static final int RTLD_NOW = 2;
    private static final int RTLD_GLOBAL = 256;
    private static boolean debug = false;

    public boolean init(FFM ffm) {
        if (debug) {
            JFLog.log("ExecSymbolLookup init");
        }
        try {
            this.arena = Arena.global();
            if (JF.isWindows()) {
                SymbolLookup kernel32 = SymbolLookup.libraryLookup("kernel32", this.arena);
                ffm.setSymbolLookup(kernel32);
                MethodHandle GetModuleHandle = ffm.getFunction("GetModuleHandleA", ffm.getFunctionDesciptor(ValueLayout.ADDRESS, ValueLayout.ADDRESS));
                this.getsymbol = ffm.getFunction("GetProcAddress", ffm.getFunctionDesciptor(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
                try {
                    this.handle = GetModuleHandle.invokeExact(MemorySegment.NULL);
                }
                catch (Throwable t) {
                    JFLog.log(t);
                }
            } else {
                MethodHandle dlopen = ffm.getFunction("dlopen", ffm.getFunctionDesciptor(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
                if (debug) {
                    JFLog.log("dlopen=" + String.valueOf(dlopen));
                }
                this.getsymbol = ffm.getFunction("dlsym", ffm.getFunctionDesciptor(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
                if (debug) {
                    JFLog.log("getsymbol=" + String.valueOf(this.getsymbol));
                }
                try {
                    this.handle = dlopen.invokeExact(MemorySegment.NULL, 258);
                    if (debug) {
                        JFLog.log("handle=" + String.valueOf(this.handle));
                    }
                }
                catch (Throwable t) {
                    JFLog.log(t);
                }
            }
            ffm.setSymbolLookup(this);
            return true;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public Optional<MemorySegment> find(String name) {
        try {
            if (debug) {
                JFLog.log("lookup:name=" + name);
            }
            MemorySegment sym = this.getsymbol.invokeExact(this.handle, this.arena.allocateFrom(name));
            if (debug) {
                JFLog.log("lookup:sym=" + String.valueOf(sym));
            }
            return Optional.of(sym);
        }
        catch (Throwable t) {
            JFLog.log(t);
            return null;
        }
    }
}

