/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ffm;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import javaforce.JFLog;
import javaforce.ffm.ExecSymbolLookup;

public class FFM {
    private static FFM instance;
    private static boolean enabled;
    private static boolean debug;
    private Linker linker;
    private SymbolLookup lookup;
    private ExecSymbolLookup execlookup;
    private static MethodHandle jfArrayFree;
    private static final long JAVA_LONG_SIZE;
    private static final long JAVA_INT_SIZE;
    private static final long JAVA_SHORT_SIZE;
    private static final long JAVA_BYTE_SIZE;
    private static final long ADDRESS_SIZE;
    private static final long JFARRAY_HEADER_SIZE;

    public static FFM getInstance() {
        if (!enabled) {
            return null;
        }
        if (instance == null) {
            instance = new FFM();
        }
        return instance;
    }

    public static boolean enabled() {
        if (!enabled) {
            return false;
        }
        FFM.getInstance();
        return enabled;
    }

    public static void disable() {
        enabled = false;
    }

    public static void jfArrayFree(MemorySegment arr) {
        try {
            jfArrayFree.invokeExact(arr);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    private FFM() {
        try {
            this.linker = Linker.nativeLinker();
            this.lookup = this.linker.defaultLookup();
            this.execlookup = new ExecSymbolLookup();
            this.execlookup.init(this);
            jfArrayFree = this.getFunctionPtr("_jfArrayFree", this.getFunctionDesciptorVoid(ValueLayout.ADDRESS));
            if (jfArrayFree == null) {
                throw new Exception("FFM:Unable to find jfArrayFree function");
            }
        }
        catch (Throwable t) {
            JFLog.log(t);
            enabled = false;
        }
    }

    public void setSymbolLookup(SymbolLookup lookup) {
        if (debug) {
            JFLog.log("lookup=" + String.valueOf(lookup));
        }
        this.lookup = lookup;
    }

    public FunctionDescriptor getFunctionDesciptor(MemoryLayout ret) {
        return FunctionDescriptor.of(ret, new MemoryLayout[0]);
    }

    public FunctionDescriptor getFunctionDesciptor(MemoryLayout ret, MemoryLayout ... args) {
        return FunctionDescriptor.of(ret, args);
    }

    public FunctionDescriptor getFunctionDesciptorVoid(MemoryLayout ... args) {
        return FunctionDescriptor.ofVoid(args);
    }

    public MethodHandle getFunction(String name, FunctionDescriptor fd) {
        try {
            MemorySegment addr = this.lookup.findOrThrow(name);
            if (addr == null) {
                JFLog.log("FFM:Function not found(1):" + name + "=" + String.valueOf(addr));
                return null;
            }
            return this.linker.downcallHandle(addr, fd, new Linker.Option[0]);
        }
        catch (Exception e) {
            JFLog.logTrace("FFM:Function not found(e):" + name);
            return null;
        }
    }

    public MethodHandle getFunctionPtr(String name, FunctionDescriptor fd) {
        try {
            MemorySegment addr = this.lookup.findOrThrow(name);
            if (addr == null) {
                JFLog.log("FFM:FunctionPtr not found(1):" + name + "=" + String.valueOf(addr));
                return null;
            }
            if ((addr = addr.reinterpret(ADDRESS_SIZE)) == null) {
                JFLog.log("FFM:FunctionPtr not found(2):" + name + "=" + String.valueOf(addr));
                return null;
            }
            if ((addr = addr.get(ValueLayout.ADDRESS, 0L)) == null) {
                JFLog.log("FFM:FunctionPtr not found(3):" + name + "=" + String.valueOf(addr));
                return null;
            }
            return this.linker.downcallHandle(addr, fd, new Linker.Option[0]);
        }
        catch (Exception e) {
            JFLog.logTrace("FFM:FunctionPtr not found(e):" + name);
            return null;
        }
    }

    public static MemorySegment toMemory(Arena arena, float[] m) {
        if (m == null) {
            return MemorySegment.NULL;
        }
        return arena.allocateFrom(ValueLayout.JAVA_FLOAT, m);
    }

    public static MemorySegment toMemory(Arena arena, double[] m) {
        if (m == null) {
            return MemorySegment.NULL;
        }
        return arena.allocateFrom(ValueLayout.JAVA_DOUBLE, m);
    }

    public static MemorySegment toMemory(Arena arena, long[] m) {
        if (m == null) {
            return MemorySegment.NULL;
        }
        return arena.allocateFrom(ValueLayout.JAVA_LONG, m);
    }

    public static MemorySegment toMemory(Arena arena, int[] m) {
        if (m == null) {
            return MemorySegment.NULL;
        }
        return arena.allocateFrom(ValueLayout.JAVA_INT, m);
    }

    public static MemorySegment toMemory(Arena arena, short[] m) {
        if (m == null) {
            return MemorySegment.NULL;
        }
        return arena.allocateFrom(ValueLayout.JAVA_SHORT, m);
    }

    public static MemorySegment toMemory(Arena arena, byte[] m) {
        if (m == null) {
            return MemorySegment.NULL;
        }
        return arena.allocateFrom(ValueLayout.JAVA_BYTE, m);
    }

    public static MemorySegment toMemory(Arena arena, String[] strs) {
        if (strs == null) {
            return MemorySegment.NULL;
        }
        MemorySegment ptrs = arena.allocate(ValueLayout.ADDRESS, strs.length);
        int idx = 0;
        for (String str : strs) {
            MemorySegment ba = arena.allocateFrom(str);
            ptrs.setAtIndex(ValueLayout.ADDRESS, (long)idx++, ba);
        }
        return ptrs;
    }

    public static String[] toArrayString(MemorySegment m) {
        m = m.reinterpret(JFARRAY_HEADER_SIZE);
        int count = m.getAtIndex(ValueLayout.JAVA_INT, 0L);
        long size = JFARRAY_HEADER_SIZE + (long)count * ADDRESS_SIZE;
        MemorySegment arr = m.reinterpret(size).asSlice(JFARRAY_HEADER_SIZE, (long)count * ADDRESS_SIZE);
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = arr.getAtIndex(ValueLayout.ADDRESS, (long)i).reinterpret(Integer.MAX_VALUE).getString(0L);
        }
        FFM.jfArrayFree(m);
        return ret;
    }

    public static long[] toArrayLong(MemorySegment m) {
        m = m.reinterpret(JFARRAY_HEADER_SIZE);
        int count = m.getAtIndex(ValueLayout.JAVA_INT, 0L);
        long size = JFARRAY_HEADER_SIZE + (long)count * JAVA_LONG_SIZE;
        MemorySegment arr = m.reinterpret(size).asSlice(JFARRAY_HEADER_SIZE, (long)count * JAVA_LONG_SIZE);
        long[] ret = new long[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = arr.getAtIndex(ValueLayout.JAVA_LONG, (long)i);
        }
        FFM.jfArrayFree(m);
        return ret;
    }

    public static int[] toArrayInt(MemorySegment m) {
        m = m.reinterpret(JFARRAY_HEADER_SIZE);
        int count = m.getAtIndex(ValueLayout.JAVA_INT, 0L);
        long size = JFARRAY_HEADER_SIZE + (long)count * JAVA_INT_SIZE;
        MemorySegment arr = m.reinterpret(size).asSlice(JFARRAY_HEADER_SIZE, (long)count * JAVA_INT_SIZE);
        int[] ret = new int[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = arr.getAtIndex(ValueLayout.JAVA_INT, (long)i);
        }
        FFM.jfArrayFree(m);
        return ret;
    }

    public static short[] toArrayShort(MemorySegment m) {
        m = m.reinterpret(JFARRAY_HEADER_SIZE);
        int count = m.getAtIndex(ValueLayout.JAVA_INT, 0L);
        long size = JFARRAY_HEADER_SIZE + (long)count * JAVA_SHORT_SIZE;
        MemorySegment arr = m.reinterpret(size).asSlice(JFARRAY_HEADER_SIZE, (long)count * JAVA_SHORT_SIZE);
        short[] ret = new short[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = arr.getAtIndex(ValueLayout.JAVA_SHORT, (long)i);
        }
        FFM.jfArrayFree(m);
        return ret;
    }

    public static byte[] toArrayByte(MemorySegment m) {
        m = m.reinterpret(JFARRAY_HEADER_SIZE);
        int count = m.getAtIndex(ValueLayout.JAVA_INT, 0L);
        long size = JFARRAY_HEADER_SIZE + (long)count * JAVA_BYTE_SIZE;
        MemorySegment arr = m.reinterpret(size).asSlice(JFARRAY_HEADER_SIZE, (long)count * JAVA_BYTE_SIZE);
        byte[] ret = new byte[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = arr.getAtIndex(ValueLayout.JAVA_BYTE, (long)i);
        }
        FFM.jfArrayFree(m);
        return ret;
    }

    public static void copyBack(MemorySegment seg, float[] m) {
        if (seg == null || m == null) {
            return;
        }
        float[] r = seg.toArray(ValueLayout.JAVA_FLOAT);
        System.arraycopy(r, 0, m, 0, m.length);
    }

    public static void copyBack(MemorySegment seg, double[] m) {
        if (seg == null || m == null) {
            return;
        }
        double[] r = seg.toArray(ValueLayout.JAVA_DOUBLE);
        System.arraycopy(r, 0, m, 0, m.length);
    }

    public static void copyBack(MemorySegment seg, long[] m) {
        if (seg == null || m == null) {
            return;
        }
        long[] r = seg.toArray(ValueLayout.JAVA_LONG);
        System.arraycopy(r, 0, m, 0, m.length);
    }

    public static void copyBack(MemorySegment seg, int[] m) {
        if (seg == null || m == null) {
            return;
        }
        int[] r = seg.toArray(ValueLayout.JAVA_INT);
        System.arraycopy(r, 0, m, 0, m.length);
    }

    public static void copyBack(MemorySegment seg, short[] m) {
        if (seg == null || m == null) {
            return;
        }
        short[] r = seg.toArray(ValueLayout.JAVA_SHORT);
        System.arraycopy(r, 0, m, 0, m.length);
    }

    public static void copyBack(MemorySegment seg, byte[] m) {
        if (seg == null || m == null) {
            return;
        }
        byte[] r = seg.toArray(ValueLayout.JAVA_BYTE);
        System.arraycopy(r, 0, m, 0, m.length);
    }

    public static void copyBack(MemorySegment seg, String[] m) {
    }

    static {
        enabled = false;
        debug = false;
        JAVA_LONG_SIZE = ValueLayout.JAVA_LONG.byteSize();
        JAVA_INT_SIZE = ValueLayout.JAVA_INT.byteSize();
        JAVA_SHORT_SIZE = ValueLayout.JAVA_SHORT.byteSize();
        JAVA_BYTE_SIZE = ValueLayout.JAVA_BYTE.byteSize();
        ADDRESS_SIZE = ValueLayout.ADDRESS.byteSize();
        JFARRAY_HEADER_SIZE = JAVA_INT_SIZE * 2L;
    }
}

