/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ffm;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import javaforce.JFLog;
import javaforce.ffm.FFM;
import javaforce.gl.GL;

public class GLFFM
implements GL {
    private Arena arena;
    private static GLFFM instance;
    private MethodHandle glActiveTexture;
    private MethodHandle glAlphaFunc;
    private MethodHandle glAttachShader;
    private MethodHandle glBindBuffer;
    private MethodHandle glBindFramebuffer;
    private MethodHandle glBindRenderbuffer;
    private MethodHandle glBindTexture;
    private MethodHandle glBlendFunc;
    private MethodHandle glBufferData;
    private MethodHandle glClear;
    private MethodHandle glClearColor;
    private MethodHandle glColorMask;
    private MethodHandle glClearStencil;
    private MethodHandle glCompileShader;
    private MethodHandle glCreateProgram;
    private MethodHandle glCreateShader;
    private MethodHandle glCullFace;
    private MethodHandle glDeleteBuffers;
    private MethodHandle glDeleteFramebuffers;
    private MethodHandle glDeleteRenderbuffers;
    private MethodHandle glDeleteTextures;
    private MethodHandle glDrawElements;
    private MethodHandle glDepthFunc;
    private MethodHandle glDisable;
    private MethodHandle glDisableVertexAttribArray;
    private MethodHandle glDepthMask;
    private MethodHandle glEnable;
    private MethodHandle glEnableVertexAttribArray;
    private MethodHandle glFlush;
    private MethodHandle glFramebufferTexture2D;
    private MethodHandle glFramebufferRenderbuffer;
    private MethodHandle glFrontFace;
    private MethodHandle glGetAttribLocation;
    private MethodHandle glGetError;
    private MethodHandle glGetProgramInfoLog;
    private MethodHandle glGetShaderInfoLog;
    private MethodHandle glGetString;
    private MethodHandle glGetIntegerv;
    private MethodHandle glGenBuffers;
    private MethodHandle glGenFramebuffers;
    private MethodHandle glGenRenderbuffers;
    private MethodHandle glGenTextures;
    private MethodHandle glGetUniformLocation;
    private MethodHandle glLinkProgram;
    private MethodHandle glPixelStorei;
    private MethodHandle glReadPixels;
    private MethodHandle glRenderbufferStorage;
    private MethodHandle glShaderSource;
    private MethodHandle glStencilFunc;
    private MethodHandle glStencilMask;
    private MethodHandle glStencilOp;
    private MethodHandle glTexImage2D;
    private MethodHandle glTexSubImage2D;
    private MethodHandle glTexParameteri;
    private MethodHandle glUseProgram;
    private MethodHandle glUniformMatrix4fv;
    private MethodHandle glUniform4fv;
    private MethodHandle glUniform3fv;
    private MethodHandle glUniform2fv;
    private MethodHandle glUniform1f;
    private MethodHandle glUniform4iv;
    private MethodHandle glUniform3iv;
    private MethodHandle glUniform2iv;
    private MethodHandle glUniform1i;
    private MethodHandle glVertexAttribPointer;
    private MethodHandle glViewport;

    public static GLFFM getInstance() {
        if (instance == null && !(instance = new GLFFM()).ffm_init()) {
            JFLog.log("GLFFM init failed!");
            instance = null;
        }
        return instance;
    }

    @Override
    public void glActiveTexture(int i1) {
        try {
            this.glActiveTexture.invokeExact(i1);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glAlphaFunc(int i1, int i2) {
        try {
            this.glAlphaFunc.invokeExact(i1, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glAttachShader(int i1, int i2) {
        try {
            this.glAttachShader.invokeExact(i1, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glBindBuffer(int i1, int i2) {
        try {
            this.glBindBuffer.invokeExact(i1, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glBindFramebuffer(int i1, int i2) {
        try {
            this.glBindFramebuffer.invokeExact(i1, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glBindRenderbuffer(int i1, int i2) {
        try {
            this.glBindRenderbuffer.invokeExact(i1, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glBindTexture(int i1, int i2) {
        try {
            this.glBindTexture.invokeExact(i1, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glBlendFunc(int i1, int i2) {
        try {
            this.glBlendFunc.invokeExact(i1, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glBufferData(int i1, int i2, float[] i3, int i4) {
        MemorySegment _array_i3 = FFM.toMemory(this.arena, i3);
        try {
            this.glBufferData.invokeExact(i1, i2, _array_i3, i4);
            FFM.copyBack(_array_i3, i3);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glBufferData(int i1, int i2, short[] i3, int i4) {
        MemorySegment _array_i3 = FFM.toMemory(this.arena, i3);
        try {
            this.glBufferData.invokeExact(i1, i2, _array_i3, i4);
            FFM.copyBack(_array_i3, i3);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glBufferData(int i1, int i2, int[] i3, int i4) {
        MemorySegment _array_i3 = FFM.toMemory(this.arena, i3);
        try {
            this.glBufferData.invokeExact(i1, i2, _array_i3, i4);
            FFM.copyBack(_array_i3, i3);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glBufferData(int i1, int i2, byte[] i3, int i4) {
        MemorySegment _array_i3 = FFM.toMemory(this.arena, i3);
        try {
            this.glBufferData.invokeExact(i1, i2, _array_i3, i4);
            FFM.copyBack(_array_i3, i3);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glClear(int flags) {
        try {
            this.glClear.invokeExact(flags);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glClearColor(float r, float g, float b, float a) {
        try {
            this.glClearColor.invokeExact(r, g, b, a);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glColorMask(boolean r, boolean g, boolean b, boolean a) {
        try {
            this.glColorMask.invokeExact(r, g, b, a);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glClearStencil(int s) {
        try {
            this.glClearStencil.invokeExact(s);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glCompileShader(int id) {
        try {
            this.glCompileShader.invokeExact(id);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public int glCreateProgram() {
        try {
            int _ret_value_ = this.glCreateProgram.invokeExact();
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1;
        }
    }

    @Override
    public int glCreateShader(int type) {
        try {
            int _ret_value_ = this.glCreateShader.invokeExact(type);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1;
        }
    }

    @Override
    public void glCullFace(int id) {
        try {
            this.glCullFace.invokeExact(id);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glDeleteBuffers(int i1, int[] i2) {
        MemorySegment _array_i2 = FFM.toMemory(this.arena, i2);
        try {
            this.glDeleteBuffers.invokeExact(i1, _array_i2);
            FFM.copyBack(_array_i2, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glDeleteFramebuffers(int i1, int[] i2) {
        MemorySegment _array_i2 = FFM.toMemory(this.arena, i2);
        try {
            this.glDeleteFramebuffers.invokeExact(i1, _array_i2);
            FFM.copyBack(_array_i2, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glDeleteRenderbuffers(int i1, int[] i2) {
        MemorySegment _array_i2 = FFM.toMemory(this.arena, i2);
        try {
            this.glDeleteRenderbuffers.invokeExact(i1, _array_i2);
            FFM.copyBack(_array_i2, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glDeleteTextures(int i1, int[] i2) {
        MemorySegment _array_i2 = FFM.toMemory(this.arena, i2);
        try {
            this.glDeleteTextures.invokeExact(i1, _array_i2);
            FFM.copyBack(_array_i2, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glDrawElements(int i1, int i2, int i3, int i4) {
        try {
            this.glDrawElements.invokeExact(i1, i2, i3, i4);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glDepthFunc(int i1) {
        try {
            this.glDepthFunc.invokeExact(i1);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glDisable(int id) {
        try {
            this.glDisable.invokeExact(id);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glDisableVertexAttribArray(int id) {
        try {
            this.glDisableVertexAttribArray.invokeExact(id);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glDepthMask(boolean state) {
        try {
            this.glDepthMask.invokeExact(state);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glEnable(int id) {
        try {
            this.glEnable.invokeExact(id);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glEnableVertexAttribArray(int id) {
        try {
            this.glEnableVertexAttribArray.invokeExact(id);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glFlush() {
        try {
            this.glFlush.invokeExact();
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glFramebufferTexture2D(int i1, int i2, int i3, int i4, int i5) {
        try {
            this.glFramebufferTexture2D.invokeExact(i1, i2, i3, i4, i5);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glFramebufferRenderbuffer(int i1, int i2, int i3, int i4) {
        try {
            this.glFramebufferRenderbuffer.invokeExact(i1, i2, i3, i4);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glFrontFace(int id) {
        try {
            this.glFrontFace.invokeExact(id);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public int glGetAttribLocation(int i1, String str) {
        try {
            int _ret_value_ = this.glGetAttribLocation.invokeExact(i1, this.arena.allocateFrom(str));
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1;
        }
    }

    @Override
    public int glGetError() {
        try {
            int _ret_value_ = this.glGetError.invokeExact();
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1;
        }
    }

    @Override
    public String glGetProgramInfoLog(int id) {
        try {
            String _ret_value_ = this.glGetProgramInfoLog.invokeExact(id).reinterpret(Long.MAX_VALUE).getString(0L);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return null;
        }
    }

    @Override
    public String glGetShaderInfoLog(int id) {
        try {
            String _ret_value_ = this.glGetShaderInfoLog.invokeExact(id).reinterpret(Long.MAX_VALUE).getString(0L);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return null;
        }
    }

    @Override
    public String glGetString(int type) {
        try {
            String _ret_value_ = this.glGetString.invokeExact(type).reinterpret(Long.MAX_VALUE).getString(0L);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return null;
        }
    }

    @Override
    public void glGetIntegerv(int type, int[] i) {
        MemorySegment _array_i = FFM.toMemory(this.arena, i);
        try {
            this.glGetIntegerv.invokeExact(type, _array_i);
            FFM.copyBack(_array_i, i);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glGenBuffers(int i1, int[] i2) {
        MemorySegment _array_i2 = FFM.toMemory(this.arena, i2);
        try {
            this.glGenBuffers.invokeExact(i1, _array_i2);
            FFM.copyBack(_array_i2, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glGenFramebuffers(int i1, int[] i2) {
        MemorySegment _array_i2 = FFM.toMemory(this.arena, i2);
        try {
            this.glGenFramebuffers.invokeExact(i1, _array_i2);
            FFM.copyBack(_array_i2, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glGenRenderbuffers(int i1, int[] i2) {
        MemorySegment _array_i2 = FFM.toMemory(this.arena, i2);
        try {
            this.glGenRenderbuffers.invokeExact(i1, _array_i2);
            FFM.copyBack(_array_i2, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glGenTextures(int i1, int[] i2) {
        MemorySegment _array_i2 = FFM.toMemory(this.arena, i2);
        try {
            this.glGenTextures.invokeExact(i1, _array_i2);
            FFM.copyBack(_array_i2, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public int glGetUniformLocation(int i1, String str) {
        try {
            int _ret_value_ = this.glGetUniformLocation.invokeExact(i1, this.arena.allocateFrom(str));
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1;
        }
    }

    @Override
    public void glLinkProgram(int id) {
        try {
            this.glLinkProgram.invokeExact(id);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glPixelStorei(int i1, int i2) {
        try {
            this.glPixelStorei.invokeExact(i1, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glReadPixels(int i1, int i2, int i3, int i4, int i5, int i6, int[] px) {
        MemorySegment _array_px = FFM.toMemory(this.arena, px);
        try {
            this.glReadPixels.invokeExact(i1, i2, i3, i4, i5, i6, _array_px);
            FFM.copyBack(_array_px, px);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glRenderbufferStorage(int i1, int i2, int i3, int i4) {
        try {
            this.glRenderbufferStorage.invokeExact(i1, i2, i3, i4);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public int glShaderSource(int type, int count, String[] src, int[] src_lengths) {
        MemorySegment _array_src = FFM.toMemory(this.arena, src);
        MemorySegment _array_src_lengths = FFM.toMemory(this.arena, src_lengths);
        try {
            int _ret_value_ = this.glShaderSource.invokeExact(type, count, _array_src, _array_src_lengths);
            FFM.copyBack(_array_src, src);
            FFM.copyBack(_array_src_lengths, src_lengths);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1;
        }
    }

    @Override
    public int glStencilFunc(int func, int ref, int mask) {
        try {
            int _ret_value_ = this.glStencilFunc.invokeExact(func, ref, mask);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1;
        }
    }

    @Override
    public int glStencilMask(int mask) {
        try {
            int _ret_value_ = this.glStencilMask.invokeExact(mask);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1;
        }
    }

    @Override
    public int glStencilOp(int sfail, int dpfail, int dppass) {
        try {
            int _ret_value_ = this.glStencilOp.invokeExact(sfail, dpfail, dppass);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1;
        }
    }

    @Override
    public void glTexImage2D(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8, int[] px) {
        MemorySegment _array_px = FFM.toMemory(this.arena, px);
        try {
            this.glTexImage2D.invokeExact(i1, i2, i3, i4, i5, i6, i7, i8, _array_px);
            FFM.copyBack(_array_px, px);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glTexSubImage2D(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8, int[] px) {
        MemorySegment _array_px = FFM.toMemory(this.arena, px);
        try {
            this.glTexSubImage2D.invokeExact(i1, i2, i3, i4, i5, i6, i7, i8, _array_px);
            FFM.copyBack(_array_px, px);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glTexParameteri(int i1, int i2, int i3) {
        try {
            this.glTexParameteri.invokeExact(i1, i2, i3);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glUseProgram(int id) {
        try {
            this.glUseProgram.invokeExact(id);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glUniformMatrix4fv(int i1, int i2, int i3, float[] m) {
        MemorySegment _array_m = FFM.toMemory(this.arena, m);
        try {
            this.glUniformMatrix4fv.invokeExact(i1, i2, i3, _array_m);
            FFM.copyBack(_array_m, m);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glUniform4fv(int i1, int i2, float[] f) {
        MemorySegment _array_f = FFM.toMemory(this.arena, f);
        try {
            this.glUniform4fv.invokeExact(i1, i2, _array_f);
            FFM.copyBack(_array_f, f);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glUniform3fv(int i1, int i2, float[] f) {
        MemorySegment _array_f = FFM.toMemory(this.arena, f);
        try {
            this.glUniform3fv.invokeExact(i1, i2, _array_f);
            FFM.copyBack(_array_f, f);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glUniform2fv(int i1, int i2, float[] f) {
        MemorySegment _array_f = FFM.toMemory(this.arena, f);
        try {
            this.glUniform2fv.invokeExact(i1, i2, _array_f);
            FFM.copyBack(_array_f, f);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glUniform1f(int i1, float f) {
        try {
            this.glUniform1f.invokeExact(i1, f);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glUniform4iv(int i1, int i2, int[] v) {
        MemorySegment _array_v = FFM.toMemory(this.arena, v);
        try {
            this.glUniform4iv.invokeExact(i1, i2, _array_v);
            FFM.copyBack(_array_v, v);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glUniform3iv(int i1, int i2, int[] v) {
        MemorySegment _array_v = FFM.toMemory(this.arena, v);
        try {
            this.glUniform3iv.invokeExact(i1, i2, _array_v);
            FFM.copyBack(_array_v, v);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glUniform2iv(int i1, int i2, int[] v) {
        MemorySegment _array_v = FFM.toMemory(this.arena, v);
        try {
            this.glUniform2iv.invokeExact(i1, i2, _array_v);
            FFM.copyBack(_array_v, v);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glUniform1i(int i1, int i2) {
        try {
            this.glUniform1i.invokeExact(i1, i2);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glVertexAttribPointer(int i1, int i2, int i3, int i4, int i5, int i6) {
        try {
            this.glVertexAttribPointer.invokeExact(i1, i2, i3, i4, i5, i6);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public void glViewport(int x, int y, int w, int h) {
        try {
            this.glViewport.invokeExact(x, y, w, h);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    private boolean ffm_init() {
        FFM ffm = FFM.getInstance();
        this.arena = Arena.ofAuto();
        MethodHandle init = ffm.getFunction("GLinit", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN));
        if (init == null) {
            return false;
        }
        try {
            if (!init.invokeExact()) {
                return false;
            }
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
        this.glActiveTexture = ffm.getFunctionPtr("_glActiveTexture", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glAlphaFunc = ffm.getFunctionPtr("_glAlphaFunc", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glAttachShader = ffm.getFunctionPtr("_glAttachShader", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glBindBuffer = ffm.getFunctionPtr("_glBindBuffer", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glBindFramebuffer = ffm.getFunctionPtr("_glBindFramebuffer", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glBindRenderbuffer = ffm.getFunctionPtr("_glBindRenderbuffer", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glBindTexture = ffm.getFunctionPtr("_glBindTexture", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glBlendFunc = ffm.getFunctionPtr("_glBlendFunc", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glBufferData = ffm.getFunctionPtr("_glBufferData", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        this.glClear = ffm.getFunctionPtr("_glClear", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glClearColor = ffm.getFunctionPtr("_glClearColor", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_FLOAT, ValueLayout.JAVA_FLOAT, ValueLayout.JAVA_FLOAT, ValueLayout.JAVA_FLOAT));
        this.glColorMask = ffm.getFunctionPtr("_glColorMask", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_BOOLEAN));
        this.glClearStencil = ffm.getFunctionPtr("_glClearStencil", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glCompileShader = ffm.getFunctionPtr("_glCompileShader", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glCreateProgram = ffm.getFunctionPtr("_glCreateProgram", ffm.getFunctionDesciptor(ValueLayout.JAVA_INT));
        this.glCreateShader = ffm.getFunctionPtr("_glCreateShader", ffm.getFunctionDesciptor(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glCullFace = ffm.getFunctionPtr("_glCullFace", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glDeleteBuffers = ffm.getFunctionPtr("_glDeleteBuffers", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glDeleteFramebuffers = ffm.getFunctionPtr("_glDeleteFramebuffers", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glDeleteRenderbuffers = ffm.getFunctionPtr("_glDeleteRenderbuffers", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glDeleteTextures = ffm.getFunctionPtr("_glDeleteTextures", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glDrawElements = ffm.getFunctionPtr("_glDrawElements", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glDepthFunc = ffm.getFunctionPtr("_glDepthFunc", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glDisable = ffm.getFunctionPtr("_glDisable", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glDisableVertexAttribArray = ffm.getFunctionPtr("_glDisableVertexAttribArray", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glDepthMask = ffm.getFunctionPtr("_glDepthMask", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_BOOLEAN));
        this.glEnable = ffm.getFunctionPtr("_glEnable", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glEnableVertexAttribArray = ffm.getFunctionPtr("_glEnableVertexAttribArray", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glFlush = ffm.getFunctionPtr("_glFlush", ffm.getFunctionDesciptorVoid(new MemoryLayout[0]));
        this.glFramebufferTexture2D = ffm.getFunctionPtr("_glFramebufferTexture2D", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glFramebufferRenderbuffer = ffm.getFunctionPtr("_glFramebufferRenderbuffer", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glFrontFace = ffm.getFunctionPtr("_glFrontFace", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glGetAttribLocation = ffm.getFunctionPtr("_glGetAttribLocation", ffm.getFunctionDesciptor(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glGetError = ffm.getFunctionPtr("_glGetError", ffm.getFunctionDesciptor(ValueLayout.JAVA_INT));
        this.glGetProgramInfoLog = ffm.getFunctionPtr("_glGetProgramInfoLog", ffm.getFunctionDesciptor(ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        this.glGetShaderInfoLog = ffm.getFunctionPtr("_glGetShaderInfoLog", ffm.getFunctionDesciptor(ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        this.glGetString = ffm.getFunctionPtr("_glGetString", ffm.getFunctionDesciptor(ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        this.glGetIntegerv = ffm.getFunctionPtr("_glGetIntegerv", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glGenBuffers = ffm.getFunctionPtr("_glGenBuffers", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glGenFramebuffers = ffm.getFunctionPtr("_glGenFramebuffers", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glGenRenderbuffers = ffm.getFunctionPtr("_glGenRenderbuffers", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glGenTextures = ffm.getFunctionPtr("_glGenTextures", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glGetUniformLocation = ffm.getFunctionPtr("_glGetUniformLocation", ffm.getFunctionDesciptor(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glLinkProgram = ffm.getFunctionPtr("_glLinkProgram", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glPixelStorei = ffm.getFunctionPtr("_glPixelStorei", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glReadPixels = ffm.getFunctionPtr("_glReadPixels", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glRenderbufferStorage = ffm.getFunctionPtr("_glRenderbufferStorage", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glShaderSource = ffm.getFunctionPtr("_glShaderSource", ffm.getFunctionDesciptor(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
        this.glStencilFunc = ffm.getFunctionPtr("_glStencilFunc", ffm.getFunctionDesciptor(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glStencilMask = ffm.getFunctionPtr("_glStencilMask", ffm.getFunctionDesciptor(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glStencilOp = ffm.getFunctionPtr("_glStencilOp", ffm.getFunctionDesciptor(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glTexImage2D = ffm.getFunctionPtr("_glTexImage2D", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glTexSubImage2D = ffm.getFunctionPtr("_glTexSubImage2D", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glTexParameteri = ffm.getFunctionPtr("_glTexParameteri", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glUseProgram = ffm.getFunctionPtr("_glUseProgram", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT));
        this.glUniformMatrix4fv = ffm.getFunctionPtr("_glUniformMatrix4fv", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glUniform4fv = ffm.getFunctionPtr("_glUniform4fv", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glUniform3fv = ffm.getFunctionPtr("_glUniform3fv", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glUniform2fv = ffm.getFunctionPtr("_glUniform2fv", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glUniform1f = ffm.getFunctionPtr("_glUniform1f", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_FLOAT));
        this.glUniform4iv = ffm.getFunctionPtr("_glUniform4iv", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glUniform3iv = ffm.getFunctionPtr("_glUniform3iv", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glUniform2iv = ffm.getFunctionPtr("_glUniform2iv", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        this.glUniform1i = ffm.getFunctionPtr("_glUniform1i", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glVertexAttribPointer = ffm.getFunctionPtr("_glVertexAttribPointer", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        this.glViewport = ffm.getFunctionPtr("_glViewport", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        return true;
    }
}

