/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ffm;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javaforce.JFLog;

public class JNI2FFM {
    public static void main(String[] args) {
        String[] lns;
        if (args.length != 5) {
            System.out.println("Usage: JNI2FFM filein.java fileout.java package implements_extends baseclass");
            return;
        }
        String fin = args[0].replaceAll("\\\\", "/");
        String fout = args[1].replaceAll("\\\\", "/");
        String pack = args[2];
        String i_e = args[3];
        String basecls = args[4];
        System.out.println("Converting " + fin + " to " + fout);
        String cls_in = fin;
        int idx = fin.lastIndexOf(47);
        if (idx != -1) {
            cls_in = fin.substring(idx + 1);
        }
        idx = cls_in.indexOf(46);
        cls_in = cls_in.substring(0, idx);
        String cls_out = fout;
        idx = fout.lastIndexOf(47);
        if (idx != -1) {
            cls_out = fout.substring(idx + 1);
        }
        idx = cls_out.indexOf(46);
        cls_out = cls_out.substring(0, idx);
        StringBuilder src = new StringBuilder();
        StringBuilder ctor = new StringBuilder();
        ArrayList<String> funcs = new ArrayList<String>();
        try {
            FileInputStream fis = new FileInputStream(fin);
            lns = new String(fis.readAllBytes()).split("\n");
        }
        catch (Exception e) {
            JFLog.log(e);
            return;
        }
        try {
            src.append("package javaforce.ffm;\n");
            src.append("\n");
            src.append("/** " + basecls + " FFM implementation.\n");
            src.append(" * NON-AI MACHINE GENERATED CODE - DO NOT EDIT\n");
            src.append(" */\n");
            src.append("\n");
            src.append("import java.lang.foreign.*;\n");
            src.append("import java.lang.invoke.*;\n");
            src.append("import static java.lang.foreign.ValueLayout.*;\n");
            src.append("\n");
            src.append("import javaforce.*;\n");
            src.append("import javaforce.ffm.*;\n");
            src.append("import javaforce." + pack + ".*;\n");
            src.append("\n");
            src.append("public class " + cls_out + " " + i_e + " " + basecls + " {\n");
            src.append("\n");
            src.append("  private Arena arena;\n");
            src.append("\n");
            src.append("  private static " + cls_out + " instance;\n");
            src.append("  public static " + cls_out + " getInstance() {\n");
            src.append("    if (instance == null) {\n");
            src.append("      instance = new " + cls_out + "();\n");
            src.append("      if (!instance.ffm_init()) {\n");
            src.append("        JFLog.log(\"" + cls_out + " init failed!\");\n");
            src.append("        instance = null;\n");
            src.append("      }\n");
            src.append("    }\n");
            src.append("    return instance;\n");
            src.append("  }\n");
            src.append("\n");
            ctor.append("  private boolean ffm_init() {\n");
            ctor.append("    MethodHandle init;\n");
            ctor.append("    FFM ffm = FFM.getInstance();\n");
            ctor.append("    arena = Arena.ofAuto();\n");
            ctor.append("    init = ffm.getFunction(\"" + basecls + "init\", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN));\n");
            ctor.append("    if (init == null) return false;\n");
            ctor.append("    try {if (!(boolean)init.invokeExact()) return false;} catch (Throwable t) {JFLog.log(t); return false;}\n");
            ctor.append("\n");
            for (String ln : lns) {
                if (!(ln = ln.trim()).startsWith("public native")) continue;
                ln = ln.substring(14, ln.length() - 1);
                idx = ln.indexOf(32);
                String java_ret_type = ln.substring(0, idx);
                Object ValueLayout_ret_type = null;
                ValueLayout_ret_type = java_ret_type.equals("String") ? "ADDRESS" : "JAVA_" + java_ret_type.toUpperCase();
                boolean isRetVoid = java_ret_type.equals("void");
                boolean isRetArray = java_ret_type.endsWith("[]");
                if (isRetArray) {
                    java_ret_type = java_ret_type.substring(0, java_ret_type.length() - 2);
                }
                ln = ln.substring(idx + 1);
                idx = ln.indexOf(40);
                String func_name = ln.substring(0, idx);
                boolean isDup = false;
                if (funcs.contains(func_name)) {
                    isDup = true;
                } else {
                    funcs.add(func_name);
                }
                String func_args = ln.substring(idx);
                String[] pairs = func_args.substring(1, func_args.length() - 1).split(",");
                if (!isDup) {
                    src.append("  private MethodHandle " + func_name + ";\n");
                }
                src.append("  public " + java_ret_type);
                if (isRetArray) {
                    src.append("[]");
                }
                src.append(" " + func_name + "(");
                StringBuilder ctor2 = new StringBuilder();
                StringBuilder method = new StringBuilder();
                StringBuilder arrays = new StringBuilder();
                method.append("{ try { ");
                if (!isRetVoid) {
                    if (isRetArray) {
                        method.append(java_ret_type + "[] _ret_value_ = FFM.toArray" + JNI2FFM.capitalize(java_ret_type) + "((MemorySegment)");
                    } else if (java_ret_type.equals("String")) {
                        method.append("String _ret_value_ = ((MemorySegment)");
                    } else {
                        method.append(java_ret_type + " _ret_value_ = (" + java_ret_type + ")");
                    }
                }
                method.append(func_name);
                method.append(".invokeExact(");
                ctor2.append("    " + func_name + " = ffm.getFunctionPtr(\"_" + func_name + "\", ffm.getFunctionDesciptor");
                boolean first = true;
                boolean first_ctor = true;
                if (isRetVoid) {
                    ctor2.append("Void(");
                } else {
                    ctor2.append("(");
                    if (isRetArray) {
                        ctor2.append("ADDRESS");
                    } else {
                        ctor2.append((String)ValueLayout_ret_type);
                    }
                    first_ctor = false;
                }
                ArrayList<String> array_names = new ArrayList<String>();
                for (String pair : pairs) {
                    if ((pair = pair.trim()).length() == 0) continue;
                    idx = pair.indexOf(32);
                    String java_type = pair.substring(0, idx);
                    Object ValueLayout_type = null;
                    String arg_name = pair.substring(idx + 1);
                    boolean isArray = false;
                    String array_type = null;
                    if (java_type.endsWith("[]")) {
                        isArray = true;
                        String base_type = java_type.substring(0, java_type.length() - 2);
                        ValueLayout_type = "ADDRESS";
                        array_type = "JAVA_" + base_type.toUpperCase();
                    } else {
                        ValueLayout_type = java_type.equals("String") ? "ADDRESS" : "JAVA_" + java_type.toUpperCase();
                    }
                    if (first) {
                        first = false;
                    } else {
                        src.append(",");
                        method.append(",");
                    }
                    if (first_ctor) {
                        first_ctor = false;
                    } else {
                        ctor2.append(",");
                    }
                    src.append(java_type + " " + arg_name);
                    if (isArray) {
                        array_names.add(arg_name);
                        String segment_name = "_array_" + arg_name;
                        arrays.append("MemorySegment " + segment_name + " = FFM.toMemory(arena, " + arg_name + ");");
                        method.append(segment_name);
                    } else if (java_type.equals("String")) {
                        method.append("arena.allocateFrom(" + arg_name + ")");
                    } else {
                        method.append(arg_name);
                    }
                    ctor2.append((String)ValueLayout_type);
                }
                if (isRetArray) {
                    method.append("));");
                } else if (java_ret_type.equals("String")) {
                    method.append(")).reinterpret(Long.MAX_VALUE).getString(0L);");
                } else {
                    method.append(");");
                }
                method.insert(1, arrays);
                for (String arg_name : array_names) {
                    String segment_name = "_array_" + arg_name;
                    method.append("FFM.copyBack(" + segment_name + "," + arg_name + ");");
                }
                if (!isRetVoid) {
                    method.append("return _ret_value_;");
                }
                method.append(" } catch (Throwable t) { JFLog.log(t); ");
                if (!isRetVoid) {
                    method.append(" return ");
                    if (isRetArray) {
                        method.append("null");
                    } else {
                        switch (java_ret_type) {
                            case "String": {
                                method.append("null");
                                break;
                            }
                            case "boolean": {
                                method.append("false");
                                break;
                            }
                            default: {
                                method.append("-1");
                            }
                        }
                    }
                    method.append(";");
                }
                method.append("} }\n");
                src.append(") ");
                src.append((CharSequence)method);
                src.append("\n");
                ctor2.append("));\n");
                if (isDup) continue;
                ctor.append((CharSequence)ctor2);
            }
            ctor.append("    return true;\n");
            ctor.append("  }\n");
            src.append("\n");
            src.append((CharSequence)ctor);
            src.append("}\n");
        }
        catch (Exception e) {
            JFLog.log(e);
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(fout);
            fos.write(src.toString().getBytes());
            fos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
            return;
        }
    }

    private static String capitalize(String in) {
        char first_cap = Character.toUpperCase(in.charAt(0));
        return first_cap + in.substring(1);
    }
}

