/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ffm;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import javaforce.JFLog;
import javaforce.api.PCapAPI;
import javaforce.ffm.FFM;

public class PCapFFM
implements PCapAPI {
    private Arena arena;
    private static PCapFFM instance;
    private MethodHandle pcapInit;
    private MethodHandle pcapListLocalInterfaces;
    private MethodHandle pcapStart;
    private MethodHandle pcapStop;
    private MethodHandle pcapCompile;
    private MethodHandle pcapRead;
    private MethodHandle pcapWrite;

    public static PCapFFM getInstance() {
        if (instance == null && !(instance = new PCapFFM()).ffm_init()) {
            JFLog.log("PCapFFM init failed!");
            instance = null;
        }
        return instance;
    }

    @Override
    public boolean pcapInit(String lib1, String lib2) {
        try {
            boolean _ret_value_ = this.pcapInit.invokeExact(this.arena.allocateFrom(lib1), this.arena.allocateFrom(lib2));
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public String[] pcapListLocalInterfaces() {
        try {
            String[] _ret_value_ = FFM.toArrayString(this.pcapListLocalInterfaces.invokeExact());
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return null;
        }
    }

    @Override
    public long pcapStart(String local_interface, boolean nonblocking) {
        try {
            long _ret_value_ = this.pcapStart.invokeExact(this.arena.allocateFrom(local_interface), nonblocking);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return -1L;
        }
    }

    @Override
    public void pcapStop(long id) {
        try {
            this.pcapStop.invokeExact(id);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }

    @Override
    public boolean pcapCompile(long handle, String program) {
        try {
            boolean _ret_value_ = this.pcapCompile.invokeExact(handle, this.arena.allocateFrom(program));
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    @Override
    public byte[] pcapRead(long handle) {
        try {
            byte[] _ret_value_ = FFM.toArrayByte(this.pcapRead.invokeExact(handle));
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return null;
        }
    }

    @Override
    public boolean pcapWrite(long handle, byte[] packet, int offset, int length) {
        MemorySegment _array_packet = FFM.toMemory(this.arena, packet);
        try {
            boolean _ret_value_ = this.pcapWrite.invokeExact(handle, _array_packet, offset, length);
            FFM.copyBack(_array_packet, packet);
            return _ret_value_;
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
    }

    private boolean ffm_init() {
        FFM ffm = FFM.getInstance();
        this.arena = Arena.ofAuto();
        MethodHandle init = ffm.getFunction("PCapAPIinit", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN));
        if (init == null) {
            return false;
        }
        try {
            if (!init.invokeExact()) {
                return false;
            }
        }
        catch (Throwable t) {
            JFLog.log(t);
            return false;
        }
        this.pcapInit = ffm.getFunctionPtr("_pcapInit", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
        this.pcapListLocalInterfaces = ffm.getFunctionPtr("_pcapListLocalInterfaces", ffm.getFunctionDesciptor(ValueLayout.ADDRESS));
        this.pcapStart = ffm.getFunctionPtr("_pcapStart", ffm.getFunctionDesciptor(ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_BOOLEAN));
        this.pcapStop = ffm.getFunctionPtr("_pcapStop", ffm.getFunctionDesciptorVoid(ValueLayout.JAVA_LONG));
        this.pcapCompile = ffm.getFunctionPtr("_pcapCompile", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS));
        this.pcapRead = ffm.getFunctionPtr("_pcapRead", ffm.getFunctionDesciptor(ValueLayout.ADDRESS, ValueLayout.JAVA_LONG));
        this.pcapWrite = ffm.getFunctionPtr("_pcapWrite", ffm.getFunctionDesciptor(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        return true;
    }
}

