/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import javaforce.JFLog;
import javaforce.ffm.FFM;
import javaforce.ffm.GLFFM;
import javaforce.jni.GLJNI;

public interface GL {
    public static final boolean debug = false;
    public static final int GL_VERSION = 7938;
    public static final int GL_MAX_TEXTURE_SIZE = 3379;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_CW = 2304;
    public static final int GL_CCW = 2305;
    public static final int GL_CULL_FACE = 2884;
    public static final int GL_BLEND = 3042;
    public static final int GL_DEPTH_TEST = 2929;
    public static final int GL_NEVER = 512;
    public static final int GL_LESS = 513;
    public static final int GL_EQUAL = 514;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_NOTEQUAL = 517;
    public static final int GL_GEQUAL = 518;
    public static final int GL_ALWAYS = 519;
    public static final int GL_SRC_COLOR = 768;
    public static final int GL_ONE_MINUS_SRC_COLOR = 769;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_DST_ALPHA = 772;
    public static final int GL_ONE_MINUS_DST_ALPHA = 773;
    public static final int GL_DST_COLOR = 774;
    public static final int GL_ONE_MINUS_DST_COLOR = 775;
    public static final int GL_SRC_ALPHA_SATURATE = 776;
    public static final int GL_UNPACK_ALIGNMENT = 3317;
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_REPEAT = 10497;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_NEAREST = 9728;
    public static final int GL_TEXTURE_ENV = 8960;
    public static final int GL_TEXTURE_ENV_MODE = 8704;
    public static final int GL_MODULATE = 8448;
    public static final int GL_RGBA = 6408;
    public static final int GL_BGRA = 32993;
    public static final int GL_RGBA8 = 32856;
    public static final int GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_STENCIL_BUFFER_BIT = 1024;
    public static final int GL_STENCIL_TEST = 2960;
    public static final int GL_STENCIL_CLEAR_VALUE = 2961;
    public static final int GL_STENCIL_FUNC = 2962;
    public static final int GL_STENCIL_VALUE_MASK = 2963;
    public static final int GL_STENCIL_FAIL = 2964;
    public static final int GL_STENCIL_PASS_DEPTH_FAIL = 2965;
    public static final int GL_STENCIL_PASS_DEPTH_PASS = 2966;
    public static final int GL_STENCIL_REF = 2967;
    public static final int GL_STENCIL_WRITEMASK = 2968;
    public static final int GL_ALPHA_TEST = 3008;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_FLOAT = 5126;
    public static final int GL_FALSE = 0;
    public static final int GL_TRUE = 1;
    public static final int GL_ZERO = 0;
    public static final int GL_ONE = 1;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_UNSIGNED_SHORT = 5123;
    public static final int GL_UNSIGNED_INT = 5125;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int GL_QUADS = 7;
    public static final int GL_QUAD_STRIP = 8;
    public static final int GL_POLYGON = 9;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_TEXTURE0 = 33984;
    public static final int GL_FRAMEBUFFER = 36160;
    public static final int GL_READ_FRAMEBUFFER = 36008;
    public static final int GL_DRAW_FRAMEBUFFER = 36009;
    public static final int GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL_DEPTH_COMPONENT16 = 33189;
    public static final int GL_DEPTH_COMPONENT24 = 33190;
    public static final int GL_DEPTH_COMPONENT32 = 33191;
    public static final int GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL_RENDERBUFFER = 36161;
    public static final int GL_FRONT = 1028;
    public static final int GL_BACK = 1029;
    public static final int GL_FRONT_AND_BACK = 1032;

    public static GL getInstance() {
        if (FFM.enabled()) {
            return GLFFM.getInstance();
        }
        return GLJNI.getInstance();
    }

    public static int[] getVersion() {
        GL gl = GL.getInstance();
        String str = gl.glGetString(7938);
        if (str == null) {
            JFLog.log("Error:glGetString returned NULL");
            return new int[]{0, 0};
        }
        int idx = str.indexOf(" ");
        if (idx != -1) {
            str = str.substring(0, idx);
        }
        String[] parts = str.split("[.]");
        int[] ret = new int[parts.length];
        for (int a = 0; a < parts.length; ++a) {
            ret[a] = Integer.valueOf(parts[a]);
        }
        return ret;
    }

    public static void printError(String msg) {
        int err;
        GL gl = GL.getInstance();
        do {
            err = gl.glGetError();
            System.out.println(msg + "=" + String.format("%x", err));
        } while (err != 0);
    }

    public static void printError() {
        GL.printError("err");
    }

    public static void clear(int clr, int width, int height) {
        GL gl = GL.getInstance();
        float r = (clr & 0xFF0000) >> 16;
        float g = (clr & 0xFF00) >> 8;
        float b = clr & 0xFF;
        gl.glViewport(0, 0, width, height);
        gl.glClearColor(r /= 256.0f, g /= 256.0f, b /= 256.0f, 0.0f);
        gl.glClear(17664);
    }

    public void glActiveTexture(int var1);

    public void glAlphaFunc(int var1, int var2);

    public void glAttachShader(int var1, int var2);

    public void glBindBuffer(int var1, int var2);

    public void glBindFramebuffer(int var1, int var2);

    public void glBindRenderbuffer(int var1, int var2);

    public void glBindTexture(int var1, int var2);

    public void glBlendFunc(int var1, int var2);

    public void glBufferData(int var1, int var2, float[] var3, int var4);

    public void glBufferData(int var1, int var2, short[] var3, int var4);

    public void glBufferData(int var1, int var2, int[] var3, int var4);

    public void glBufferData(int var1, int var2, byte[] var3, int var4);

    public void glClear(int var1);

    public void glClearColor(float var1, float var2, float var3, float var4);

    public void glColorMask(boolean var1, boolean var2, boolean var3, boolean var4);

    public void glClearStencil(int var1);

    public void glCompileShader(int var1);

    public int glCreateProgram();

    public int glCreateShader(int var1);

    public void glCullFace(int var1);

    public void glDeleteBuffers(int var1, int[] var2);

    public void glDeleteFramebuffers(int var1, int[] var2);

    public void glDeleteRenderbuffers(int var1, int[] var2);

    public void glDeleteTextures(int var1, int[] var2);

    public void glDrawElements(int var1, int var2, int var3, int var4);

    public void glDepthFunc(int var1);

    public void glDisable(int var1);

    public void glDisableVertexAttribArray(int var1);

    public void glDepthMask(boolean var1);

    public void glEnable(int var1);

    public void glEnableVertexAttribArray(int var1);

    public void glFlush();

    public void glFramebufferTexture2D(int var1, int var2, int var3, int var4, int var5);

    public void glFramebufferRenderbuffer(int var1, int var2, int var3, int var4);

    public void glFrontFace(int var1);

    public int glGetAttribLocation(int var1, String var2);

    public int glGetError();

    public String glGetProgramInfoLog(int var1);

    public String glGetShaderInfoLog(int var1);

    public String glGetString(int var1);

    public void glGetIntegerv(int var1, int[] var2);

    public void glGenBuffers(int var1, int[] var2);

    public void glGenFramebuffers(int var1, int[] var2);

    public void glGenRenderbuffers(int var1, int[] var2);

    public void glGenTextures(int var1, int[] var2);

    public int glGetUniformLocation(int var1, String var2);

    public void glLinkProgram(int var1);

    public void glPixelStorei(int var1, int var2);

    public void glReadPixels(int var1, int var2, int var3, int var4, int var5, int var6, int[] var7);

    public void glRenderbufferStorage(int var1, int var2, int var3, int var4);

    public int glShaderSource(int var1, int var2, String[] var3, int[] var4);

    public int glStencilFunc(int var1, int var2, int var3);

    public int glStencilMask(int var1);

    public int glStencilOp(int var1, int var2, int var3);

    public void glTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int[] var9);

    public void glTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int[] var9);

    public void glTexParameteri(int var1, int var2, int var3);

    public void glUseProgram(int var1);

    public void glUniformMatrix4fv(int var1, int var2, int var3, float[] var4);

    public void glUniform4fv(int var1, int var2, float[] var3);

    public void glUniform3fv(int var1, int var2, float[] var3);

    public void glUniform2fv(int var1, int var2, float[] var3);

    public void glUniform1f(int var1, float var2);

    public void glUniform4iv(int var1, int var2, int[] var3);

    public void glUniform3iv(int var1, int var2, int[] var3);

    public void glUniform2iv(int var1, int var2, int[] var3);

    public void glUniform1i(int var1, int var2);

    public void glVertexAttribPointer(int var1, int var2, int var3, int var4, int var5, int var6);

    public void glViewport(int var1, int var2, int var3, int var4);
}

