/*
 * Decompiled with CFR 0.152.
 */
package javaforce.jni;

import java.io.File;
import java.io.FileInputStream;
import javaforce.JFLog;
import javaforce.pi.GPIO;

public class GPIOJNI
implements GPIO {
    private static GPIOJNI instance;

    public static GPIO getInstance() {
        if (instance == null && !(instance = new GPIOJNI()).init()) {
            instance = null;
        }
        return instance;
    }

    private boolean init() {
        try {
            File file = new File("/proc/iomem");
            if (!file.exists()) {
                throw new Exception("/proc/iomem not found");
            }
            FileInputStream fis = new FileInputStream(file);
            byte[] data = fis.readAllBytes();
            fis.close();
            String[] lns = new String(data).split("\n");
            int addr = -1;
            for (int a = 0; a < lns.length; ++a) {
                String ln = lns[a];
                if (!ln.contains("gpio")) continue;
                addr = Integer.valueOf(ln.substring(0, 8), 16);
                break;
            }
            if (addr == -1) {
                throw new Exception("GPIO not found in /proc/iomem");
            }
            return this.ninit(addr);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private native boolean ninit(int var1);

    @Override
    public native boolean gpioConfigOutput(int var1);

    @Override
    public native boolean gpioConfigInput(int var1);

    @Override
    public native boolean gpioWrite(int var1, boolean var2);

    @Override
    public native boolean gpioRead(int var1);
}

