/*
 * Decompiled with CFR 0.152.
 */
package javaforce.jni;

import java.io.File;
import javaforce.JFLog;
import javaforce.api.MediaAPI;
import javaforce.jni.JFNative;
import javaforce.jni.Library;
import javaforce.media.MediaIO;

public class MediaJNI
implements MediaAPI {
    public static MediaAPI getInstance() {
        return new MediaJNI();
    }

    private static boolean haveLibs(Library[] libs) {
        int cnt = 0;
        for (int a = 0; a < 7; ++a) {
            if (libs[a].path == null) continue;
            ++cnt;
        }
        if (libs[7].path != null) {
            ++cnt;
        } else if (libs[8].path != null) {
            ++cnt;
        }
        return cnt == 8;
    }

    @Override
    public boolean mediaInit() {
        File[] sysFolders = Library.getSysFolders();
        String ext = Library.getExt();
        Library[] libs = new Library[]{new Library("avcodec"), new Library("avdevice"), new Library("avfilter"), new Library("avformat"), new Library("avutil"), new Library("swscale"), new Library("postproc"), new Library("swresample")};
        JFNative.findLibraries(sysFolders, libs, ext);
        if (!MediaJNI.haveLibs(libs)) {
            for (int a = 0; a < libs.length; ++a) {
                if (libs[a].path != null) continue;
                System.out.println("Error:Unable to find library:" + libs[a].name + ext);
            }
            JFLog.log("MediaCoder.load() failed");
            System.exit(1);
        }
        if (!this.mediaLoadLibs(libs[0].path, libs[1].path, libs[2].path, libs[3].path, libs[4].path, libs[5].path, libs[6].path, libs[7].path)) {
            System.exit(1);
        }
        return true;
    }

    public native boolean mediaLoadLibs(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8);

    @Override
    public native void mediaSetLogging(boolean var1);

    @Override
    public native int getVideoStream(long var1);

    @Override
    public native int getAudioStream(long var1);

    @Override
    public native int getVideoCodecID(long var1);

    @Override
    public native int getAudioCodecID(long var1);

    @Override
    public native int getVideoBitRate(long var1);

    @Override
    public native int getAudioBitRate(long var1);

    @Override
    public native long inputOpenFile(String var1, String var2);

    @Override
    public native long inputOpenIO(MediaIO var1);

    @Override
    public native long getDuration(long var1);

    @Override
    public native int getVideoWidth(long var1);

    @Override
    public native int getVideoHeight(long var1);

    @Override
    public native float getVideoFrameRate(long var1);

    @Override
    public native int getVideoKeyFrameInterval(long var1);

    @Override
    public native int getAudioChannels(long var1);

    @Override
    public native int getAudioSampleRate(long var1);

    @Override
    public native boolean inputClose(long var1);

    @Override
    public native boolean inputOpenVideo(long var1, int var3, int var4);

    @Override
    public native boolean inputOpenAudio(long var1, int var3, int var4);

    @Override
    public native int inputRead(long var1);

    @Override
    public native boolean getPacketKeyFrame(long var1);

    @Override
    public native int getPacketData(long var1, byte[] var3, int var4, int var5);

    @Override
    public native boolean inputSeek(long var1, long var3);

    @Override
    public native long outputCreateFile(String var1, String var2);

    @Override
    public native long outputCreateIO(MediaIO var1, String var2);

    @Override
    public native int addVideoStream(long var1, int var3, int var4, int var5, int var6, float var7, int var8);

    @Override
    public native int addAudioStream(long var1, int var3, int var4, int var5, int var6);

    @Override
    public native boolean outputClose(long var1);

    @Override
    public native boolean writeHeader(long var1);

    @Override
    public native boolean writePacket(long var1, int var3, byte[] var4, int var5, int var6, boolean var7);

    @Override
    public native long audioDecoderStart(int var1, int var2, int var3);

    @Override
    public native void audioDecoderStop(long var1);

    @Override
    public native short[] audioDecoderDecode(long var1, byte[] var3, int var4, int var5);

    @Override
    public native int audioDecoderGetChannels(long var1);

    @Override
    public native int audioDecoderGetSampleRate(long var1);

    @Override
    public native boolean audioDecoderChange(long var1, int var3, int var4);

    @Override
    public native long audioEncoderStart(int var1, int var2, int var3, int var4);

    @Override
    public native void audioEncoderStop(long var1);

    @Override
    public native byte[] audioEncoderEncode(long var1, short[] var3, int var4, int var5);

    @Override
    public native int audioEncoderGetAudioFramesize(long var1);

    @Override
    public native long videoDecoderStart(int var1, int var2, int var3);

    @Override
    public native void videoDecoderStop(long var1);

    @Override
    public native int[] videoDecoderDecode(long var1, byte[] var3, int var4, int var5);

    @Override
    public native int videoDecoderGetWidth(long var1);

    @Override
    public native int videoDecoderGetHeight(long var1);

    @Override
    public native float videoDecoderGetFrameRate(long var1);

    @Override
    public native boolean videoDecoderChange(long var1, int var3, int var4);

    @Override
    public native long videoEncoderStart(int var1, int var2, int var3, int var4, float var5, int var6);

    @Override
    public native void videoEncoderStop(long var1);

    @Override
    public native byte[] videoEncoderEncode(long var1, int[] var3, int var4, int var5);

    @Override
    public native float compareFrames(int[] var1, int[] var2, int var3, int var4);
}

