/*
 * Decompiled with CFR 0.152.
 */
package javaforce.linux;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.linux.Linux;
import javaforce.net.Subnet4;

public class SystemdUtils {
    public static void main(String[] args) {
        Linux.detectDistro();
        if (args.length == 0) {
            SystemdUtils.usage();
            return;
        }
        switch (args[0]) {
            case "network": {
                SystemdUtils.network();
                break;
            }
            default: {
                SystemdUtils.usage();
            }
        }
    }

    private static void usage() {
        System.out.println("systemd-utils [cmd]");
        System.out.println("  cmds:");
        System.out.println("    network - setup systemd-networkd, resolved and remove legacy packages");
    }

    private static void network() {
        switch (Linux.distro) {
            case Debian: {
                switch (Linux.derived) {
                    case Unknown: {
                        SystemdUtils.network_debian();
                        return;
                    }
                }
                break;
            }
            case Fedora: {
                break;
            }
        }
        JFLog.log("This distro not supported yet");
    }

    private static void network_debian() {
        JF.exec(new String[]{"apt", "remove", "ifupdown", "network-manager", "dhcpd-base"});
        try {
            File file = new File("/etc/network/interfaces");
            if (!file.exists()) {
                JFLog.log("setup already complete");
                return;
            }
            FileInputStream fis = new FileInputStream(file);
            String[] lns = new String(fis.readAllBytes()).split("\n");
            fis.close();
            ArrayList<NIC> nics = new ArrayList<NIC>();
            NIC nic = null;
            block14: for (String ln : lns) {
                String[] fs = ln.trim().split(" ");
                if (fs.length == 0) continue;
                switch (fs[0]) {
                    case "iface": {
                        String name = fs[1];
                        String method = fs[3];
                        if (name.equals("lo")) continue block14;
                        nic = new NIC();
                        nics.add(nic);
                        nic.name = name;
                        nic.method = method;
                        continue block14;
                    }
                    case "address": {
                        nic.address = fs[1];
                        continue block14;
                    }
                    case "netmask": {
                        nic.netmask = fs[1];
                        continue block14;
                    }
                    case "gateway": {
                        nic.gateway = fs[1];
                    }
                }
            }
            SystemdUtils.write_nics(nics);
            file.delete();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        SystemdUtils.network_resolved();
        JF.exec(new String[]{"apt", "install", "systemd-resolved"});
    }

    private static void write_nics(ArrayList<NIC> nics) {
        for (NIC nic : nics) {
            File file = new File("/usr/lib/systemd/network/50-" + nic.name + ".network");
            StringBuilder cfg = new StringBuilder();
            cfg.append("[Match]\n");
            cfg.append("Name=" + nic.name + "\n");
            cfg.append("[Network]\n");
            switch (nic.method) {
                case "dhcp": {
                    cfg.append("DHCP=ipv4\n");
                    break;
                }
                case "static": {
                    cfg.append("Address=" + nic.getAddressCIDR() + "\n");
                    cfg.append("Gateway=" + nic.gateway + "\n");
                }
            }
            byte[] data = cfg.toString().getBytes();
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(data);
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    private static void network_resolved() {
        ArrayList<String> dnses = new ArrayList<String>();
        ArrayList<String> domains = new ArrayList<String>();
        try {
            File file = new File("/etc/resolv.conf");
            FileInputStream fis = new FileInputStream(file);
            String[] lns = new String(fis.readAllBytes()).split("\n");
            fis.close();
            block12: for (String ln : lns) {
                String[] fs = (ln = ln.trim()).split(" ");
                if (fs.length == 0) continue;
                switch (fs[0]) {
                    case "nameserver": {
                        int i;
                        for (i = 1; i < fs.length; ++i) {
                            dnses.add(fs[i]);
                        }
                        continue block12;
                    }
                    case "search": {
                        int i;
                        for (i = 1; i < fs.length; ++i) {
                            domains.add(fs[i]);
                        }
                        continue block12;
                    }
                }
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        StringBuilder cfg = new StringBuilder();
        cfg.append("[Resolve]\n");
        cfg.append("DNS=");
        boolean first = true;
        for (String dns : dnses) {
            if (first) {
                first = false;
            } else {
                cfg.append(" ");
            }
            cfg.append(dns);
        }
        cfg.append("\n");
        cfg.append("Domains=");
        first = true;
        for (String domain : domains) {
            if (first) {
                first = false;
            } else {
                cfg.append(" ");
            }
            cfg.append(domain);
        }
        cfg.append("\n");
        try {
            File file = new File("/etc/systemd/resolved.conf");
            if (file.exists()) {
                JFLog.log("systemd-resolved already setup");
                return;
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(cfg.toString().getBytes());
            fos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private static class NIC {
        public String name;
        public String method;
        public String address;
        public String netmask;
        public String gateway;

        private NIC() {
        }

        public String getAddressCIDR() {
            Subnet4 subnet = new Subnet4(this.address, this.netmask);
            return subnet.toStringCIDR();
        }
    }
}

