/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.api.CameraAPI;

public class Camera {
    private long ctx = 0L;
    private int[] mirror;
    private int[] flip;
    private CameraAPI api = CameraAPI.getInstance();

    public boolean init() {
        this.ctx = this.api.cameraInit();
        return this.ctx != 0L;
    }

    public boolean uninit() {
        return this.api.cameraUninit(this.ctx);
    }

    public String[] listDevices() {
        return this.api.cameraListDevices(this.ctx);
    }

    public String[] listModes(int deviceIdx) {
        return this.api.cameraListModes(this.ctx, deviceIdx);
    }

    public boolean start(int deviceIdx, int width, int height) {
        return this.api.cameraStart(this.ctx, deviceIdx, width, height);
    }

    public boolean stop() {
        return this.api.cameraStop(this.ctx);
    }

    public int[] getFrame() {
        return this.api.cameraGetFrame(this.ctx);
    }

    private int[] mirror(int[] px) {
        if (this.mirror == null || this.mirror.length != px.length) {
            this.mirror = new int[px.length];
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int src = 0;
        int dst = 0;
        for (int y = 0; y < height; ++y) {
            src += width;
            for (int x = 0; x < width; ++x) {
                this.mirror[dst++] = px[--src];
            }
            src += width;
        }
        return this.mirror;
    }

    public int[] getFrameMirror() {
        int[] px = this.api.cameraGetFrame(this.ctx);
        if (px == null) {
            return null;
        }
        return this.mirror(px);
    }

    private int[] flip(int[] px) {
        if (this.flip == null || this.flip.length != px.length) {
            this.flip = new int[px.length];
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int src = 0;
        int dst = (height - 1) * width;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.flip[dst++] = px[src++];
            }
            dst -= width * 2;
        }
        return this.flip;
    }

    public int[] getFrameFlip() {
        int[] px = this.api.cameraGetFrame(this.ctx);
        if (px == null) {
            return null;
        }
        return this.flip(px);
    }

    public int[] getFrameMirrorAndFlip() {
        int[] px = this.api.cameraGetFrame(this.ctx);
        if (px == null) {
            return null;
        }
        px = this.mirror(px);
        px = this.flip(px);
        return px;
    }

    public int getWidth() {
        return this.api.cameraGetWidth(this.ctx);
    }

    public int getHeight() {
        return this.api.cameraGetHeight(this.ctx);
    }
}

