/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.api.MediaAPI;
import javaforce.media.MediaCoder;
import javaforce.media.MediaInput;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;

public class MediaAudioDecoder
extends MediaCoder {
    public MediaAudioDecoder() {
    }

    public MediaAudioDecoder(MediaInput input) {
        this.ctx = input.ctx;
        this.shared = true;
    }

    public boolean start(int codec_id, int new_chs, int new_freq) {
        if (this.ctx != 0L || this.shared) {
            return false;
        }
        this.ctx = MediaAPI.getInstance().audioDecoderStart(codec_id, new_chs, new_freq);
        return this.ctx != 0L;
    }

    public void stop() {
        if (this.ctx == 0L || this.shared) {
            return;
        }
        MediaAPI.getInstance().audioDecoderStop(this.ctx);
        this.ctx = 0L;
    }

    public short[] decode(byte[] data, int offset, int length) {
        if (this.ctx == 0L) {
            return null;
        }
        return MediaAPI.getInstance().audioDecoderDecode(this.ctx, data, offset, length);
    }

    public short[] decode(Packet packet) {
        return this.decode(packet.data, packet.offset, packet.length);
    }

    public int getChannels() {
        if (this.ctx == 0L) {
            return -1;
        }
        return MediaAPI.getInstance().audioDecoderGetChannels(this.ctx);
    }

    public int getSampleRate() {
        if (this.ctx == 0L) {
            return -1;
        }
        return MediaAPI.getInstance().audioDecoderGetSampleRate(this.ctx);
    }

    public boolean change(CodecInfo info) {
        return MediaAPI.getInstance().audioDecoderChange(this.ctx, info.chs, info.freq);
    }
}

