/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.JFLog;
import javaforce.api.MediaAPI;
import javaforce.media.MediaCoder;
import javaforce.media.MediaOutput;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;

public class MediaAudioEncoder
extends MediaCoder {
    private Packet packet;

    public MediaAudioEncoder() {
    }

    public MediaAudioEncoder(MediaOutput output) {
        this.ctx = output.ctx;
        this.shared = true;
    }

    public boolean start(CodecInfo info) {
        if (this.ctx != 0L || this.shared) {
            return false;
        }
        this.ctx = MediaAPI.getInstance().audioEncoderStart(info.audio_codec, info.audio_bit_rate, info.chs, info.freq);
        return this.ctx != 0L;
    }

    public void stop() {
        if (this.ctx == 0L || this.shared) {
            return;
        }
        MediaAPI.getInstance().audioEncoderStop(this.ctx);
        this.ctx = 0L;
    }

    public Packet encode(short[] samples, int offset, int length) {
        if (this.ctx == 0L) {
            JFLog.log("MediaAudioEncoder no ctx");
            return null;
        }
        if (this.packet == null) {
            this.packet = new Packet();
            this.packet.stream = this.getStream();
        }
        this.packet.data = MediaAPI.getInstance().audioEncoderEncode(this.ctx, samples, offset, length);
        if (this.packet.data == null) {
            JFLog.log("MediaAudioEncoder.nencode:data == null");
            return null;
        }
        this.packet.length = this.packet.data.length;
        return this.packet;
    }

    public int getAudioFramesize() {
        return MediaAPI.getInstance().audioEncoderGetAudioFramesize(this.ctx);
    }
}

