/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.api.MediaAPI;
import javaforce.media.MediaAudioDecoder;
import javaforce.media.MediaFormat;
import javaforce.media.MediaIO;
import javaforce.media.MediaVideoDecoder;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;

public class MediaInput
extends MediaFormat {
    private Packet packet;

    public boolean open(String file, String format) {
        if (this.ctx != 0L) {
            return false;
        }
        this.ctx = MediaAPI.getInstance().inputOpenFile(file, format);
        return this.ctx != 0L;
    }

    public boolean open(MediaIO io) {
        if (this.ctx != 0L) {
            return false;
        }
        this.ctx = MediaAPI.getInstance().inputOpenIO(io);
        return this.ctx != 0L;
    }

    public long getDuration(long ctx) {
        return MediaAPI.getInstance().getDuration(ctx);
    }

    public int getVideoWidth(long ctx) {
        return MediaAPI.getInstance().getVideoWidth(ctx);
    }

    public int getVideoHeight(long ctx) {
        return MediaAPI.getInstance().getVideoHeight(ctx);
    }

    public float getVideoFrameRate(long ctx) {
        return MediaAPI.getInstance().getVideoFrameRate(ctx);
    }

    public int getVideoKeyFrameInterval(long ctx) {
        return MediaAPI.getInstance().getVideoKeyFrameInterval(ctx);
    }

    public int getAudioChannels(long ctx) {
        return MediaAPI.getInstance().getAudioChannels(ctx);
    }

    public int getAudioSampleRate(long ctx) {
        return MediaAPI.getInstance().getAudioSampleRate(ctx);
    }

    public CodecInfo getCodecInfo() {
        CodecInfo info = new CodecInfo();
        info.duration = this.getDuration(this.ctx);
        if (this.getVideoStream() != -1) {
            info.width = this.getVideoWidth(this.ctx);
            info.height = this.getVideoHeight(this.ctx);
            info.fps = this.getVideoFrameRate(this.ctx);
            info.keyFrameInterval = this.getVideoKeyFrameInterval(this.ctx);
            info.video_bit_rate = this.getVideoBitRate();
            info.video_codec = this.getVideoCodecID();
            info.video_stream = this.getVideoStream();
        }
        if (this.getAudioStream() != -1) {
            info.chs = this.getAudioChannels(this.ctx);
            info.freq = this.getAudioSampleRate(this.ctx);
            info.bits = 16;
            info.audio_bit_rate = this.getAudioBitRate();
            info.audio_codec = this.getAudioCodecID();
            info.audio_stream = this.getAudioStream();
        }
        return info;
    }

    public boolean close() {
        if (this.ctx == 0L) {
            return false;
        }
        boolean res = MediaAPI.getInstance().inputClose(this.ctx);
        this.ctx = 0L;
        return res;
    }

    public MediaVideoDecoder createVideoDecoder(int width, int height) {
        if (!MediaAPI.getInstance().inputOpenVideo(this.ctx, width, height)) {
            return null;
        }
        MediaVideoDecoder decoder = new MediaVideoDecoder(this);
        decoder.setStream(this.getVideoStream());
        return decoder;
    }

    public MediaVideoDecoder createVideoDecoder() {
        return this.createVideoDecoder(-1, -1);
    }

    public MediaAudioDecoder createAudioDecoder(int chs, int freq) {
        if (!MediaAPI.getInstance().inputOpenAudio(this.ctx, chs, freq)) {
            return null;
        }
        MediaAudioDecoder decoder = new MediaAudioDecoder(this);
        decoder.setStream(this.getAudioStream());
        return decoder;
    }

    public MediaAudioDecoder createAudioDecoder() {
        return this.createAudioDecoder(-1, -1);
    }

    public int read(long ctx) {
        return MediaAPI.getInstance().inputRead(ctx);
    }

    public boolean getPacketKeyFrame(long ctx) {
        return MediaAPI.getInstance().getPacketKeyFrame(ctx);
    }

    public int getPacketData(long ctx, byte[] data, int offset, int length) {
        return MediaAPI.getInstance().getPacketData(ctx, data, offset, length);
    }

    public Packet readPacket() {
        if (this.ctx == 0L) {
            return null;
        }
        if (this.packet == null) {
            this.packet = new Packet();
            this.packet.data = new byte[65536];
        }
        int length = this.read(this.ctx);
        while (this.packet.data.length < length) {
            this.packet.data = new byte[this.packet.data.length << 1];
        }
        this.packet.length = length;
        this.packet.keyFrame = this.getPacketKeyFrame(this.ctx);
        this.packet.stream = this.getPacketData(this.ctx, this.packet.data, 0, length);
        return this.packet;
    }

    public boolean seek(long seconds) {
        return MediaAPI.getInstance().inputSeek(this.ctx, seconds);
    }
}

