/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.JFLog;
import javaforce.api.MediaAPI;
import javaforce.media.MediaAudioEncoder;
import javaforce.media.MediaFormat;
import javaforce.media.MediaIO;
import javaforce.media.MediaVideoEncoder;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;

public class MediaOutput
extends MediaFormat {
    private boolean header;

    public boolean create(String file, String format) {
        if (this.ctx != 0L) {
            return false;
        }
        this.ctx = MediaAPI.getInstance().outputCreateFile(file, format);
        if (this.ctx == 0L) {
            JFLog.log("MediaOutput.ncreateFile() == 0");
        }
        return this.ctx != 0L;
    }

    public boolean create(MediaIO io, String format) {
        if (this.ctx != 0L) {
            return false;
        }
        this.ctx = MediaAPI.getInstance().outputCreateIO(io, format);
        if (this.ctx == 0L) {
            JFLog.log("MediaOutput.ncreateIO() == 0");
        }
        return this.ctx != 0L;
    }

    public boolean addVideoStream(CodecInfo info) {
        info.video_stream = MediaAPI.getInstance().addVideoStream(this.ctx, info.video_codec, info.video_bit_rate, info.width, info.height, info.fps, info.keyFrameInterval);
        if (info.video_stream == -1) {
            JFLog.log("addVideoStream == -1");
            return false;
        }
        if (info.video_codec == 0) {
            info.video_codec = this.getVideoCodecID();
        }
        return true;
    }

    public boolean addAudioStream(CodecInfo info) {
        info.audio_stream = MediaAPI.getInstance().addAudioStream(this.ctx, info.audio_codec, info.audio_bit_rate, info.chs, info.freq);
        if (info.audio_stream == -1) {
            JFLog.log("addAudioStream == -1");
            return false;
        }
        if (info.audio_codec == 0) {
            info.audio_codec = this.getAudioCodecID();
        }
        return true;
    }

    public MediaVideoEncoder createVideoEncoder(CodecInfo info) {
        if (!this.addVideoStream(info)) {
            return null;
        }
        MediaVideoEncoder encoder = new MediaVideoEncoder(this);
        encoder.setStream(info.video_stream);
        return encoder;
    }

    public MediaAudioEncoder createAudioEncoder(CodecInfo info) {
        if (!this.addAudioStream(info)) {
            return null;
        }
        MediaAudioEncoder encoder = new MediaAudioEncoder(this);
        encoder.setStream(info.audio_stream);
        return encoder;
    }

    public boolean close() {
        if (this.ctx == 0L) {
            return false;
        }
        boolean res = MediaAPI.getInstance().outputClose(this.ctx);
        this.ctx = 0L;
        return res;
    }

    public boolean writePacket(Packet packet) {
        if (!this.header) {
            MediaAPI.getInstance().writeHeader(this.ctx);
            this.header = true;
        }
        return MediaAPI.getInstance().writePacket(this.ctx, packet.stream, packet.data, packet.offset, packet.length, packet.keyFrame);
    }
}

