/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.api.MediaAPI;
import javaforce.media.MediaCoder;
import javaforce.media.MediaInput;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;

public class MediaVideoDecoder
extends MediaCoder {
    public MediaVideoDecoder() {
    }

    public MediaVideoDecoder(MediaInput input) {
        this.ctx = input.ctx;
        this.shared = true;
    }

    public boolean start(int codec_id, int new_width, int new_height) {
        if (this.ctx != 0L || this.shared) {
            return false;
        }
        this.ctx = MediaAPI.getInstance().videoDecoderStart(codec_id, new_width, new_height);
        return this.ctx != 0L;
    }

    public void stop() {
        if (this.ctx == 0L || this.shared) {
            return;
        }
        MediaAPI.getInstance().videoDecoderStop(this.ctx);
        this.ctx = 0L;
    }

    public int[] decode(byte[] data, int offset, int length) {
        if (this.ctx == 0L) {
            return null;
        }
        return MediaAPI.getInstance().videoDecoderDecode(this.ctx, data, offset, length);
    }

    public int[] decode(Packet packet) {
        return this.decode(packet.data, packet.offset, packet.length);
    }

    public int getWidth() {
        if (this.ctx == 0L) {
            return -1;
        }
        return MediaAPI.getInstance().videoDecoderGetWidth(this.ctx);
    }

    public int getHeight() {
        if (this.ctx == 0L) {
            return -1;
        }
        return MediaAPI.getInstance().videoDecoderGetHeight(this.ctx);
    }

    public float getFrameRate() {
        if (this.ctx == 0L) {
            return -1.0f;
        }
        return MediaAPI.getInstance().videoDecoderGetFrameRate(this.ctx);
    }

    public boolean change(CodecInfo info) {
        return MediaAPI.getInstance().videoDecoderChange(this.ctx, info.width, info.height);
    }
}

