/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.api.MediaAPI;
import javaforce.media.MediaCoder;
import javaforce.media.MediaOutput;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;

public class MediaVideoEncoder
extends MediaCoder {
    private Packet packet;

    public MediaVideoEncoder() {
    }

    public MediaVideoEncoder(MediaOutput output) {
        this.ctx = output.ctx;
        this.shared = true;
    }

    public boolean start(CodecInfo info) {
        if (this.ctx != 0L || this.shared) {
            return false;
        }
        this.ctx = MediaAPI.getInstance().videoEncoderStart(info.video_codec, info.video_bit_rate, info.width, info.height, info.fps, info.keyFrameInterval);
        return this.ctx != 0L;
    }

    public void stop() {
        if (this.ctx == 0L || this.shared) {
            return;
        }
        MediaAPI.getInstance().videoEncoderStop(this.ctx);
        this.ctx = 0L;
    }

    public Packet encode(int[] px, int offset, int length) {
        if (this.ctx == 0L) {
            return null;
        }
        if (this.packet == null) {
            this.packet = new Packet();
            this.packet.stream = this.getStream();
        }
        this.packet.data = MediaAPI.getInstance().videoEncoderEncode(this.ctx, px, offset, length);
        if (this.packet.data == null) {
            return null;
        }
        this.packet.length = this.packet.data.length;
        return this.packet;
    }
}

