/*
 * Decompiled with CFR 0.152.
 */
package javaforce.net;

import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.api.PCapAPI;
import javaforce.ffm.FFM;
import javaforce.ffm.PCapFFM;
import javaforce.jni.JFNative;
import javaforce.jni.Library;
import javaforce.jni.LnxNative;
import javaforce.jni.PCapJNI;
import javaforce.net.IP4;

public class PacketCapture {
    public static boolean debug = false;
    private PCapAPI api;
    private static byte[] local_mac;
    private static byte[] local_ip;
    public static int TYPE_IP4;
    public static int TYPE_ARP;
    public static int TYPE_IP6;
    private static PacketCapture instance;
    public static int ethernet_size;
    public static byte[] mac_broadcast;
    public static byte[] mac_zero;
    public static byte[] ip_broadcast;
    public static byte[] ip_zero;
    public static int ARP_REQUEST;
    public static int ARP_REPLY;
    public static int arp_size;

    public static PacketCapture getInstance() {
        if (instance == null) {
            instance = new PacketCapture();
            PacketCapture.instance.api = FFM.enabled() ? PCapFFM.getInstance() : PCapJNI.getInstance();
            if (!instance.init()) {
                return null;
            }
        }
        return instance;
    }

    private boolean init() {
        if (JF.isWindows()) {
            String windir = System.getenv("windir").replaceAll("\\\\", "/");
            String dll1 = windir + "/system32/npcap/packet.dll";
            String dll2 = windir + "/system32/npcap/wpcap.dll";
            if (new File(dll1).exists() && new File(dll2).exists()) {
                return this.api.pcapInit(dll1, dll2);
            }
            dll1 = windir + "/system32/packet.dll";
            dll2 = windir + "/system32/wpcap.dll";
            if (new File(dll1).exists() && new File(dll2).exists()) {
                return this.api.pcapInit(dll1, dll2);
            }
            return false;
        }
        if (JF.isUnix()) {
            Library so = new Library("pcap");
            JFNative.findLibraries(new File[]{new File("/usr/lib"), new File(LnxNative.getArchLibFolder())}, new Library[]{so}, ".so");
            return this.api.pcapInit(null, so.path);
        }
        return false;
    }

    public String[] listLocalInterfaces() {
        return this.api.pcapListLocalInterfaces();
    }

    public static String findInterface(String ip) {
        String[] ifs = PacketCapture.getInstance().listLocalInterfaces();
        if (debug) {
            JFLog.log("local interfaces:" + ifs.length + " found");
        }
        for (int a = 0; a < ifs.length; ++a) {
            String[] dev_ips = ifs[a].split("[,]");
            if (debug) {
                JFLog.log("local interface:" + dev_ips[0]);
            }
            for (int b = 1; b < dev_ips.length; ++b) {
                if (!dev_ips[b].equals(ip)) continue;
                return dev_ips[0];
            }
        }
        return null;
    }

    public long start(String local_interface, String local_ip, boolean nonblocking) {
        PacketCapture.local_ip = PacketCapture.decode_ip(local_ip);
        local_mac = PacketCapture.get_mac(local_ip);
        return this.api.pcapStart(local_interface, nonblocking);
    }

    public long start(String local_interface, String local_ip) {
        return this.start(local_interface, local_ip, true);
    }

    public void stop(long id) {
        this.api.pcapStop(id);
    }

    public boolean compile(long handle, String program) {
        return this.api.pcapCompile(handle, program);
    }

    public byte[] read(long handle) {
        return this.api.pcapRead(handle);
    }

    public boolean write(long handle, byte[] packet, int offset, int length) {
        return this.api.pcapWrite(handle, packet, offset, length);
    }

    public static void print_mac(byte[] mac) {
        if (mac == null) {
            JFLog.log("null");
            return;
        }
        for (int a = 0; a < mac.length; ++a) {
            if (a > 0) {
                System.out.print(":");
            }
            System.out.print(String.format("%02x", mac[a]));
        }
        JFLog.log("");
    }

    public static byte[] get_mac(String ip) {
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface interf = nics.nextElement();
                if (interf.isLoopback()) continue;
                Enumeration<InetAddress> nic_ips = interf.getInetAddresses();
                while (nic_ips.hasMoreElements()) {
                    String nic_ip = nic_ips.nextElement().getHostAddress();
                    if (!nic_ip.equals(ip)) continue;
                    byte[] mac = interf.getHardwareAddress();
                    if (debug) {
                        JFLog.log("IP=" + ip);
                        PacketCapture.print_mac(mac);
                    }
                    return mac;
                }
            }
            JFLog.log("Error:mac not found:" + ip);
            return mac_zero;
        }
        catch (Exception e) {
            JFLog.log("Exception:" + String.valueOf(e));
            return null;
        }
    }

    public static String build_mac(byte[] mac) {
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < mac.length; ++a) {
            if (a > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", mac[a] & 0xFF));
        }
        return sb.toString();
    }

    public static boolean valid_ip(String ip) {
        return IP4.isIP(ip);
    }

    public static byte[] decode_ip(String ip) {
        String[] ips = ip.split("[.]");
        byte[] ret = new byte[ips.length];
        for (int a = 0; a < ips.length; ++a) {
            ret[a] = (byte)Integer.valueOf(ips[a]).intValue();
        }
        return ret;
    }

    public static String build_ip(byte[] ip) {
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < ip.length; ++a) {
            if (a > 0) {
                sb.append('.');
            }
            sb.append(String.format("%d", ip[a] & 0xFF));
        }
        return sb.toString();
    }

    public static boolean compare_ip(byte[] ip1, byte[] ip2) {
        if (ip1.length != ip2.length) {
            return false;
        }
        for (int a = 0; a < ip1.length; ++a) {
            if (ip1[a] == ip2[a]) continue;
            return false;
        }
        return true;
    }

    public static void increment_ip(byte[] ip) {
        int pos = ip.length - 1;
        while ((ip[pos] & 0xFF) == 255) {
            ip[pos] = 0;
            if (--pos != -1) continue;
            pos = ip.length - 1;
        }
        int n = pos;
        ip[n] = (byte)(ip[n] + 1);
    }

    public static int get_ip_range_length(byte[] ip_start, byte[] ip_end) {
        int start32 = BE.getuint32(ip_start, 0);
        int end32 = BE.getuint32(ip_end, 0);
        if (end32 < start32) {
            return -1;
        }
        return end32 - start32 + 1;
    }

    public static void build_ethernet(byte[] pkt, byte[] dest, byte[] src, int type) {
        int offset = 0;
        System.arraycopy(dest, 0, pkt, offset, 6);
        System.arraycopy(src, 0, pkt, offset += 6, 6);
        BE.setuint16(pkt, offset += 6, type);
        offset += 2;
    }

    public static int get_ethernet_type(byte[] pkt) {
        return BE.getuint16(pkt, 12);
    }

    public static void build_arp(byte[] pkt, byte[] src_mac, byte[] src_ip, byte[] request_ip) {
        int offset = ethernet_size;
        BE.setuint16(pkt, offset, 1);
        BE.setuint16(pkt, offset += 2, 2048);
        pkt[offset += 2] = 6;
        pkt[++offset] = 4;
        BE.setuint16(pkt, ++offset, ARP_REQUEST);
        System.arraycopy(src_mac, 0, pkt, offset += 2, 6);
        System.arraycopy(src_ip, 0, pkt, offset += 6, 4);
        System.arraycopy(mac_zero, 0, pkt, offset += 4, 6);
        System.arraycopy(request_ip, 0, pkt, offset += 6, 4);
        offset += 4;
    }

    public static int get_arp_opcode(byte[] pkt) {
        return BE.getuint16(pkt, ethernet_size + 6);
    }

    public static boolean arp_ip_equals(byte[] pkt, byte[] ip) {
        int pkt_offset = ethernet_size + arp_size - 14;
        for (int a = 0; a < ip.length; ++a) {
            if (pkt[pkt_offset++] == ip[a]) continue;
            return false;
        }
        return true;
    }

    public static byte[] get_arp_mac(byte[] pkt) {
        int pkt_offset = ethernet_size + arp_size - 20;
        byte[] ret = new byte[6];
        System.arraycopy(pkt, pkt_offset, ret, 0, 6);
        return ret;
    }

    public static byte[] arp(long handle, String target_ip, int ms) {
        PacketCapture pcap = PacketCapture.getInstance();
        if (debug) {
            JFLog.log("arp.timeout=" + ms);
        }
        byte[] ip = PacketCapture.decode_ip(target_ip);
        byte[] pkt = new byte[ethernet_size + arp_size + 18];
        PacketCapture.build_ethernet(pkt, mac_broadcast, local_mac, TYPE_ARP);
        PacketCapture.build_arp(pkt, local_mac, local_ip, ip);
        if (debug) {
            JFLog.log("arp.write()");
        }
        pcap.write(handle, pkt, 0, pkt.length);
        int pkt_length = ethernet_size + arp_size;
        for (int time = 0; time < ms; time += 100) {
            do {
                if (debug) {
                    JFLog.log("arp.read()");
                }
                pkt = pcap.read(handle);
                if (debug) {
                    JFLog.log("arp.pkt=" + String.valueOf(pkt));
                }
                if (pkt == null || pkt.length < pkt_length || PacketCapture.get_ethernet_type(pkt) != TYPE_ARP || PacketCapture.get_arp_opcode(pkt) != ARP_REPLY || !PacketCapture.arp_ip_equals(pkt, ip)) continue;
                return PacketCapture.get_arp_mac(pkt);
            } while (pkt != null);
            JF.sleep(100);
        }
        return null;
    }

    static {
        TYPE_IP4 = 2048;
        TYPE_ARP = 2054;
        TYPE_IP6 = 34525;
        ethernet_size = 14;
        mac_broadcast = new byte[]{-1, -1, -1, -1, -1, -1};
        mac_zero = new byte[]{0, 0, 0, 0, 0, 0};
        ip_broadcast = new byte[]{-1, -1, -1, -1};
        ip_zero = new byte[]{0, 0, 0, 0};
        ARP_REQUEST = 1;
        ARP_REPLY = 2;
        arp_size = 28;
    }
}

