/*
 * Decompiled with CFR 0.152.
 */
package javaforce.print;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Objects;
import java.util.Random;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.ViewLog;
import javaforce.jbus.JBusClient;
import javaforce.print.JFPrintServer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class JFPrintApp
extends JFrame {
    private JTextArea config;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton save;
    private JButton viewLog;
    public ViewLog viewer;
    public JBusClient busClient;

    public JFPrintApp() {
        this.initComponents();
        JFImage img = new JFImage();
        img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/print.png"));
        new Thread(this){
            final /* synthetic */ JFPrintApp this$0;
            {
                JFPrintApp jFPrintApp = this$0;
                Objects.requireNonNull(jFPrintApp);
                this.this$0 = jFPrintApp;
            }

            @Override
            public void run() {
                Random r = new Random();
                this.this$0.busClient = new JBusClient("net.sf.jfprint.client" + r.nextInt(), new JBusMethods(this.this$0));
                this.this$0.busClient.setPort(JFPrintServer.getBusPort());
                this.this$0.busClient.start();
                this.this$0.busClient.call("net.sf.jfprint", "getConfig", "\"" + this.this$0.busClient.pack + "\"");
            }
        }.start();
        JFAWT.centerWindow(this);
    }

    public void writeConfig() {
        this.busClient.call("net.sf.jfprint", "setConfig", JBusClient.quote(JBusClient.encodeString(this.config.getText())));
    }

    public void restart() {
        this.busClient.call("net.sf.jfprint", "restart", "");
    }

    private void initComponents() {
        this.save = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.config = new JTextArea();
        this.jLabel1 = new JLabel();
        this.viewLog = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("DHCP Server");
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(this){
            final /* synthetic */ JFPrintApp this$0;
            {
                JFPrintApp jFPrintApp = this$0;
                Objects.requireNonNull(jFPrintApp);
                this.this$0 = jFPrintApp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.saveActionPerformed(evt);
            }
        });
        this.config.setColumns(20);
        this.config.setRows(5);
        this.config.setText(" [ loading ... ]");
        this.config.setEnabled(false);
        this.jScrollPane1.setViewportView(this.config);
        this.jLabel1.setText("Print Server Configuration:");
        this.viewLog.setText("View Log");
        this.viewLog.addActionListener(new ActionListener(this){
            final /* synthetic */ JFPrintApp this$0;
            {
                JFPrintApp jFPrintApp = this$0;
                Objects.requireNonNull(jFPrintApp);
                this.this$0 = jFPrintApp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.viewLogActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.viewLog).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.save)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.viewLog)).addContainerGap()));
        this.pack();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.restart();
        JFAWT.showMessage("Notice", "Settings saved!");
    }

    private void viewLogActionPerformed(ActionEvent evt) {
        this.showViewLog();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JFPrintApp().setVisible(true);
            }
        });
    }

    public void showViewLog() {
        if (this.viewer == null || this.viewer.isClosed) {
            this.viewer = new ViewLog(new File(JFPrintServer.getLogFile()));
            this.viewer.setTitle("JFPrint Log");
        }
        this.viewer.setVisible(true);
    }

    public class JBusMethods {
        final /* synthetic */ JFPrintApp this$0;

        public JBusMethods(JFPrintApp this$0) {
            JFPrintApp jFPrintApp = this$0;
            Objects.requireNonNull(jFPrintApp);
            this.this$0 = jFPrintApp;
        }

        public void getConfig(String cfg) {
            final String _cfg = cfg;
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ JBusMethods this$1;
                {
                    JBusMethods jBusMethods = this$1;
                    Objects.requireNonNull(jBusMethods);
                    this.this$1 = jBusMethods;
                }

                @Override
                public void run() {
                    this.this$1.this$0.config.setText(JBusClient.decodeString(_cfg));
                    this.this$1.this$0.config.setEnabled(true);
                    this.this$1.this$0.save.setEnabled(true);
                }
            });
        }
    }
}

